/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.repository.FileDeclarationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public class FileComponentDeclarations
extends FileComponent
implements Persistent,
SelfPersistent {
    private final TreeMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> declarations;
    private WeakReference<Map<CsmDeclaration.Kind, SortedMap<NameKey, CsmUID<CsmOffsetableDeclaration>>>> sortedDeclarations;
    private final ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private final Collection<CsmUID<CsmFunction>> staticFunctionDeclarationUIDs;
    private final Collection<CsmUID<CsmVariable>> staticVariableUIDs;
    private final ReadWriteLock staticLock = new ReentrantReadWriteLock();
    private static final FileComponentDeclarations EMPTY = new FileComponentDeclarations(){

        @Override
        public void put() {
        }
    };

    public static FileComponentDeclarations empty() {
        return EMPTY;
    }

    public FileComponentDeclarations(FileImpl fileImpl) {
        super(new FileDeclarationsKey(fileImpl));
        this.declarations = new TreeMap();
        this.staticFunctionDeclarationUIDs = new ArrayList<CsmUID<CsmFunction>>(0);
        this.staticVariableUIDs = new ArrayList<CsmUID<CsmVariable>>(0);
        this.put();
    }

    public FileComponentDeclarations(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.declarations = uIDObjectFactory.readOffsetSortedToUIDMap(dataInput, null);
        int n = dataInput.readInt();
        this.staticFunctionDeclarationUIDs = n <= 0 ? new ArrayList<CsmUID<CsmFunction>>(0) : new ArrayList<CsmUID<CsmFunction>>(n);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.staticFunctionDeclarationUIDs, dataInput, n);
        n = dataInput.readInt();
        this.staticVariableUIDs = n <= 0 ? new ArrayList<CsmUID<CsmVariable>>(0) : new ArrayList<CsmUID<CsmVariable>>(n);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.staticVariableUIDs, dataInput, n);
    }

    private FileComponentDeclarations() {
        super((Key)null);
        this.declarations = new TreeMap();
        this.staticFunctionDeclarationUIDs = new ArrayList<CsmUID<CsmFunction>>(0);
        this.staticVariableUIDs = new ArrayList<CsmUID<CsmVariable>>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmUID<CsmOffsetableDeclaration>> clean() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList;
        try {
            this.declarationsLock.writeLock().lock();
            arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.declarations.values());
            this.sortedDeclarations = null;
            this.declarations.clear();
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        try {
            this.staticLock.writeLock().lock();
            this.staticFunctionDeclarationUIDs.clear();
            this.staticVariableUIDs.clear();
        }
        finally {
            this.staticLock.writeLock().unlock();
        }
        this.put();
        return arrayList;
    }

    boolean hasDeclarations() {
        return this.declarations.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection<CsmOffsetableDeclaration> collection;
        try {
            this.declarationsLock.readLock().lock();
            Collection collection2 = this.declarations.values();
            collection = UIDCsmConverter.UIDsToDeclarations(collection2);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmOffsetableDeclaration> iterator;
        try {
            this.declarationsLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToDeclarationsFiltered(this.declarations.values(), csmFilter);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDeclarationsSize() {
        try {
            this.declarationsLock.readLock().lock();
            int n = this.declarations.size();
            return n;
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    Collection<CsmUID<CsmOffsetableDeclaration>> findDeclarations(CsmDeclaration.Kind[] kindArray, CharSequence charSequence) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList = null;
        try {
            this.declarationsLock.readLock().lock();
            EnumMap enumMap = null;
            if (this.sortedDeclarations != null) {
                enumMap = (EnumMap)this.sortedDeclarations.get();
            }
            if (enumMap == null) {
                enumMap = new EnumMap(CsmDeclaration.Kind.class);
                for (CsmUID csmUID : this.declarations.values()) {
                    void sortedMap;
                    CsmDeclaration.Kind kind = UIDUtilities.getKind(csmUID);
                    SortedMap sortedMap2 = (SortedMap)enumMap.get(kind);
                    if (sortedMap2 == null) {
                        TreeMap treeMap = new TreeMap();
                        enumMap.put(kind, treeMap);
                    }
                    sortedMap.put(new NameKey((CsmUID<CsmOffsetableDeclaration>)csmUID), csmUID);
                }
                this.sortedDeclarations = new WeakReference(enumMap);
            }
            arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
            for (CsmDeclaration.Kind kind : kindArray) {
                SortedMap sortedMap = (SortedMap)enumMap.get(kind);
                if (sortedMap == null) continue;
                if (charSequence == null) {
                    arrayList.addAll(sortedMap.values());
                    continue;
                }
                NameKey nameKey = new NameKey(charSequence, 0);
                NameKey nameKey2 = new NameKey(charSequence, Integer.MAX_VALUE);
                arrayList.addAll(sortedMap.subMap(nameKey, nameKey2).values());
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmOffsetableDeclaration findExistingDeclaration(int n, int n2, CharSequence charSequence) {
        OffsetSortedKey offsetSortedKey = new OffsetSortedKey(n, Math.abs(CharSequences.create((CharSequence)charSequence).hashCode()));
        CsmUID<CsmOffsetableDeclaration> csmUID = null;
        try {
            this.declarationsLock.readLock().lock();
            csmUID = this.declarations.get(offsetSortedKey);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        if (csmUID != null && UIDUtilities.getEndOffset(csmUID) != n2) {
            csmUID = null;
        }
        return UIDCsmConverter.UIDtoDeclaration(csmUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarations(int n, int n2) {
        List<CsmUID<CsmOffsetableDeclaration>> list;
        try {
            this.declarationsLock.readLock().lock();
            list = this.getDeclarationsByOffset(n - 1);
            OffsetSortedKey offsetSortedKey = new OffsetSortedKey(n, 0);
            OffsetSortedKey offsetSortedKey2 = new OffsetSortedKey(n2, 0);
            SortedMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> sortedMap = this.declarations.subMap(offsetSortedKey, offsetSortedKey2);
            for (Map.Entry<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> entry : sortedMap.entrySet()) {
                CsmUID<CsmOffsetableDeclaration> csmUID = entry.getValue();
                int n3 = UIDUtilities.getStartOffset(csmUID);
                int n4 = UIDUtilities.getEndOffset(csmUID);
                if (n3 >= n2) {
                    break;
                }
                if (n4 < n || n3 >= n2) continue;
                list.add(csmUID);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<CsmOffsetableDeclaration> getDeclarations(int n) {
        List list;
        try {
            this.declarationsLock.readLock().lock();
            list = this.getDeclarationsByOffset(n);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return UIDCsmConverter.UIDsToDeclarations(list).iterator();
    }

    private List<CsmUID<CsmOffsetableDeclaration>> getDeclarationsByOffset(int n) {
        SortedMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> sortedMap;
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        OffsetSortedKey offsetSortedKey = new OffsetSortedKey(n + 1, 0);
        block0: while (!(sortedMap = this.declarations.headMap(offsetSortedKey)).isEmpty()) {
            OffsetSortedKey offsetSortedKey2 = sortedMap.lastKey();
            while (offsetSortedKey2 != null) {
                CsmUID csmUID;
                int n2;
                OffsetSortedKey offsetSortedKey3;
                CsmUID<CsmOffsetableDeclaration> csmUID2 = this.declarations.get(offsetSortedKey2);
                int n3 = UIDUtilities.getStartOffset(csmUID2);
                int n4 = UIDUtilities.getEndOffset(csmUID2);
                if (n3 <= n && n <= n4) {
                    arrayList.add(0, csmUID2);
                    offsetSortedKey = offsetSortedKey2;
                    continue block0;
                }
                SortedMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> sortedMap2 = sortedMap.headMap(offsetSortedKey2);
                if (sortedMap2.isEmpty() || (offsetSortedKey3 = sortedMap2.lastKey()) == null || (n2 = UIDUtilities.getEndOffset(csmUID = (CsmUID)sortedMap.get(offsetSortedKey3))) < n4) break block0;
                offsetSortedKey2 = offsetSortedKey3;
            }
            break block0;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmFunction> getStaticFunctionDeclarations() {
        Collection<CsmFunction> collection;
        try {
            this.staticLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToDeclarations(this.staticFunctionDeclarationUIDs);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<CsmFunction> getStaticFunctionDeclarations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmFunction> iterator;
        try {
            this.staticLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToDeclarationsFiltered(this.staticFunctionDeclarationUIDs, csmFilter);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmVariable> getStaticVariableDeclarations() {
        Collection<CsmVariable> collection;
        try {
            this.staticLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToDeclarations(this.staticVariableUIDs);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<CsmVariable> getStaticVariableDeclarations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmVariable> iterator;
        try {
            this.staticLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToDeclarationsFiltered(this.staticVariableUIDs, csmFilter);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return iterator;
    }

    private OffsetSortedKey getOffsetSortKey(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        return new OffsetSortedKey(csmOffsetableDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmUID<CsmOffsetableDeclaration> addDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        OffsetableDeclarationBase offsetableDeclarationBase;
        CsmUID<CsmOffsetableDeclaration> csmUID = RepositoryUtils.put(csmOffsetableDeclaration);
        try {
            this.declarationsLock.writeLock().lock();
            this.declarations.put(this.getOffsetSortKey(csmOffsetableDeclaration), csmUID);
            this.sortedDeclarations = null;
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        if (csmOffsetableDeclaration instanceof VariableImpl && !NamespaceImpl.isNamespaceScope(offsetableDeclarationBase = (VariableImpl)csmOffsetableDeclaration, true)) {
            ((VariableImpl)offsetableDeclarationBase).setScope((CsmScope)csmOffsetableDeclaration.getContainingFile());
            this.addStaticVariableDeclaration(csmUID);
        }
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmOffsetableDeclaration) && csmOffsetableDeclaration instanceof FunctionImpl && !NamespaceImpl.isNamespaceScope(offsetableDeclarationBase = (FunctionImpl)csmOffsetableDeclaration)) {
            ((FunctionImpl)offsetableDeclarationBase).setScope((CsmScope)csmOffsetableDeclaration.getContainingFile());
            this.addStaticFunctionDeclaration(csmUID);
        }
        this.put();
        return csmUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticFunctionDeclaration(CsmUID<?> csmUID) {
        try {
            this.staticLock.writeLock().lock();
            this.staticFunctionDeclarationUIDs.add(csmUID);
        }
        finally {
            this.staticLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticVariableDeclaration(CsmUID<?> csmUID) {
        try {
            this.staticLock.writeLock().lock();
            this.staticVariableUIDs.add(csmUID);
        }
        finally {
            this.staticLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmUID<CsmOffsetableDeclaration> csmUID;
        try {
            this.declarationsLock.writeLock().lock();
            csmUID = this.declarations.remove(this.getOffsetSortKey(csmOffsetableDeclaration));
            this.sortedDeclarations = null;
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        RepositoryUtils.remove(csmUID, (CsmObject)csmOffsetableDeclaration);
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        try {
            this.declarationsLock.readLock().lock();
            uIDObjectFactory.writeOffsetSortedToUIDMap(this.declarations, dataOutput, false);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        try {
            this.staticLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.staticFunctionDeclarationUIDs, dataOutput, false);
            UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.staticVariableUIDs, dataOutput, false);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
    }

    public static class NameKey
    implements Comparable<NameKey> {
        private int start = 0;
        private CharSequence name;

        public NameKey(CsmUID<CsmOffsetableDeclaration> csmUID) {
            this.name = UIDUtilities.getName(csmUID);
            this.start = UIDUtilities.getStartOffset(csmUID);
        }

        public NameKey(CharSequence charSequence, int n) {
            this.name = charSequence;
            this.start = n;
        }

        @Override
        public int compareTo(NameKey nameKey) {
            int n = CharSequences.comparator().compare(this.name, nameKey.name);
            if (n == 0) {
                n = this.start - nameKey.start;
            }
            return n;
        }
    }

    public static final class OffsetSortedKey
    implements Comparable<OffsetSortedKey>,
    Persistent,
    SelfPersistent {
        private final int start;
        private final int name;

        public OffsetSortedKey(CsmOffsetableDeclaration csmOffsetableDeclaration) {
            this.start = csmOffsetableDeclaration.getStartOffset();
            this.name = Math.abs(csmOffsetableDeclaration.getName().hashCode());
        }

        public OffsetSortedKey(int n, int n2) {
            this.start = n;
            this.name = n2;
        }

        @Override
        public int compareTo(OffsetSortedKey offsetSortedKey) {
            int n = this.start - offsetSortedKey.start;
            if (n == 0) {
                n = this.name - offsetSortedKey.name;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof OffsetSortedKey) {
                OffsetSortedKey offsetSortedKey = (OffsetSortedKey)object;
                return this.compareTo(offsetSortedKey) == 0;
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 37 * n + this.start;
            n = 37 * n + this.name;
            return n;
        }

        public String toString() {
            return "OffsetSortedKey: " + this.name + "[" + this.start;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.start);
            dataOutput.writeInt(this.name);
        }

        public OffsetSortedKey(DataInput dataInput) throws IOException {
            this.start = dataInput.readInt();
            this.name = dataInput.readInt();
        }
    }
}

