/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public class FunctionDefinitionImpl<T>
extends FunctionImplEx<T>
implements CsmFunctionDefinition {
    private CsmUID<CsmFunction> declarationUID;
    private final CsmCompoundStatement body;
    private int parseCount;

    protected FunctionDefinitionImpl(AST aST, CsmFile csmFile, CsmScope csmScope, NameHolder nameHolder, boolean bl) throws AstRendererException {
        super(aST, csmFile, csmScope, nameHolder, bl);
        this.body = AstRenderer.findCompoundStatement(aST, this.getContainingFile(), this);
        if (this.body == null) {
            throw new AstRendererException((FileImpl)csmFile, this.getStartOffset(), "Null body in function definition.");
        }
    }

    public static <T> FunctionDefinitionImpl<T> create(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(aST);
        FunctionDefinitionImpl<T> functionDefinitionImpl = new FunctionDefinitionImpl<T>(aST, csmFile, csmScope, nameHolder, bl);
        FunctionDefinitionImpl.postObjectCreateRegistration(bl, functionDefinitionImpl);
        nameHolder.addReference(csmFile, functionDefinitionImpl);
        return functionDefinitionImpl;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    @Override
    public CsmCompoundStatement getBody() {
        return this.body;
    }

    @Override
    public CsmFunction getDeclaration() {
        CsmFunction csmFunction = this._getDeclaration();
        if (csmFunction == null || FunctionImplEx.isFakeFunction((CsmObject)csmFunction)) {
            int n = FileImpl.getParseCount();
            if (n == this.parseCount) {
                return csmFunction;
            }
            this._setDeclaration(null);
            csmFunction = this.findDeclaration();
            this._setDeclaration(csmFunction);
            this.parseCount = n;
        }
        return csmFunction;
    }

    private CsmFunction _getDeclaration() {
        CsmFunction csmFunction = UIDCsmConverter.UIDtoDeclaration(this.declarationUID);
        return csmFunction;
    }

    private void _setDeclaration(CsmFunction csmFunction) {
        this.declarationUID = UIDCsmConverter.declarationToUID(csmFunction);
        assert (this.declarationUID != null || csmFunction == null);
    }

    private CsmDeclaration fixCastOperator(CsmClass csmClass) {
        CsmMember csmMember = null;
        String string = ((Object)this.getName()).toString();
        int n = string.lastIndexOf("::");
        if (n > 0) {
            string = "operator  " + string.substring(n + 2);
        }
        Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter((CharSequence)"operator", false, true, false));
        while (iterator.hasNext()) {
            CsmMember csmMember2 = (CsmMember)iterator.next();
            String string2 = ((Object)csmMember2.getName()).toString();
            int n2 = string2.lastIndexOf("::");
            if (n2 > 0) {
                string2 = "operator  " + string2.substring(n2 + 2);
            }
            if (!string.equals(string2)) continue;
            if (csmMember == null) {
                csmMember = csmMember2;
                continue;
            }
            csmMember = null;
            break;
        }
        return csmMember;
    }

    private CsmFunction findDeclaration() {
        CsmObject csmObject;
        String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION) + ':' + this.getUniqueNameWithoutPrefix();
        Collection collection = this.getContainingFile().getProject().findDeclarations((CharSequence)string);
        if (collection.isEmpty()) {
            string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND) + ':' + this.getUniqueNameWithoutPrefix();
            collection = this.getContainingFile().getProject().findDeclarations((CharSequence)string);
        }
        Collection<Object> collection2 = new ArrayList(1);
        if (collection.isEmpty()) {
            csmObject = this.findOwner();
            if (csmObject == null) {
                csmObject = CsmBaseUtilities.getFunctionClassByQualifiedName((CsmFunction)this);
            }
            if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                CsmDeclaration csmDeclaration;
                Iterator iterator = CsmSelect.getClassMembers((CsmClass)((CsmClass)csmObject), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                collection2 = this.findByNameAndParamsNumber(iterator, this.getName(), this.getParameters().size());
                if (collection2.isEmpty() && this.isOperator() && (csmDeclaration = this.fixCastOperator((CsmClass)csmObject)) != null) {
                    collection2.add(csmDeclaration);
                }
            } else if (CsmKindUtilities.isNamespace((Object)csmObject)) {
                Iterator iterator = CsmSelect.getDeclarations((CsmNamespace)((CsmNamespace)csmObject), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                collection2 = this.findByNameAndParamsNumber(iterator, this.getName(), this.getParameters().size());
            }
        } else {
            collection2 = this.findByNameAndParamsNumber(collection.iterator(), this.getName(), this.getParameters().size());
        }
        csmObject = this.chooseDeclaration(collection2);
        return csmObject;
    }

    private Collection<CsmDeclaration> findByNameAndParamsNumber(Iterator<? extends CsmObject> iterator, CharSequence charSequence, int n) {
        ArrayList<Object> arrayList = new ArrayList<CsmDeclaration>(1);
        ArrayList<CsmFunction> arrayList2 = new ArrayList<CsmFunction>(1);
        ArrayList<CsmFunction> arrayList3 = new ArrayList<CsmFunction>(1);
        Iterator<? extends CsmObject> iterator2 = iterator;
        while (iterator2.hasNext()) {
            CsmFunction csmFunction;
            CsmObject csmObject = iterator2.next();
            if (!CsmKindUtilities.isFunction((CsmObject)csmObject) || !(csmFunction = (CsmFunction)csmObject).getName().equals(charSequence)) continue;
            if (csmFunction.getParameters().size() == n) {
                if (!FunctionImplEx.isFakeFunction((CsmObject)csmFunction) && FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)csmFunction)) {
                    arrayList2.add(csmFunction);
                    continue;
                }
                arrayList.add((CsmDeclaration)csmFunction);
                continue;
            }
            if (FunctionImplEx.isFakeFunction((CsmObject)csmFunction)) continue;
            if (FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)csmFunction)) {
                arrayList3.add(csmFunction);
            }
            arrayList.add(csmFunction);
        }
        if (!arrayList2.isEmpty()) {
            arrayList = arrayList2;
        } else if (!arrayList3.isEmpty()) {
            arrayList = arrayList3;
        }
        return arrayList;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    @Override
    protected String findQualifiedName() {
        CsmFunction csmFunction = this._getDeclaration();
        if (csmFunction != null) {
            return ((Object)csmFunction.getQualifiedName()).toString();
        }
        return super.findQualifiedName();
    }

    @Override
    public CsmScope getScope() {
        return this.getContainingFile();
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> collection = super.getScopeElements();
        collection.add((CsmScopeElement)this.getBody());
        return collection;
    }

    @Override
    public CsmFunctionDefinition getDefinition() {
        return this;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeCompoundStatement(this.body, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.declarationUID, dataOutput);
    }

    public FunctionDefinitionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.body = PersistentUtils.readCompoundStatement(dataInput);
        this.declarationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

