/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;

public abstract class ClassEnumBase<T>
extends OffsetableDeclarationBase<T>
implements Disposable,
CsmCompoundClassifier,
CsmMember {
    private final CharSequence name;
    private CharSequence qualifiedName;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private boolean isValid = true;
    private boolean _static = false;
    private CsmVisibility visibility = CsmVisibility.PRIVATE;
    private final List<CsmUID<CsmOffsetableDeclaration>> enclosingElements;

    protected ClassEnumBase(NameHolder nameHolder, CsmFile csmFile, AST aST) {
        this(nameHolder, csmFile, ClassEnumBase.getStartOffset(aST), ClassEnumBase.getEndOffset(aST));
    }

    protected ClassEnumBase(NameHolder nameHolder, CsmFile csmFile, int n, int n2) {
        super(csmFile, n, n2);
        this.enclosingElements = Collections.synchronizedList(new ArrayList(0));
        assert (nameHolder != null);
        this.name = NameCache.getManager().getString(nameHolder.getName());
    }

    protected ClassEnumBase(CharSequence charSequence, String string, CsmFile csmFile, int n, int n2) {
        super(csmFile, n, n2);
        this.enclosingElements = Collections.synchronizedList(new ArrayList(0));
        this.name = NameCache.getManager().getString(charSequence);
        this.qualifiedName = QualifiedNameCache.getManager().getString((CharSequence)string);
    }

    public static int getEndOffset(AST aST) {
        if (aST != null) {
            AST aST2 = AstUtil.findChildOfType(aST, 17);
            if (aST2 instanceof CsmAST) {
                return ((CsmAST)aST2).getEndOffset();
            }
            switch (aST.getType()) {
                case 117: 
                case 157: 
                case 158: 
                case 159: {
                    aST2 = AstUtil.findSiblingOfType(aST, 17);
                }
            }
            if (aST2 instanceof CsmAST) {
                return ((CsmAST)aST2).getEndOffset();
            }
            return OffsetableBase.getEndOffset(aST);
        }
        return 0;
    }

    public final CharSequence getName() {
        return this.name;
    }

    protected final ClassImpl.ClassMemberForwardDeclaration findClassDefinition(CsmScope csmScope) {
        if (this.name != null && ((Object)this.name).toString().indexOf("::") > 0) {
            String string = ((Object)this.name).toString();
            String string2 = string.substring(0, string.lastIndexOf("::"));
            String string3 = string.substring(string.lastIndexOf("::") + 2);
            if (CsmKindUtilities.isNamespace((Object)csmScope)) {
                CsmNamespace csmNamespace = (CsmNamespace)csmScope;
                String string4 = csmNamespace.isGlobal() ? string2 : ((Object)csmNamespace.getQualifiedName()).toString() + "::" + string2;
                Collection collection = csmNamespace.getProject().findClassifiers((CharSequence)string4);
                ClassImpl.ClassMemberForwardDeclaration classMemberForwardDeclaration = null;
                for (CsmClassifier csmClassifier : collection) {
                    CsmMember csmMember;
                    CsmClass csmClass;
                    Iterator iterator;
                    if (!CsmKindUtilities.isClass((CsmObject)csmClassifier) || !(iterator = CsmSelect.getClassMembers((CsmClass)(csmClass = (CsmClass)csmClassifier), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter((CharSequence)string3, true, true, false))).hasNext() || !((csmMember = (CsmMember)iterator.next()) instanceof ClassImpl.ClassMemberForwardDeclaration)) continue;
                    if (FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)csmMember)) {
                        classMemberForwardDeclaration = (ClassImpl.ClassMemberForwardDeclaration)csmMember;
                    }
                    if (classMemberForwardDeclaration != null) continue;
                    classMemberForwardDeclaration = (ClassImpl.ClassMemberForwardDeclaration)csmMember;
                }
                return classMemberForwardDeclaration;
            }
        }
        return null;
    }

    protected final void initScope(CsmScope csmScope) {
        if (UIDCsmConverter.isIdentifiable(csmScope)) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null) : "null UID for class scope " + csmScope;
            this.scopeRef = null;
        } else {
            this.scopeRef = csmScope;
        }
        this.initQualifiedName(csmScope);
    }

    protected final void initQualifiedName(CsmScope csmScope) {
        CharSequence charSequence = this.getQualifiedNamePostfix();
        if (CsmKindUtilities.isNamespace((Object)csmScope)) {
            this.qualifiedName = Utils.getQualifiedName(((Object)charSequence).toString(), (CsmNamespace)csmScope);
        } else if (CsmKindUtilities.isClass((CsmObject)csmScope)) {
            String string = ((Object)charSequence).toString();
            if (string.contains("::")) {
                charSequence = string.substring(string.lastIndexOf("::") + 2);
            }
            this.qualifiedName = ((CsmClass)csmScope).getQualifiedName() + "::" + charSequence;
        } else {
            this.qualifiedName = charSequence;
        }
        this.qualifiedName = QualifiedNameCache.getManager().getString(this.qualifiedName);
    }

    public abstract CsmDeclaration.Kind getKind();

    protected final void register(CsmScope csmScope, boolean bl) {
        RepositoryUtils.put(this);
        boolean bl2 = bl;
        if (Utils.canRegisterDeclaration((CsmDeclaration)this)) {
            bl2 = this.registerInProject();
        }
        if (bl2 && this.getContainingClass() == null && CsmKindUtilities.isNamespace((Object)csmScope)) {
            ((NamespaceImpl)csmScope).addDeclaration(this);
        }
    }

    @Override
    protected boolean registerInProject() {
        return ((ProjectBase)this.getContainingFile().getProject()).registerDeclaration(this);
    }

    private void unregisterInProject() {
        ((ProjectBase)this.getContainingFile().getProject()).unregisterDeclaration(this);
        this.cleanUID();
    }

    public boolean shouldBeReplaced(CsmClassifier csmClassifier) {
        return false;
    }

    public NamespaceImpl getContainingNamespaceImpl() {
        CsmScope csmScope = this.getScope();
        return csmScope instanceof NamespaceImpl ? (NamespaceImpl)csmScope : null;
    }

    public CharSequence getQualifiedName() {
        return this.qualifiedName;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    private synchronized CsmScope _getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (csmScope != null || this.scopeUID == null || !this.isValid) : "null object for UID " + this.scopeUID;
        }
        return csmScope;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.getContainingNamespaceImpl() != null) {
            this.getContainingNamespaceImpl().removeDeclaration(this);
        }
        this.unregisterInProject();
        this.isValid = false;
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            CsmScope csmScope = this.scopeRef = this.scopeRef != null ? this.scopeRef : UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid && super.isValid();
    }

    public CsmClass getContainingClass() {
        CsmScope csmScope = this.getScope();
        return CsmKindUtilities.isClass((CsmObject)csmScope) ? (CsmClass)csmScope : null;
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(CsmVisibility csmVisibility) {
        this.visibility = csmVisibility;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean bl) {
        this._static = bl;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeBoolean(this.isValid);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        assert (this.qualifiedName != null);
        PersistentUtils.writeUTF(this.qualifiedName, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
        dataOutput.writeBoolean(this._static);
        assert (this.visibility != null);
        PersistentUtils.writeVisibility(this.visibility, dataOutput);
        if (this.getName().length() == 0) {
            super.writeUID(dataOutput);
        }
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.enclosingElements, dataOutput, true);
    }

    protected ClassEnumBase(DataInput dataInput) throws IOException {
        super(dataInput);
        int n;
        this.isValid = dataInput.readBoolean();
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        this.qualifiedName = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.qualifiedName != null);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeRef = null;
        this._static = dataInput.readBoolean();
        this.visibility = PersistentUtils.readVisibility(dataInput);
        assert (this.visibility != null);
        if (this.getName().length() == 0) {
            super.readUID(dataInput);
        }
        this.enclosingElements = (n = dataInput.readInt()) < 0 ? Collections.synchronizedList(new ArrayList(0)) : Collections.synchronizedList(new ArrayList(n));
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.enclosingElements, dataInput, n);
    }

    public Collection<CsmTypedef> getEnclosingTypedefs() {
        ArrayList<CsmTypedef> arrayList = new ArrayList<CsmTypedef>(0);
        for (CsmUID<CsmOffsetableDeclaration> csmUID : this.enclosingElements) {
            CsmDeclaration csmDeclaration;
            CsmDeclaration.Kind kind = UIDUtilities.getKind(csmUID);
            if (kind != CsmDeclaration.Kind.TYPEDEF || (csmDeclaration = (CsmDeclaration)UIDCsmConverter.UIDtoCsmObject(csmUID)) == null) continue;
            arrayList.add((CsmTypedef)csmDeclaration);
        }
        return arrayList;
    }

    public Collection<CsmVariable> getEnclosingVariables() {
        ArrayList<CsmVariable> arrayList = new ArrayList<CsmVariable>(0);
        for (CsmUID<CsmOffsetableDeclaration> csmUID : this.enclosingElements) {
            CsmDeclaration csmDeclaration;
            CsmDeclaration.Kind kind = UIDUtilities.getKind(csmUID);
            if (kind != CsmDeclaration.Kind.VARIABLE || (csmDeclaration = (CsmDeclaration)UIDCsmConverter.UIDtoCsmObject(csmUID)) == null) continue;
            arrayList.add((CsmVariable)csmDeclaration);
        }
        return arrayList;
    }

    public void addEnclosingTypedef(CsmTypedef csmTypedef) {
        CsmUID csmUID = UIDs.get((Object)csmTypedef);
        this.enclosingElements.add((CsmUID<CsmOffsetableDeclaration>)csmUID);
    }

    public void addEnclosingVariable(CsmVariable csmVariable) {
        CsmUID csmUID = UIDs.get((Object)csmVariable);
        this.enclosingElements.add((CsmUID<CsmOffsetableDeclaration>)csmUID);
    }
}

