/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;

public class Keywords {
    public static final Context.Key<Keywords> keywordsKey = new Context.Key();
    private final Names names;
    private final Token[] key;
    private int maxKey = 0;
    private Name[] tokenName = new Name[Token.values().length];

    public static Keywords instance(Context context) {
        Keywords instance = context.get(keywordsKey);
        if (instance == null) {
            instance = new Keywords(context);
        }
        return instance;
    }

    protected Keywords(Context context) {
        context.put(keywordsKey, this);
        this.names = Names.instance(context);
        for (Token t : Token.values()) {
            if (t.name != null) {
                this.enterKeyword(t.name, t);
                continue;
            }
            this.tokenName[t.ordinal()] = null;
        }
        this.key = new Token[this.maxKey + 1];
        for (int i = 0; i <= this.maxKey; ++i) {
            this.key[i] = Token.IDENTIFIER;
        }
        for (Token t : Token.values()) {
            if (t.name == null) continue;
            this.key[this.tokenName[t.ordinal()].getIndex()] = t;
        }
    }

    public Token key(Name name) {
        return name.getIndex() > this.maxKey ? Token.IDENTIFIER : this.key[name.getIndex()];
    }

    private void enterKeyword(String s, Token token) {
        Name n;
        this.tokenName[token.ordinal()] = n = this.names.fromString(s);
        if (n.getIndex() > this.maxKey) {
            this.maxKey = n.getIndex();
        }
    }
}

