/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    private int shared;
    public Scope next;
    public Symbol owner;
    Entry[] table;
    int hashMask;
    public Entry elems;
    int nelems = 0;
    public ScopeCounter scopeCounter;
    static ScopeCounter dummyCounter = new ScopeCounter(){

        public void inc() {
        }
    };
    List<Scope> listeners = List.nil();
    private static final Entry sentinel = new Entry(null, null, null, null);
    private static final int INITIAL_SIZE = 16;
    public static final Scope emptyScope = new Scope(null, null, new Entry[0], dummyCounter);
    static final Filter<Symbol> noFilter = new Filter<Symbol>(){

        @Override
        public boolean accepts(Symbol s) {
            return true;
        }
    };

    private Scope(Scope next, Symbol owner, Entry[] table, ScopeCounter scopeCounter) {
        this.next = next;
        assert (emptyScope == null || owner != null);
        this.owner = owner;
        this.table = table;
        this.hashMask = table.length - 1;
        this.scopeCounter = scopeCounter;
    }

    private Scope(Scope next, Symbol owner, Entry[] table) {
        this(next, owner, table, next.scopeCounter);
        this.nelems = next.nelems;
    }

    public Scope(Symbol owner) {
        this(owner, dummyCounter);
    }

    protected Scope(Symbol owner, ScopeCounter scopeCounter) {
        this(null, owner, new Entry[16], scopeCounter);
    }

    public Scope dup() {
        return this.dup(this.owner);
    }

    public Scope dup(Symbol newOwner) {
        Scope result = new Scope(this, newOwner, this.table);
        ++this.shared;
        return result;
    }

    public Scope dupUnshared() {
        return new Scope(this, this.owner, (Entry[])this.table.clone());
    }

    public Scope leave() {
        assert (this.shared == 0);
        if (this.table != this.next.table) {
            return this.next;
        }
        while (this.elems != null) {
            int hash = this.getIndex(this.elems.sym.name);
            Entry e = this.table[hash];
            assert (e == this.elems) : this.elems.sym;
            this.table[hash] = this.elems.shadowed;
            this.elems = this.elems.sibling;
        }
        assert (this.next.shared > 0);
        --this.next.shared;
        this.next.nelems = this.nelems;
        return this.next;
    }

    private void dble() {
        assert (this.shared == 0);
        Entry[] oldtable = this.table;
        Entry[] newtable = new Entry[oldtable.length * 2];
        Scope s = this;
        while (s != null) {
            if (s.table == oldtable) {
                assert (s == this || s.shared != 0);
                s.table = newtable;
                s.hashMask = newtable.length - 1;
            }
            s = s.next;
        }
        int n = 0;
        int i = oldtable.length;
        while (--i >= 0) {
            Entry e = oldtable[i];
            if (e == null || e == sentinel) continue;
            this.table[this.getIndex((Name)e.sym.name)] = e;
            ++n;
        }
        this.nelems = n;
    }

    public void enter(Symbol sym) {
        assert (this.shared == 0);
        this.enter(sym, this);
    }

    public void enter(Symbol sym, Scope s) {
        this.enter(sym, s, s);
    }

    public void enter(Symbol sym, Scope s, Scope origin) {
        Entry e;
        int hash;
        Entry old;
        assert (this.shared == 0);
        if (this.nelems * 3 >= this.hashMask * 2) {
            this.dble();
        }
        if ((old = this.table[hash = this.getIndex(sym.name)]) == null) {
            old = sentinel;
            ++this.nelems;
        }
        this.table[hash] = e = this.makeEntry(sym, old, this.elems, s, origin);
        this.elems = e;
        this.scopeCounter.inc();
    }

    Entry makeEntry(Symbol sym, Entry shadowed, Entry sibling, Scope scope, Scope origin) {
        return new Entry(sym, shadowed, sibling, scope);
    }

    public void remove(Symbol sym) {
        assert (this.shared == 0);
        Entry e = this.lookup(sym.name);
        if (e.scope == null) {
            return;
        }
        this.scopeCounter.inc();
        int i = this.getIndex(sym.name);
        Entry te = this.table[i];
        if (te == e) {
            this.table[i] = e.shadowed;
        } else {
            while (true) {
                if (te.shadowed == e) {
                    te.shadowed = e.shadowed;
                    break;
                }
                te = te.shadowed;
            }
        }
        te = this.elems;
        if (te == e) {
            this.elems = e.sibling;
        } else {
            while (true) {
                if (te.sibling == e) {
                    te.sibling = e.sibling;
                    break;
                }
                te = te.sibling;
            }
        }
        List<Scope> l = this.listeners;
        while (l.nonEmpty()) {
            ((Scope)l.head).remove(sym);
            l = l.tail;
        }
    }

    public void enterIfAbsent(Symbol sym) {
        assert (this.shared == 0);
        Entry e = this.lookup(sym.name);
        while (e.scope == this && e.sym.kind != sym.kind) {
            e = e.next();
        }
        if (e.scope != this) {
            this.enter(sym);
        }
    }

    public boolean includes(Symbol c) {
        Entry e = this.lookup(c.name);
        while (e.scope == this) {
            if (e.sym == c) {
                return true;
            }
            e = e.next();
        }
        return false;
    }

    public Entry lookup(Name name) {
        return this.lookup(name, noFilter);
    }

    public Entry lookup(Name name, Filter<Symbol> sf) {
        Entry e = this.table[this.getIndex(name)];
        if (e == null || e == sentinel) {
            return sentinel;
        }
        while (!(e.scope == null || e.sym.name == name && sf.accepts(e.sym))) {
            e = e.shadowed;
        }
        return e;
    }

    int getIndex(Name name) {
        int h = name.hashCode();
        int i = h & this.hashMask;
        int x = this.hashMask - (h + (h >> 16) << 1);
        int d = -1;
        Entry e;
        while ((e = this.table[i]) != null) {
            if (e == sentinel) {
                if (d < 0) {
                    d = i;
                }
            } else if (e.sym.name == name) {
                return i;
            }
            i = i + x & this.hashMask;
        }
        return d >= 0 ? d : i;
    }

    public Iterable<Symbol> getElements() {
        return this.getElements(noFilter);
    }

    public Iterable<Symbol> getElements(final Filter<Symbol> sf) {
        return new Iterable<Symbol>(){

            @Override
            public Iterator<Symbol> iterator() {
                return new Iterator<Symbol>(){
                    private Scope currScope;
                    private Entry currEntry;
                    {
                        this.currScope = Scope.this;
                        this.currEntry = Scope.this.elems;
                        this.update();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currEntry != null;
                    }

                    @Override
                    public Symbol next() {
                        Symbol sym;
                        Symbol symbol = sym = this.currEntry == null ? null : this.currEntry.sym;
                        if (this.currEntry != null) {
                            this.currEntry = this.currEntry.sibling;
                        }
                        this.update();
                        return sym;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void update() {
                        this.skipToNextMatchingEntry();
                        while (this.currEntry == null && this.currScope.next != null) {
                            this.currScope = this.currScope.next;
                            this.currEntry = this.currScope.elems;
                            this.skipToNextMatchingEntry();
                        }
                    }

                    void skipToNextMatchingEntry() {
                        while (this.currEntry != null && !sf.accepts(this.currEntry.sym)) {
                            this.currEntry = this.currEntry.sibling;
                        }
                    }
                };
            }
        };
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Scope[");
        Scope s = this;
        while (s != null) {
            if (s != this) {
                result.append(" | ");
            }
            Entry e = s.elems;
            while (e != null) {
                if (e != s.elems) {
                    result.append(", ");
                }
                result.append(e.sym);
                e = e.sibling;
            }
            s = s.next;
        }
        result.append("]");
        return result.toString();
    }

    public static class ErrorScope
    extends Scope {
        ErrorScope(Scope next, Symbol errSymbol, Entry[] table) {
            super(next, errSymbol, table, dummyCounter);
        }

        public ErrorScope(Symbol errSymbol) {
            super(errSymbol);
        }

        public Scope dup() {
            return new ErrorScope(this, this.owner, this.table);
        }

        public Scope dupUnshared() {
            return new ErrorScope(this, this.owner, (Entry[])this.table.clone());
        }

        public Entry lookup(Name name) {
            Entry e = super.lookup(name);
            if (e.scope == null) {
                return new Entry(this.owner, sentinel, null, null);
            }
            return e;
        }
    }

    public static class ClassScope
    extends Scope {
        ClassScope(Scope next, Symbol owner, Entry[] table, ScopeCounter scopeCounter) {
            super(next, owner, table, scopeCounter);
        }

        public ClassScope(Symbol owner, ScopeCounter scopeCounter) {
            super(owner, scopeCounter);
        }
    }

    public static class DelegatedScope
    extends Scope {
        Scope delegatee;
        public static final Entry[] emptyTable = new Entry[0];

        public DelegatedScope(Scope outer) {
            super(outer, outer.owner, emptyTable, outer.scopeCounter);
            this.delegatee = outer;
        }

        public Scope dup() {
            return new DelegatedScope(this.next);
        }

        public Scope dupUnshared() {
            return new DelegatedScope(this.next);
        }

        public Scope leave() {
            return this.next;
        }

        public void enter(Symbol sym) {
        }

        public void enter(Symbol sym, Scope s) {
        }

        public void remove(Symbol sym) {
            throw new AssertionError(sym);
        }

        public Entry lookup(Name name) {
            return this.delegatee.lookup(name);
        }
    }

    public static class StarImportScope
    extends ImportScope {
        public StarImportScope(Symbol owner) {
            super(owner);
        }

        public void importAll(Scope fromScope) {
            Entry e = fromScope.elems;
            while (e != null) {
                if (e.sym.kind == 2 && !this.includes(e.sym)) {
                    this.enter(e.sym, fromScope);
                }
                e = e.sibling;
            }
            fromScope.listeners = fromScope.listeners.prepend(this);
        }
    }

    public static class ImportScope
    extends Scope {
        public ImportScope(Symbol owner) {
            super(owner);
        }

        Entry makeEntry(Symbol sym, Entry shadowed, Entry sibling, Scope scope, Scope origin) {
            return new ImportEntry(sym, shadowed, sibling, scope, origin);
        }

        static class ImportEntry
        extends Entry {
            private Scope origin;

            ImportEntry(Symbol sym, Entry shadowed, Entry sibling, Scope scope, Scope origin) {
                super(sym, shadowed, sibling, scope);
                this.origin = origin;
            }

            public Scope getOrigin() {
                return this.origin;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        public Symbol sym;
        private Entry shadowed;
        public Entry sibling;
        public Scope scope;

        public Entry(Symbol sym, Entry shadowed, Entry sibling, Scope scope) {
            this.sym = sym;
            this.shadowed = shadowed;
            this.sibling = sibling;
            this.scope = scope;
        }

        public Entry next() {
            return this.shadowed;
        }

        public Entry next(Filter<Symbol> sf) {
            if (this.shadowed.sym == null || sf.accepts(this.shadowed.sym)) {
                return this.shadowed;
            }
            return this.shadowed.next(sf);
        }

        public Scope getOrigin() {
            return this.scope;
        }
    }

    public static class ScopeCounter {
        protected static final Context.Key<ScopeCounter> scopeCounterKey = new Context.Key();
        private long val = 0L;

        public static ScopeCounter instance(Context context) {
            ScopeCounter instance = context.get(scopeCounterKey);
            if (instance == null) {
                instance = new ScopeCounter(context);
            }
            return instance;
        }

        protected ScopeCounter(Context context) {
            context.put(scopeCounterKey, this);
        }

        private ScopeCounter() {
        }

        public void inc() {
            ++this.val;
        }

        public long val() {
            return this.val;
        }
    }
}

