/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.translator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.modules.cnd.repository.api.RepositoryTranslation;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.util.IntToStringCache;
import org.openide.util.CharSequences;

public class RepositoryTranslatorImpl
implements RepositoryTranslation {
    private static UnitsCache unitNamesCache = null;
    private static final Object initLock = new Object();
    private static boolean loaded = false;
    private static final int DEFAULT_VERSION_OF_PERSISTENCE_MECHANIZM = 0;
    private static int version = 0;
    private static final String MASTER_INDEX_FILE_NAME = System.getProperty("netbeans.user") + File.separator + "var" + File.separator + "cache" + File.separator + "cnd" + File.separator + "model" + File.separator + "index";
    private static final String PROJECT_INDEX_FILE_NAME = "project-index";

    public int getFileIdByName(int unitId, CharSequence fileName) {
        assert (fileName != null);
        IntToStringCache unitFileNames = RepositoryTranslatorImpl.getUnitFileNames(unitId);
        return unitFileNames.getId(fileName);
    }

    public CharSequence getFileNameById(int unitId, int fileId) {
        IntToStringCache fileNames = RepositoryTranslatorImpl.getUnitFileNames(unitId);
        CharSequence fileName = fileNames.getValueById(fileId);
        return fileName;
    }

    public CharSequence getFileNameByIdSafe(int unitId, int fileId) {
        IntToStringCache fileNames = RepositoryTranslatorImpl.getUnitFileNames(unitId);
        String fileName = fileNames.containsId(fileId) ? fileNames.getValueById(fileId) : "?";
        return fileName;
    }

    public int getUnitId(CharSequence unitName) {
        if (!RepositoryTranslatorImpl.unitNamesCache.containsValue(unitName)) {
            StorageAllocator.getInstance().deleteUnitFiles(unitName, false);
        }
        return RepositoryTranslatorImpl.unitNamesCache.getId(unitName);
    }

    public CharSequence getUnitName(int unitId) {
        return RepositoryTranslatorImpl.unitNamesCache.getValueById(unitId);
    }

    public CharSequence getUnitNameSafe(int unitId) {
        return RepositoryTranslatorImpl.unitNamesCache.containsId(unitId) ? RepositoryTranslatorImpl.unitNamesCache.getValueById(unitId) : "No Index " + unitId + " in " + unitNamesCache;
    }

    private static IntToStringCache getUnitFileNames(int unitId) {
        return RepositoryTranslatorImpl.unitNamesCache.getFileNames(unitId);
    }

    private static void readMasterIndex(DataInput stream) throws IOException {
        assert (stream != null);
        unitNamesCache = new UnitsCache(stream);
    }

    private static void writeUnitsCache(DataOutput stream) throws IOException {
        assert (stream != null);
        RepositoryTranslatorImpl.unitNamesCache.write(stream);
    }

    private static boolean readUnitFilesCache(CharSequence name, DataInput stream, Set<CharSequence> antiLoop) throws IOException {
        assert (name != null);
        assert (stream != null);
        IntToStringCache filesCache = new IntToStringCache(stream);
        if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
            RepositoryTranslatorImpl.trace("Read unit files cache for %s ts=%d\n", name, filesCache.getTimestamp());
        }
        if (filesCache.getVersion() == version && UnitsCache.validateReqUnits(name, antiLoop)) {
            RepositoryTranslatorImpl.unitNamesCache.insertUnitFileCache(name, filesCache);
            return true;
        }
        filesCache = new IntToStringCache();
        if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
            RepositoryTranslatorImpl.trace("Req. units validation failed for %s. Setting ts=%d\n", name, filesCache.getTimestamp());
        }
        RepositoryTranslatorImpl.unitNamesCache.insertUnitFileCache(name, filesCache);
        return false;
    }

    private static void writeUnitFilesCache(CharSequence unitName, DataOutput stream) throws IOException {
        assert (unitName != null);
        assert (stream != null);
        int unitId = RepositoryTranslatorImpl.unitNamesCache.getId(unitName);
        IntToStringCache filesCache = RepositoryTranslatorImpl.unitNamesCache.getFileNames(unitId);
        filesCache.write(stream);
    }

    public static void closeUnit(CharSequence unitName, Set<CharSequence> requiredUnits) {
        if (requiredUnits != null) {
            UnitsCache.updateReqUnitInfo(unitName, requiredUnits);
        }
        RepositoryTranslatorImpl.storeUnitIndex(unitName);
        RepositoryTranslatorImpl.unitNamesCache.removeFileNames(unitName);
    }

    public static void shutdown() {
        RepositoryTranslatorImpl.storeMasterIndex();
        StorageAllocator.getInstance().purgeCaches();
    }

    public static void loadUnitIndex(CharSequence unitName) {
        RepositoryTranslatorImpl.loadUnitIndex(unitName, new HashSet<CharSequence>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadUnitIndex(CharSequence unitName, Set<CharSequence> antiLoop) {
        if (UnitsCache.isUnitIndexLoaded(unitName)) {
            return;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FilterInputStream dis = null;
        String unitIndexFileName = RepositoryTranslatorImpl.getUnitIndexName(unitName);
        boolean indexLoaded = false;
        try {
            if (new File(unitIndexFileName).exists()) {
                fis = new FileInputStream(unitIndexFileName);
                bis = new BufferedInputStream(fis);
                dis = new DataInputStream(bis);
                indexLoaded = RepositoryTranslatorImpl.readUnitFilesCache(unitName, (DataInput)((Object)dis), antiLoop);
            }
        }
        catch (FileNotFoundException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace();
            }
        }
        catch (Throwable tr) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                tr.printStackTrace();
            }
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                    new File(unitIndexFileName).delete();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!indexLoaded) {
            StorageAllocator.getInstance().deleteUnitFiles(unitName, false);
            RepositoryTranslatorImpl.unitNamesCache.cleanUnitData(unitName);
        }
    }

    private static String getUnitIndexName(CharSequence unitName) {
        return StorageAllocator.getInstance().getUnitStorageName(unitName) + PROJECT_INDEX_FILE_NAME;
    }

    public static void removeUnit(CharSequence unitName) {
        File file = new File(RepositoryTranslatorImpl.getUnitIndexName(unitName));
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeUnitIndex(CharSequence unitName) {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        FilterOutputStream dos = null;
        String unitIndexFileName = RepositoryTranslatorImpl.getUnitIndexName(unitName);
        boolean indexStored = false;
        try {
            fos = new FileOutputStream(unitIndexFileName, false);
            bos = new BufferedOutputStream(fos);
            dos = new DataOutputStream(bos);
            RepositoryTranslatorImpl.writeUnitFilesCache(unitName, (DataOutput)((Object)dos));
            indexStored = true;
        }
        catch (FileNotFoundException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace();
            }
        }
        catch (Throwable tr) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                tr.printStackTrace();
            }
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!indexStored) {
            StorageAllocator.getInstance().deleteUnitFiles(unitName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMasterIndex() {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(MASTER_INDEX_FILE_NAME);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            RepositoryTranslatorImpl.readMasterIndex((DataInput)((Object)dis));
        }
        catch (FileNotFoundException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace();
            }
        }
        catch (Throwable tr) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                tr.printStackTrace();
            }
        }
        finally {
            if (unitNamesCache == null) {
                unitNamesCache = new UnitsCache();
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeMasterIndex() {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            fos = new FileOutputStream(MASTER_INDEX_FILE_NAME, false);
            bos = new BufferedOutputStream(fos);
            dos = new DataOutputStream(bos);
            RepositoryTranslatorImpl.writeUnitsCache((DataOutput)((Object)dos));
        }
        catch (FileNotFoundException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace();
            }
        }
        catch (Throwable tr) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                tr.printStackTrace();
            }
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void startup(int newVersion) {
        version = newVersion;
        RepositoryTranslatorImpl.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        boolean aLoaded = loaded;
        if (!aLoaded) {
            Object object = initLock;
            synchronized (object) {
                if (!loaded) {
                    RepositoryTranslatorImpl.loadMasterIndex();
                    loaded = true;
                }
            }
        }
    }

    public static int getVersion() {
        return version;
    }

    private static void trace(String format, Object ... args) {
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = System.currentTimeMillis();
        for (int i = 0; i < args.length; ++i) {
            newArgs[i + 1] = args[i];
        }
        System.err.printf("RepositoryTranslator [%d] " + format, newArgs);
    }

    private static class UnitsCache {
        private final List<CharSequence> cache;
        private final long timestamp;
        private static ArrayList<IntToStringCache> fileNamesCaches = new ArrayList();
        private static Map<CharSequence, Long> unit2timestamp = new ConcurrentHashMap<CharSequence, Long>();
        private static Map<CharSequence, Collection<RequiredUnit>> unit2requnint = new ConcurrentHashMap<CharSequence, Collection<RequiredUnit>>();
        private final Object oneItemCacheLock = new Lock();
        private CharSequence oneItemCacheString;
        private int oneItemCacheInt;

        private static void updateReqUnitInfo(CharSequence unitName, Set<CharSequence> reqUnits) {
            for (int i = 0; i < unitNamesCache.cache.size(); ++i) {
                CharSequence uName = unitNamesCache.cache.get(i);
                long uTs = fileNamesCaches.get(i).getTimestamp();
                unit2timestamp.put(uName, uTs);
            }
            CopyOnWriteArraySet<RequiredUnit> unitReqUnits = new CopyOnWriteArraySet<RequiredUnit>();
            if (reqUnits != null) {
                for (CharSequence rUnitName : reqUnits) {
                    long ts = unit2timestamp.get(rUnitName);
                    RequiredUnit rU = new RequiredUnit(rUnitName, ts);
                    unitReqUnits.add(rU);
                }
            }
            unit2requnint.put(unitName, unitReqUnits);
        }

        private static boolean validateReqUnits(CharSequence unitName, Set<CharSequence> antiLoop) {
            if (antiLoop.contains(unitName)) {
                return true;
            }
            antiLoop.add(unitName);
            boolean result = true;
            Collection<RequiredUnit> reqUnits = unit2requnint.get(unitName);
            for (RequiredUnit rU : reqUnits) {
                Long tsL;
                if (!UnitsCache.isUnitIndexLoaded(rU.getName())) {
                    RepositoryTranslatorImpl.loadUnitIndex(rU.getName(), antiLoop);
                }
                if ((tsL = unit2timestamp.get(rU.getName())) != null) {
                    long ts = tsL;
                    if (ts == rU.getTimestamp()) continue;
                    if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                        RepositoryTranslatorImpl.trace("Req. unit validation FAILED for %s: ts(unit2timestamp)=%d, ts(unit2requnint)=%s \n", new Object[]{unitName, ts, rU.getTimestamp()});
                    }
                    result = false;
                    break;
                }
                if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                    RepositoryTranslatorImpl.trace("Req. unit validation FAILED for %s: ts=NULL\n", new Object[]{unitName});
                }
                result = false;
                break;
            }
            return result;
        }

        private static void writeRequiredUnits(CharSequence unitName, DataOutput stream) throws IOException {
            assert (unitName != null);
            assert (stream != null);
            Collection<RequiredUnit> rUnits = unit2requnint.get(unitName);
            assert (rUnits != null);
            int size = rUnits.size();
            stream.writeInt(size);
            for (RequiredUnit unit : rUnits) {
                unit.write(stream);
                if (!Stats.TRACE_REPOSITORY_TRANSLATOR) continue;
                RepositoryTranslatorImpl.trace("\t\treq.unit %s ts=%d\n", new Object[]{unit.getName(), unit.getTimestamp()});
            }
        }

        private static Collection<RequiredUnit> readRequiredUnits(DataInput stream) throws IOException {
            assert (stream != null);
            CopyOnWriteArraySet<RequiredUnit> units = new CopyOnWriteArraySet<RequiredUnit>();
            int size = stream.readInt();
            for (int i = 0; i < size; ++i) {
                RequiredUnit unit = new RequiredUnit(stream);
                units.add(unit);
                if (!Stats.TRACE_REPOSITORY_TRANSLATOR) continue;
                RepositoryTranslatorImpl.trace("\t\tRead req. unit %s ts=%d\n", new Object[]{unit.getName(), unit.getTimestamp()});
            }
            return units;
        }

        private void write(DataOutput stream) throws IOException {
            assert (this.cache != null);
            assert (stream != null);
            stream.writeInt(version);
            stream.writeLong(this.timestamp);
            int size = this.cache.size();
            stream.writeInt(size);
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                RepositoryTranslatorImpl.trace("Storing master index; size=%d\n", new Object[]{size});
            }
            for (int i = 0; i < size; ++i) {
                CharSequence value = this.cache.get(i);
                stream.writeUTF(((Object)value).toString());
                stream.writeLong(unit2timestamp.get(value));
                if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                    RepositoryTranslatorImpl.trace("\tUnit %s ts=%d\n", new Object[]{value, UnitsCache.unit2timestamp.get(value)});
                }
                UnitsCache.writeRequiredUnits(value, stream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getId(CharSequence value) {
            Object object;
            CharSequence prevString = null;
            int prevInt = 0;
            Object object2 = this.oneItemCacheLock;
            synchronized (object2) {
                prevString = this.oneItemCacheString;
                prevInt = this.oneItemCacheInt;
            }
            if (value.equals(prevString)) {
                return prevInt;
            }
            int id = this.cache.indexOf(value);
            if (id == -1) {
                object = this.cache;
                synchronized (object) {
                    id = this.cache.indexOf(value);
                    if (id == -1) {
                        id = this.makeId(value);
                    }
                }
            }
            object = this.oneItemCacheLock;
            synchronized (object) {
                this.oneItemCacheString = value;
                this.oneItemCacheInt = id;
            }
            return id;
        }

        private static boolean isUnitIndexLoaded(CharSequence unitName) {
            if (!unitNamesCache.cache.contains(unitName)) {
                return false;
            }
            int id = unitNamesCache.cache.indexOf(unitName);
            return fileNamesCaches.get(id).size() != 0;
        }

        private UnitsCache() {
            this.cache = new ArrayList<CharSequence>();
            this.timestamp = System.currentTimeMillis();
        }

        private UnitsCache(DataInput stream) throws IOException {
            assert (stream != null);
            this.cache = new ArrayList<CharSequence>();
            this.timestamp = System.currentTimeMillis();
            this.cache.clear();
            fileNamesCaches.clear();
            stream.readInt();
            stream.readLong();
            int size = stream.readInt();
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                RepositoryTranslatorImpl.trace("Reading master index (%d) elements\n", new Object[]{size});
            }
            for (int i = 0; i < size; ++i) {
                String v = stream.readUTF();
                CharSequence value = this.getFileKey(CharSequences.create((CharSequence)v));
                this.cache.add(value);
                long ts = stream.readLong();
                unit2timestamp.put(value, ts);
                if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                    RepositoryTranslatorImpl.trace("\tRead %s ts=%d\n", new Object[]{value, ts});
                }
                unit2requnint.put(value, UnitsCache.readRequiredUnits(stream));
                fileNamesCaches.add(new IntToStringCache(ts));
            }
        }

        private void insertUnitFileCache(CharSequence name, IntToStringCache filesCache) {
            int index = this.cache.indexOf(name);
            if (index == -1) {
                this.cache.add(name);
                index = this.cache.indexOf(name);
            }
            fileNamesCaches.set(index, filesCache);
            unit2timestamp.put(name, filesCache.getTimestamp());
            unit2requnint.put(name, new CopyOnWriteArraySet());
        }

        private IntToStringCache removeFileNames(CharSequence unitName) {
            IntToStringCache fileNames = null;
            int index = this.cache.indexOf(unitName);
            if (index != -1) {
                fileNames = fileNamesCaches.get(index);
                long ts = fileNames.getTimestamp();
                unit2timestamp.put(unitName, ts);
                fileNamesCaches.set(index, new IntToStringCache(ts));
            }
            return fileNames;
        }

        private int makeId(CharSequence unitName) {
            unitName = this.getFileKey(unitName);
            int id = this.cache.indexOf(null);
            IntToStringCache fileCache = new IntToStringCache();
            if (id == -1) {
                this.cache.add(unitName);
                id = this.cache.indexOf(unitName);
                fileNamesCaches.add(fileCache);
            } else {
                this.cache.set(id, unitName);
                fileNamesCaches.set(id, fileCache);
            }
            assert (fileNamesCaches.size() == this.cache.size());
            unit2requnint.put(unitName, new CopyOnWriteArraySet());
            unit2timestamp.put(unitName, fileCache.getTimestamp());
            return id;
        }

        private CharSequence getValueById(int id) {
            return this.cache.get(id);
        }

        private boolean containsId(int id) {
            return 0 <= id && id < this.cache.size();
        }

        private boolean containsValue(CharSequence value) {
            return this.cache.contains(value);
        }

        private IntToStringCache getFileNames(int unitId) {
            return fileNamesCaches.get(unitId);
        }

        private void cleanUnitData(CharSequence unitName) {
            IntToStringCache fileCache = new IntToStringCache();
            unit2requnint.put(unitName, new CopyOnWriteArraySet());
            unit2timestamp.put(unitName, fileCache.getTimestamp());
        }

        private CharSequence getFileKey(CharSequence str) {
            return str;
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    private static class RequiredUnit {
        private CharSequence unitName;
        private long timestamp;

        public RequiredUnit(CharSequence name, long time) {
            this.unitName = name;
            this.timestamp = time;
        }

        public RequiredUnit(DataInput stream) throws IOException {
            this.unitName = CharSequences.create((CharSequence)stream.readUTF());
            this.timestamp = stream.readLong();
        }

        public void write(DataOutput stream) throws IOException {
            stream.writeUTF(((Object)this.unitName).toString());
            stream.writeLong(this.timestamp);
        }

        public CharSequence getName() {
            return this.unitName;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

