/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class SizeEqualsZero {
    static final String CHECK_NOT_EQUALS = "check.not.equals";
    static final boolean CHECK_NOT_EQUALS_DEFAULT = true;
    private static final String CONF_CHECKBOX_LABEL = NbBundle.getMessage(SizeEqualsZero.class, (String)"CONF_LBL_SizeEqualsZero");
    private static final String CONF_CHECKBOX_TP = NbBundle.getMessage(SizeEqualsZero.class, (String)"CONF_TP_SizeEqualsZero");

    public static ErrorDescription sizeEqualsZero(HintContext ctx) {
        return SizeEqualsZero.sizeEqualsZeroHint(ctx, false);
    }

    public static ErrorDescription sizeNotEqualsZero(HintContext ctx) {
        if (!ctx.getPreferences().getBoolean(CHECK_NOT_EQUALS, true)) {
            return null;
        }
        return SizeEqualsZero.sizeEqualsZeroHint(ctx, true);
    }

    public static ErrorDescription sizeEqualsZeroHint(HintContext ctx, boolean not) {
        TreePath subj = ctx.getVariables().get("$subj");
        TypeMirror subjType = ctx.getInfo().getTrees().getTypeMirror(subj);
        if (subjType == null || subjType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element el = ((DeclaredType)subjType).asElement();
        if (el == null || !el.getKind().isClass() && !el.getKind().isInterface()) {
            return null;
        }
        boolean hasIsEmpty = false;
        for (ExecutableElement method : ElementFilter.methodsIn(el.getEnclosedElements())) {
            if (!method.getSimpleName().contentEquals("isEmpty") || !method.getParameters().isEmpty() || !method.getTypeParameters().isEmpty()) continue;
            hasIsEmpty = true;
            break;
        }
        if (!hasIsEmpty) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(SizeEqualsZero.class, (String)(not ? "FIX_UseIsEmptyNeg" : "FIX_UseIsEmpty"));
        Fix f = JavaFix.rewriteFix(ctx, fixDisplayName, ctx.getPath(), not ? "!$subj.isEmpty()" : "$subj.isEmpty()", new String[0]);
        String displayName = NbBundle.getMessage(SizeEqualsZero.class, (String)(not ? "ERR_SizeEqualsZeroNeg" : "ERR_SizeEqualsZero"));
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static final class CustomizerProviderImpl
    extends OneCheckboxCustomizerProvider {
        public CustomizerProviderImpl() {
            super(CONF_CHECKBOX_LABEL, CONF_CHECKBOX_TP, SizeEqualsZero.CHECK_NOT_EQUALS, true);
        }
    }
}

