/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.Bundle;
import org.netbeans.modules.java.hints.options.DepScanningSettings;
import org.netbeans.modules.java.hints.options.HintsPanelLogic;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.options.editor.spi.OptionsFilter;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class HintsPanel
extends JPanel
implements TreeCellRenderer {
    private static final RequestProcessor WORKER = new RequestProcessor(HintsPanel.class.getName(), 1, false, false);
    private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();
    private JCheckBox renderer = new JCheckBox();
    private HintsPanelLogic logic;
    private DefaultTreeModel errorTreeModel;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private HintMetadata toSelect = null;
    DefaultMutableTreeNode extraNode = new DefaultMutableTreeNode(NbBundle.getMessage(HintsPanel.class, (String)"CTL_DepScanning"));
    private JPanel customizerPanel;
    private JLabel descriptionLabel;
    private JPanel descriptionPanel;
    private JEditorPane descriptionTextArea;
    private JPanel detailsPanel;
    private JTree errorTree;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JPanel optionsPanel;
    private JComboBox severityComboBox;
    private JLabel severityLabel;
    private JCheckBox toProblemCheckBox;
    private JPanel treePanel;
    private final Map<HintMetadata, TreePath> hint2Path = new HashMap<HintMetadata, TreePath>();

    HintsPanel(final @NullAllowed OptionsFilter filter) {
        WORKER.post(new Runnable(){

            @Override
            public void run() {
                RulesManager.getInstance();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HintsPanel.this.removeAll();
                        HintsPanel.this.init(filter);
                    }
                });
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(Bundle.LBL_Loading()), new GridBagConstraints());
    }

    private void init(@NullAllowed OptionsFilter filter) {
        this.initComponents();
        this.descriptionTextArea.setContentType("text/html");
        this.errorTree.setCellRenderer(this);
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        this.errorTree.getSelectionModel().setSelectionMode(1);
        this.toProblemCheckBox.setVisible(false);
        this.errorTreeModel = this.constructTM(RulesManager.getInstance().allHints.keySet());
        if (filter != null) {
            filter.installFilteringModel(this.errorTree, (TreeModel)this.errorTreeModel, (OptionsFilter.Acceptor)new AcceptorImpl());
        } else {
            this.errorTree.setModel(this.errorTreeModel);
        }
        this.initialized.set(true);
        this.update();
        if (this.toSelect != null) {
            this.select(this.toSelect);
            this.toSelect = null;
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.treePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.errorTree = new JTree();
        this.detailsPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.severityLabel = new JLabel();
        this.severityComboBox = new JComboBox();
        this.toProblemCheckBox = new JCheckBox();
        this.customizerPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionTextArea = new JEditorPane();
        this.descriptionLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setOpaque(false);
        this.treePanel.setOpaque(false);
        this.treePanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.errorTree);
        this.errorTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleName"));
        this.errorTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleDescription"));
        this.treePanel.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.treePanel);
        this.detailsPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.detailsPanel.setOpaque(false);
        this.detailsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.severityLabel.setLabelFor(this.severityComboBox);
        Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.optionsPanel.add((Component)this.severityLabel, gridBagConstraints);
        this.severityLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.severityLabel.AccessibleContext.accessibleDescription"));
        this.severityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.optionsPanel.add((Component)this.severityComboBox, gridBagConstraints);
        this.severityComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"AN_Show_As_Combo"));
        this.severityComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"AD_Show_As_Combo"));
        Mnemonics.setLocalizedText((AbstractButton)this.toProblemCheckBox, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_InTasklist_CheckBox"));
        this.toProblemCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toProblemCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.toProblemCheckBox, gridBagConstraints);
        this.customizerPanel.setOpaque(false);
        this.customizerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.customizerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.detailsPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.descriptionPanel.setOpaque(false);
        this.descriptionPanel.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.jScrollPane2.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.descriptionPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTextArea);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.descriptionPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.detailsPanel.add((Component)this.descriptionPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.detailsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleDescription"));
    }

    synchronized void update() {
        if (!this.initialized.get()) {
            return;
        }
        if (this.logic != null) {
            this.logic.disconnect();
        }
        this.logic = new HintsPanelLogic();
        this.logic.connect(this.errorTree, this.errorTreeModel, this.severityLabel, this.severityComboBox, this.toProblemCheckBox, this.customizerPanel, this.descriptionTextArea);
    }

    void cancel() {
        if (!this.initialized.get()) {
            return;
        }
        this.logic.disconnect();
        this.logic = null;
    }

    boolean isChanged() {
        return this.logic != null ? this.logic.isChanged() : false;
    }

    void applyChanges() {
        if (!this.initialized.get()) {
            return;
        }
        this.logic.applyChanges();
        this.logic.disconnect();
        this.logic = null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.renderer.setBackground(selected ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
        this.renderer.setForeground(selected ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
        this.renderer.setEnabled(true);
        Object data = ((DefaultMutableTreeNode)value).getUserObject();
        if (data instanceof HintsPanelLogic.HintCategory) {
            HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)data;
            this.renderer.setText(cat.displayName);
            if (this.logic != null) {
                this.renderer.setSelected(this.logic.isSelected((DefaultMutableTreeNode)value));
            }
        } else if (data instanceof HintMetadata) {
            HintMetadata treeRule = (HintMetadata)data;
            this.renderer.setText(treeRule.displayName);
            if (this.logic != null) {
                Preferences node = this.logic.getCurrentPrefernces(treeRule.id);
                this.renderer.setSelected(HintsSettings.isEnabled(treeRule, node));
            }
        } else {
            this.renderer.setText(value.toString());
            if (value == this.extraNode && this.logic != null) {
                this.renderer.setSelected(this.logic.getCurrentDependencyTracking() != DepScanningSettings.DependencyTracking.DISABLED);
            }
        }
        return this.renderer;
    }

    static String getFileObjectLocalizedName(FileObject fo) {
        Object o = fo.getAttribute("SystemFileSystem.localizingBundle");
        if (o instanceof String) {
            String bundleName = (String)o;
            try {
                ResourceBundle rb = NbBundle.getBundle((String)bundleName);
                String localizedName = rb.getString(fo.getPath());
                return localizedName;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return fo.getPath();
    }

    private DefaultTreeModel constructTM(Collection<? extends HintMetadata> metadata) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        TreeMap<HintsPanelLogic.HintCategory, TreeSet<HintMetadata>> cat2Hints = new TreeMap<HintsPanelLogic.HintCategory, TreeSet<HintMetadata>>(new Comparator<HintsPanelLogic.HintCategory>(){

            @Override
            public int compare(HintsPanelLogic.HintCategory o1, HintsPanelLogic.HintCategory o2) {
                return HintsPanel.compare(o1.displayName, o2.displayName);
            }
        });
        HashMap<String, HintsPanelLogic.HintCategory> cat2CatDesc = new HashMap<String, HintsPanelLogic.HintCategory>();
        for (HintMetadata hintMetadata : metadata) {
            TreeSet<HintMetadata> catNode;
            if (hintMetadata.kind != HintMetadata.Kind.HINT && hintMetadata.kind != HintMetadata.Kind.SUGGESTION) continue;
            HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)cat2CatDesc.get(hintMetadata.category);
            if (cat == null) {
                cat = new HintsPanelLogic.HintCategory(hintMetadata.category);
                cat2CatDesc.put(hintMetadata.category, cat);
            }
            if ((catNode = (TreeSet<HintMetadata>)cat2Hints.get(cat)) == null) {
                catNode = new TreeSet<HintMetadata>(new Comparator<HintMetadata>(){

                    @Override
                    public int compare(HintMetadata o1, HintMetadata o2) {
                        return HintsPanel.compare(o1.displayName, o2.displayName);
                    }
                });
                cat2Hints.put(cat, catNode);
            }
            catNode.add(hintMetadata);
        }
        for (Map.Entry entry : cat2Hints.entrySet()) {
            DefaultMutableTreeNode catNode = new DefaultMutableTreeNode(entry.getKey());
            for (HintMetadata hm : (Collection)entry.getValue()) {
                DefaultMutableTreeNode hmNode = new DefaultMutableTreeNode(hm);
                catNode.add(hmNode);
                this.hint2Path.put(hm, new TreePath(new Object[]{root, catNode, hmNode}));
            }
            root.add(catNode);
        }
        root.add(this.extraNode);
        return new DefaultTreeModel(root);
    }

    void select(HintMetadata hm) {
        if (this.errorTree == null) {
            this.toSelect = hm;
            return;
        }
        TreePath path = this.hint2Path.get(hm);
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
    }

    private static int compare(String s1, String s2) {
        return HintsPanel.clearNonAlpha(s1).compareToIgnoreCase(HintsPanel.clearNonAlpha(s2));
    }

    private static String clearNonAlpha(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (char c : str.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static final class AcceptorImpl
    implements OptionsFilter.Acceptor {
        private AcceptorImpl() {
        }

        public boolean accept(Object originalTreeNode, String filterText) {
            if (filterText.isEmpty()) {
                return true;
            }
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)originalTreeNode;
            HintMetadata hm = (HintMetadata)n.getUserObject();
            filterText = filterText.toLowerCase();
            if (hm.displayName.toLowerCase().contains(filterText)) {
                return true;
            }
            if (hm.description.toLowerCase().contains(filterText)) {
                return true;
            }
            for (String string : hm.suppressWarnings) {
                if (!string.toLowerCase().contains(filterText)) continue;
                return true;
            }
            return false;
        }
    }
}

