/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.MatcherUtilities;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class ConvertToARM {
    private static final String AUTO_CLOSEABLE = "java.lang.AutoCloseable";
    private static final String PTR_ENC_NONE_NO_TRY = "$CV $var = $init; $stms$; $var.close();";
    private static final String PTR_ENC_NONE_NO_TRY_FIN = "final $CV $var = $init; $stms$; $var.close();";
    private static final String PTR_ENC_NONE_TRY = "$CV $var = $init; try { $stms$; } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_NONE_TRY_FIN = "final $CV $var = $init; try { $stms$; } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_NONE_TRY_NULL = "$CV $var = null; try { $var = $init; $stms$; } catch $catches$ finally {if ($var != null) $var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_NO_TRY = "$CV $var = $init; try($armres$) {$stms$;} $var.close();";
    private static final String PTR_ENC_OUT_NO_TRY_SHADOW = "$CV_x $var_x = $init_x; try($armres_x$) {$stms_x$;} $var_s.close();";
    private static final String PTR_ENC_OUT_NO_TRY_FIN = "final $CV $var = $init; try($armres$) {$stms$;} $var.close();";
    private static final String PTR_ENC_OUT_NO_TRY_FIN_SHADOW = "final $CV_x $var_x = $init_x; try($armres_x$) {$stms_x$;} $var_x.close();";
    private static final String PTR_ENC_OUT_TRY = "$CV $var = $init; try { try($armres$) {$stms$;} } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_TRY_SHADOW = "$CV_x $var_x = $init_x; try { try($armres_x$) {$stms_x$;} } catch $catches_x$ finally {$var_x.close(); $finstms_x$;}";
    private static final String PTR_ENC_OUT_TRY_FIN = "final $CV $var = $init; try { try($armres$) {$stms$;} } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_TRY_FIN_SHADOW = "final $CV_x $var_x = $init_x; try { try($armres_x$) {$stms_x$;} } catch $catches_x$ finally {$var_x.close(); $finstms_x$;}";
    private static final String PTR_ENC_OUT_TRY_NULL = "$CV $var = null; try { $var = $init; try($armres$) {$stms$;} } catch $catches$ finally {if ($var != null) $var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_TRY_NULL_SHADOW = "$CV_x $var_x = null; try { $var_x = $init_x; try($armres_x$) {$stms_x$;} } catch $catches_x$ finally {if ($var_x != null) $var_x.close(); $finstms_x$;}";
    private static final String PTR_ENC_IN_NO_TRY = "try($armres$) {$pref$; $CV $var = $init; $stms$; $var.close(); $suff$;} catch $catches$";
    private static final String PTR_ENC_IN_NO_TRY_SHADOW = "try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$";
    private static final String PTR_ENC_IN_NO_TRY2 = "try($armres$) {$pref$; $CV $var = $init; $stms$; $var.close(); $suff$;} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_NO_TRY2_SHADOW = "try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_NO_TRY_FIN = "try($armres$) {$pref$; final $CV $var = $init; $stms$; $var.close(); $suff$;} catch $catches$";
    private static final String PTR_ENC_IN_NO_TRY_FIN_SHADOW = "try($armres_x$) {final $CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$";
    private static final String PTR_ENC_IN_NO_TRY2_FIN = "try($armres$) {$pref$; final $CV $var = $init; $stms$; $var.close(); $suff$;} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_NO_TRY2_FIN_SHADOW = "try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_TRY = "try($armres$) { $CV $var = $init; try { $stms$; } finally {$var.close();}} catch $catches$";
    private static final String PTR_ENC_IN_TRY_SHADOW = "try($armres_x$) { $CV_x $var_x = $init_x; try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$";
    private static final String PTR_ENC_IN_TRY2 = "try($armres$) { $CV $var = $init; try { $stms$; } finally {$var.close();}} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_TRY2_SHADOW = "try($armres_x$) { $CV_x $var_x = $init_x; try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_TRY_FIN = "try($armres$) { final $CV $var = $init; try { $stms$; } finally {$var.close();}} catch $catches$";
    private static final String PTR_ENC_IN_TRY_FIN_SHADOW = "try($armres_x$) { final $CV_x $var_x = $init_x; try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$";
    private static final String PTR_ENC_IN_TRY2_FIN = "try($armres$) { final $CV $var = $init; try { $stms$; } finally {$var.close();}} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_TRY2_FIN_SHADOW = "try($armres_x$) { final $CV_x $var_x = $init_x; try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_TRY_NULL = "try($armres$) { $CV $var = null; try { $var = $init; $stms$; } finally {if ($var != null) $var.close();}} catch $catches$";
    private static final String PTR_ENC_IN_TRY_NULL_SHADOW = "try($armres_x$) { $CV_x $var_x = null; try { $var_x = $init_x; $stms_x$; } finally {if ($var_x != null) $var_x.close();}} catch $catches_x$";
    private static final String PTR_ENC_IN_TRY_NULL2 = "try($armres$) { $CV $var = null; try { $var = $init; $stms$; } finally {if ($var != null) $var.close();}} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_TRY_NULL2_SHADOW = "try($armres_x$) { $CV_x $var_x = null; try { $var_x = $init_x; $stms_x$; } finally {if ($var_x != null) $var_x.close();}} catch $catches_x$ finally {$finstms_x$;}";
    static boolean checkAutoCloseable = true;

    public static List<ErrorDescription> hint1(HintContext ctx) {
        if (!(MatcherUtilities.matches(ctx, ctx.getPath(), PTR_ENC_OUT_NO_TRY_SHADOW) || MatcherUtilities.matches(ctx, ctx.getPath(), PTR_ENC_OUT_NO_TRY_FIN_SHADOW) || MatcherUtilities.matches(ctx, ctx.getPath(), PTR_ENC_OUT_TRY_SHADOW) || MatcherUtilities.matches(ctx, ctx.getPath(), PTR_ENC_OUT_TRY_FIN_SHADOW) || MatcherUtilities.matches(ctx, ctx.getPath(), PTR_ENC_OUT_TRY_NULL_SHADOW) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), PTR_ENC_IN_NO_TRY_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), "try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}") && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), PTR_ENC_IN_NO_TRY_FIN_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), "try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}") && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), PTR_ENC_IN_TRY_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), PTR_ENC_IN_TRY2_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), PTR_ENC_IN_TRY_FIN_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), PTR_ENC_IN_TRY2_FIN_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), PTR_ENC_IN_TRY_NULL_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), PTR_ENC_IN_TRY_NULL2_SHADOW) && ConvertToARM.insideARM(ctx))) {
            return ConvertToARM.hintImpl(ctx, NestingKind.NONE);
        }
        return Collections.emptyList();
    }

    public static List<ErrorDescription> hint2(HintContext ctx) {
        return ConvertToARM.hintImpl(ctx, NestingKind.OUT);
    }

    public static List<ErrorDescription> hint3(HintContext ctx) {
        if (ConvertToARM.insideARM(ctx)) {
            return ConvertToARM.hintImpl(ctx, NestingKind.IN);
        }
        return Collections.emptyList();
    }

    private static List<ErrorDescription> hintImpl(HintContext ctx, NestingKind nestingKind) {
        Parameters.notNull((CharSequence)"ctx", (Object)ctx);
        Map<String, TreePath> vars = ctx.getVariables();
        TreePath varVar = vars.get("$var");
        assert (varVar != null);
        TreePath typeVar = vars.get("$CV");
        assert (typeVar != null);
        CompilationInfo info = ctx.getInfo();
        TypeMirror type = info.getTrees().getTypeMirror(typeVar);
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>(1);
        if (type != null && type.getKind() == TypeKind.DECLARED) {
            TypeElement autoCloseable = info.getElements().getTypeElement(AUTO_CLOSEABLE);
            if (!checkAutoCloseable || autoCloseable != null && info.getTypes().isSubtype(type, autoCloseable.asType())) {
                Map<String, Collection<? extends TreePath>> multiVars = ctx.getMultiVariables();
                result.add(ErrorDescriptionFactory.forName(ctx, varVar, NbBundle.getMessage(ConvertToARM.class, (String)"TXT_ConvertToARM"), JavaFix.toEditorFix(new ConvertToARMFix(info, ctx.getPath(), nestingKind, varVar, vars.get("$init"), multiVars.get("$armres$"), multiVars.get("$stms$"), multiVars.get("$catches$"), multiVars.get("$finstms$")))));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private static VariableTree removeFinal(WorkingCopy wc, VariableTree varTree) {
        ModifiersTree oldMods = varTree.getModifiers();
        if (oldMods != null && oldMods.getFlags().contains((Object)Modifier.FINAL)) {
            ModifiersTree newMods = wc.getTreeMaker().removeModifiersModifier(oldMods, Modifier.FINAL);
            wc.rewrite((Tree)oldMods, (Tree)newMods);
        }
        return varTree;
    }

    private static Collection<? extends Tree> removeFinal(WorkingCopy wc, Collection<? extends Tree> trees) {
        ArrayList<Tree> result = new ArrayList<Tree>(trees.size());
        for (Tree tree : trees) {
            result.add(tree.getKind() == Tree.Kind.VARIABLE ? ConvertToARM.removeFinal(wc, (VariableTree)tree) : tree);
        }
        return result;
    }

    private static VariableTree addInit(WorkingCopy wc, VariableTree var, ExpressionTree init) {
        ExpressionTree currentInit = var.getInitializer();
        if (currentInit.getKind() == Tree.Kind.NULL_LITERAL) {
            VariableTree newVar = wc.getTreeMaker().Variable(var.getModifiers(), (CharSequence)var.getName(), var.getType(), init);
            wc.rewrite((Tree)var, (Tree)newVar);
            return newVar;
        }
        return var;
    }

    private static TryTree findNestedARM(Collection<? extends StatementTree> stms, StatementTree var) {
        boolean state = false;
        for (StatementTree statementTree : stms) {
            if (statementTree == var) {
                state = true;
                continue;
            }
            if (!state) continue;
            if (statementTree.getKind() != Tree.Kind.TRY) break;
            TryTree tryTree = (TryTree)statementTree;
            if (tryTree.getResources() != null && !tryTree.getResources().isEmpty()) {
                return tryTree;
            }
            Iterator<? extends StatementTree> blkStms = tryTree.getBlock().getStatements().iterator();
            if (!blkStms.hasNext()) break;
            StatementTree bstm = blkStms.next();
            if (bstm.getKind() == Tree.Kind.TRY) {
                return (TryTree)bstm;
            }
            if (bstm.getKind() != Tree.Kind.EXPRESSION_STATEMENT || !blkStms.hasNext() || (bstm = blkStms.next()).getKind() != Tree.Kind.TRY) break;
            return (TryTree)bstm;
        }
        return null;
    }

    private static TryTree findEnclosingARM(TreePath varPath) {
        TreePath parent = varPath.getParentPath();
        if (parent == null || parent.getLeaf().getKind() != Tree.Kind.BLOCK) {
            return null;
        }
        if ((parent = parent.getParentPath()) == null || parent.getLeaf().getKind() != Tree.Kind.TRY) {
            return null;
        }
        return (TryTree)parent.getLeaf();
    }

    private static boolean insideARM(HintContext ctx) {
        TryTree enc = ConvertToARM.findEnclosingARM(ctx.getVariables().get("$var"));
        return enc != null && enc.getResources() != null && !enc.getResources().isEmpty();
    }

    private static enum NestingKind {
        NONE,
        IN,
        OUT;

    }

    private static final class ConvertToARMFix
    extends JavaFix {
        private final NestingKind nestingKind;
        private final TreePath init;
        private final TreePath var;
        private final Collection<? extends TreePath> armPaths;
        private final Collection<? extends TreePath> statementsPaths;
        private final Collection<? extends TreePath> catchesPaths;
        private final Collection<? extends TreePath> finStatementsPath;

        private ConvertToARMFix(CompilationInfo info, TreePath owner, NestingKind nestignKind, TreePath var, TreePath init, Collection<? extends TreePath> armPaths, Collection<? extends TreePath> statements, Collection<? extends TreePath> catches, Collection<? extends TreePath> finStatementsPath) {
            super(info, owner);
            this.nestingKind = nestignKind;
            this.var = var;
            this.init = init;
            this.armPaths = armPaths;
            this.statementsPaths = statements;
            this.catchesPaths = catches;
            this.finStatementsPath = finStatementsPath;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(ConvertToARM.class, (String)"TXT_ConvertToARM");
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, JavaFix.UpgradeUICallback callback) {
            TreeMaker tm = wc.getTreeMaker();
            if (this.nestingKind == NestingKind.NONE) {
                List statements = ConvertToARMFix.asList(this.statementsPaths);
                BlockTree block = tm.Block(statements, false);
                VariableTree varTree = ConvertToARM.addInit(wc, ConvertToARM.removeFinal(wc, (VariableTree)this.var.getLeaf()), (ExpressionTree)this.init.getLeaf());
                TryTree tryTree = tm.Try(Collections.singletonList(varTree), block, ConvertToARMFix.asList(this.catchesPaths), ConvertToARMFix.rewriteFinallyBlock(tm, this.finStatementsPath));
                wc.rewrite(tp.getLeaf(), (Tree)ConvertToARMFix.rewriteOwnerBlock(tm, ((BlockTree)tp.getLeaf()).getStatements(), (StatementTree)this.var.getLeaf(), tryTree, statements));
            } else if (this.nestingKind == NestingKind.OUT) {
                TryTree oldTry = ConvertToARM.findNestedARM(((BlockTree)tp.getLeaf()).getStatements(), (StatementTree)this.var.getLeaf());
                if (oldTry == null) {
                    return;
                }
                ArrayList<VariableTree> arm = new ArrayList<VariableTree>();
                arm.add(ConvertToARM.addInit(wc, ConvertToARM.removeFinal(wc, (VariableTree)this.var.getLeaf()), (ExpressionTree)this.init.getLeaf()));
                arm.addAll(ConvertToARM.removeFinal(wc, ConvertToARMFix.asList(this.armPaths)));
                TryTree newTry = tm.Try(arm, oldTry.getBlock(), ConvertToARMFix.asList(this.catchesPaths), ConvertToARMFix.rewriteFinallyBlock(tm, this.finStatementsPath));
                wc.rewrite(tp.getLeaf(), (Tree)ConvertToARMFix.rewriteOwnerBlock(tm, ((BlockTree)tp.getLeaf()).getStatements(), (StatementTree)this.var.getLeaf(), newTry, ConvertToARMFix.asList(this.statementsPaths)));
            } else if (this.nestingKind == NestingKind.IN) {
                TryTree oldTry = ConvertToARM.findEnclosingARM(this.var);
                if (oldTry == null) {
                    return;
                }
                ArrayList<VariableTree> arm = new ArrayList<VariableTree>(ConvertToARM.removeFinal(wc, oldTry.getResources()));
                arm.add(ConvertToARM.addInit(wc, ConvertToARM.removeFinal(wc, (VariableTree)this.var.getLeaf()), (ExpressionTree)this.init.getLeaf()));
                TryTree newTry = tm.Try(arm, tm.Block(ConvertToARMFix.asList(this.statementsPaths), false), oldTry.getCatches(), oldTry.getFinallyBlock());
                wc.rewrite((Tree)oldTry, (Tree)newTry);
            }
        }

        private static <R extends Tree> List<? extends R> asList(Collection<? extends TreePath> data) {
            if (data == null) {
                return Collections.emptyList();
            }
            ArrayList<Tree> result = new ArrayList<Tree>(data.size());
            for (TreePath treePath : data) {
                result.add(treePath.getLeaf());
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private static BlockTree rewriteOwnerBlock(TreeMaker tm, List<? extends StatementTree> originalStatements, StatementTree var, TryTree newTry, List<? extends StatementTree> oldStms) {
            ArrayList<void> statements = new ArrayList<void>(originalStatements.size());
            int state = 0;
            HashSet<? extends StatementTree> toRemove = new HashSet<StatementTree>(oldStms);
            for (StatementTree statementTree : originalStatements) {
                void var9_9;
                if (var == statementTree) {
                    state = 1;
                    continue;
                }
                if (state == 1) {
                    state = toRemove.contains(statementTree) || statementTree.getKind() == Tree.Kind.TRY && ((TryTree)statementTree).getResources() != null && !((TryTree)statementTree).getResources().isEmpty() ? 2 : 0;
                    TryTree tryTree = newTry;
                } else if (state == 2) {
                    if (toRemove.contains(statementTree)) continue;
                    state = 0;
                    continue;
                }
                statements.add(var9_9);
            }
            return tm.Block(statements, false);
        }

        private static BlockTree rewriteFinallyBlock(TreeMaker tm, Collection<? extends TreePath> paths) {
            if (paths == null || paths.isEmpty()) {
                return null;
            }
            ArrayList<StatementTree> statements = new ArrayList<StatementTree>(paths.size());
            for (TreePath treePath : paths) {
                statements.add((StatementTree)treePath.getLeaf());
            }
            BlockTree result = tm.Block(statements, false);
            return result;
        }
    }
}

