/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.AddCastFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public final class AddCast
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.prob.found.req", "compiler.err.cant.apply.symbol", "compiler.err.cant.resolve.location.args"));

    static void computeType(CompilationInfo info, int offset, TypeMirror[] tm, Tree[] typeTree, ExpressionTree[] expression, Tree[] leaf) {
        TreePath path;
        int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), path.getLeaf());
        for (path = info.getTreeUtilities().pathFor(offset + 1); path != null; path = path.getParentPath()) {
            int[] index;
            TypeMirror[] proposed;
            Tree scope = path.getLeaf();
            TypeMirror expected = null;
            Tree expectedTree = null;
            TypeMirror resolved = null;
            ExpressionTree found = null;
            if (scope.getKind() == Tree.Kind.VARIABLE && ((VariableTree)scope).getInitializer() != null) {
                expected = info.getTrees().getTypeMirror(path);
                expectedTree = ((VariableTree)scope).getType();
                found = ((VariableTree)scope).getInitializer();
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (scope.getKind() == Tree.Kind.ASSIGNMENT) {
                expected = info.getTrees().getTypeMirror(path);
                found = ((AssignmentTree)scope).getExpression();
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (scope.getKind() == Tree.Kind.RETURN) {
                Tree returnTypeTree;
                TreePath parents;
                for (parents = path; parents != null && parents.getLeaf().getKind() != Tree.Kind.METHOD; parents = parents.getParentPath()) {
                }
                if (parents != null && (returnTypeTree = ((MethodTree)parents.getLeaf()).getReturnType()) != null) {
                    expected = info.getTrees().getTypeMirror(new TreePath(parents, returnTypeTree));
                    found = ((ReturnTree)scope).getExpression();
                    resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
                }
            }
            if ((scope.getKind() == Tree.Kind.METHOD_INVOCATION || scope.getKind() == Tree.Kind.NEW_CLASS) && org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)info, (TreePath)path, (TypeMirror[])(proposed = new TypeMirror[1]), (int[])(index = new int[1])) != null) {
                expected = proposed[0];
                found = scope.getKind() == Tree.Kind.METHOD_INVOCATION ? ((MethodInvocationTree)scope).getArguments().get(index[0]) : ((NewClassTree)scope).getArguments().get(index[0]);
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (expected != null && resolved != null) {
                TypeMirror foundTM = info.getTrees().getTypeMirror(new TreePath(path, found));
                if (foundTM.getKind() == TypeKind.ERROR) {
                    foundTM = info.getTrees().getOriginalType((ErrorType)foundTM);
                }
                if (resolved.getKind() == TypeKind.ERROR) {
                    resolved = info.getTrees().getOriginalType((ErrorType)resolved);
                }
                if (foundTM.getKind() != TypeKind.EXECUTABLE && foundTM.getKind() != TypeKind.PACKAGE && foundTM.getKind() != TypeKind.NONE && foundTM.getKind() != TypeKind.OTHER) {
                    if (info.getTypeUtilities().isCastable(resolved, expected)) {
                        if (!info.getTypes().isAssignable(foundTM, expected) && foundTM.getKind() != TypeKind.ERROR && expected.getKind() != TypeKind.ERROR) {
                            tm[0] = expected;
                            typeTree[0] = expectedTree;
                            expression[0] = found;
                            leaf[0] = scope;
                        }
                    } else {
                        tm[0] = null;
                    }
                }
            }
            if (info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), scope) < (long)start) break;
        }
        if (tm[0] != null) {
            tm[0] = Utilities.resolveCapturedType(info, tm[0]);
        }
    }

    @Override
    public Set<String> getCodes() {
        return ERROR_CODES;
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        ArrayList<Fix> result = new ArrayList<Fix>();
        TypeMirror[] tm = new TypeMirror[1];
        Tree[] tmTree = new Tree[1];
        ExpressionTree[] expression = new ExpressionTree[1];
        Tree[] leaf = new Tree[1];
        AddCast.computeType(info, offset, tm, tmTree, expression, leaf);
        if (tm[0] != null && tm[0].getKind() != TypeKind.NULL) {
            int position = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), expression[0]);
            Class<? extends Tree> interf = expression[0].getKind().asInterface();
            boolean wrapWithBrackets = interf == BinaryTree.class || interf == ConditionalExpressionTree.class;
            result.add(new AddCastFix(info.getJavaSource(), Utilities.shortDisplayName(info, expression[0]), ((Object)org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)tm[0], (boolean)false)).toString(), position, wrapWithBrackets));
        }
        return result;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return AddCast.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AddCast.class, (String)"LBL_Add_Cast");
    }

    public String getDescription() {
        return NbBundle.getMessage(AddCast.class, (String)"DSC_Add_Cast");
    }
}

