/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.client;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.j2ee.ddloaders.client.ClientDataObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class ClientDataNode
extends DataNode {
    private static final String DEPLOYMENT = "deployment";
    private static final Image ERROR_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/client/error-badge.gif");
    private static final Image CLIETN_XML = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/client/DDDataIcon.gif");
    private ClientDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;

    public ClientDataNode(ClientDataObject obj) {
        this(obj, Children.LEAF);
    }

    public ClientDataNode(ClientDataObject obj, Children ch) {
        super((DataObject)obj, ch);
        this.dataObject = obj;
        this.initListeners();
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                if ("documentDTD".equals(propertyName)) {
                    ClientDataNode.this.firePropertyChange(ClientDataNode.PROPERTY_DOCUMENT_TYPE, oldValue, newValue);
                }
                if ("valid".equals(propertyName) && Boolean.TRUE.equals(newValue)) {
                    ClientDataNode.this.removePropertyChangeListener(ClientDataNode.this.ddListener);
                }
                if ("propertySets".equals(propertyName)) {
                    ClientDataNode.this.firePropertySetsChange(null, null);
                }
                if ("sax_error".equals(propertyName)) {
                    ClientDataNode.this.fireShortDescriptionChange((String)oldValue, (String)newValue);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    private ClientDataObject getDDDataObject() {
        return (ClientDataObject)this.getDataObject();
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        Sheet.Set ss = s.get("properties");
        PropertySupport.ReadOnly p = new PropertySupport.ReadOnly(PROPERTY_DOCUMENT_TYPE, String.class, NbBundle.getBundle(ClientDataNode.class).getString("PROP_documentDTD"), NbBundle.getBundle(ClientDataNode.class).getString("HINT_documentDTD")){

            public Object getValue() {
                return ClientDataNode.this.dataObject.getAppClient().getVersion();
            }
        };
        ss.put((Node.Property)p);
        s.put(ss);
        return s;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("TBD application-client.xml file");
    }

    void iconChanged() {
        this.fireIconChange();
    }

    public Image getIcon(int type) {
        if (this.dataObject.getSaxError() == null) {
            return CLIETN_XML;
        }
        return ImageUtilities.mergeImages((Image)CLIETN_XML, (Image)ERROR_BADGE, (int)6, (int)6);
    }

    public String getShortDescription() {
        SAXException saxError = this.dataObject.getSaxError();
        if (saxError == null) {
            return NbBundle.getBundle(ClientDataNode.class).getString("HINT_web_dd");
        }
        return saxError.getMessage();
    }
}

