/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.selector.nodes.web.jsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.modules.profiler.j2ee.selector.nodes.web.jsp.JSPNode;
import org.netbeans.modules.profiler.j2ee.ui.Utils;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;

public class JSPFolderNode
extends ContainerNode {
    public static final Comparator<JSPFolderNode> COMPARATOR = new Comparator<JSPFolderNode>(){

        @Override
        public int compare(JSPFolderNode o1, JSPFolderNode o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private FileObject parentFolder;

    public JSPFolderNode(FileObject folder, ContainerNode parent) {
        super(folder.getName(), (Icon)Utils.JSP_FOLDER_ICON, parent);
        this.parentFolder = folder;
    }

    protected SelectorChildren getChildren() {
        return new Children();
    }

    private static class Children
    extends GreedySelectorChildren<JSPFolderNode> {
        private Children() {
        }

        protected List<SelectorNode> prepareChildren(JSPFolderNode parent) {
            ArrayList<SelectorNode> components = new ArrayList<SelectorNode>();
            ArrayList<JSPFolderNode> folders = new ArrayList<JSPFolderNode>();
            ArrayList<JSPNode> jsps = new ArrayList<JSPNode>();
            for (FileObject child : parent.parentFolder.getChildren()) {
                if (child.isFolder()) {
                    JSPFolderNode folderNode = new JSPFolderNode(child, parent);
                    if (folderNode.isLeaf()) continue;
                    folders.add(folderNode);
                    continue;
                }
                if (!child.getExt().equalsIgnoreCase("jsp")) continue;
                jsps.add(new JSPNode(child, parent));
            }
            Collections.sort(folders, COMPARATOR);
            components.addAll(folders);
            Collections.sort(jsps, JSPNode.COMPARATOR);
            components.addAll(jsps);
            return components;
        }
    }
}

