/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.j2ee.J2EEProjectTypeProfiler;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class J2EEProfilerSPI
implements org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler,
ProgressObject,
ProfilingStateListener {
    private static final String FAILED_DETERMINE_PLATFORM_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_FailedDeterminePlatformMsg");
    private static final String FAILED_LOAD_SETTINGS_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_FailedLoadSettingsMsg");
    private static final String DIRECT_ATTACH_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_DirectAttachMsg");
    private static final String STOPPING_SERVER_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_StoppingServerMsg");
    private static final String STOPPED_SERVER_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_StoppedServerMsg");
    private static final String STOPPING_SERVER_FAILED_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_StoppingServerFailedMsg");
    private DeploymentStatus stopAgentStatus;
    private InstanceProperties lastServerInstanceProperties = null;
    private Vector listeners;
    private boolean profilerAgentShutdownProgress = false;
    private boolean profilerAgentStarting = false;
    private boolean refreshServerInstance = false;
    private boolean serverStartedFromIDE = false;
    private int STARTING_STATE_TIMEOUT = 20000;
    private int profilerAgentID = -111;
    private int profilerAgentPort = 0;
    private long profilerAgentStartingTime = -1L;

    public J2EEProfilerSPI() {
        String refreshServerInstanceProperty;
        String startingStateTimeout = System.getProperty("profiler.agent.startup.timeout");
        if (startingStateTimeout != null && !"".equals(startingStateTimeout)) {
            try {
                int timeout;
                this.STARTING_STATE_TIMEOUT = timeout = new Integer(startingStateTimeout).intValue();
                ProfilerLogger.log((String)(">>> Profiler agent startup timeout redefined to " + this.STARTING_STATE_TIMEOUT + " ms"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((refreshServerInstanceProperty = System.getProperty("profiler.serverstate.refresh")) != null && "true".equals(refreshServerInstanceProperty)) {
            this.refreshServerInstance = true;
            ProfilerLogger.log((String)">>> Profiler will update server instance after attaching to it and after stopping it.");
        }
        this.fireShutdownStartedEvent();
        if (this.refreshServerInstance) {
            Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
        }
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.stopAgentStatus;
    }

    public boolean isProfiledServerStartedFromIDE() {
        return this.serverStartedFromIDE;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return null;
    }

    public ProfilerServerSettings getSettings(String serverInstanceID) {
        return this.getSettings(serverInstanceID, true);
    }

    public ProfilerServerSettings getSettings(String serverInstanceID, boolean verbose) {
        int agentID = J2EEProjectTypeProfiler.generateAgentID();
        int agentPort = J2EEProjectTypeProfiler.generateAgentPort();
        JavaPlatform agentJavaPlatform = J2EEProjectTypeProfiler.generateAgentJavaPlatform(serverInstanceID);
        if (agentJavaPlatform == null) {
            this.lastServerInstanceProperties = null;
            return null;
        }
        String javaVersion = IDEUtils.getPlatformJDKVersion((JavaPlatform)agentJavaPlatform);
        if (javaVersion == null) {
            Profiler.getDefault().displayError(MessageFormat.format(FAILED_DETERMINE_PLATFORM_MSG, agentJavaPlatform.getDisplayName()));
            this.lastServerInstanceProperties = null;
            return null;
        }
        String localPlatform = IntegrationUtils.getLocalPlatform((int)IDEUtils.getPlatformArchitecture((JavaPlatform)agentJavaPlatform));
        String[] jvmArgs = new String[2];
        String[] env = new String[]{};
        jvmArgs[1] = "-Dnbprofiler.agentid=" + agentID;
        jvmArgs[0] = javaVersion.equals("jdk15") ? IntegrationUtils.getProfilerAgentCommandLineArgs((String)localPlatform, (String)IntegrationUtils.PLATFORM_JAVA_50, (boolean)false, (int)agentPort) : IntegrationUtils.getProfilerAgentCommandLineArgs((String)localPlatform, (String)IntegrationUtils.PLATFORM_JAVA_60, (boolean)false, (int)agentPort);
        ProfilerServerSettings profilerServerSettings = new ProfilerServerSettings(agentJavaPlatform, jvmArgs, env);
        if (verbose && ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(DIRECT_ATTACH_MSG, agentJavaPlatform.getDisplayName(), "" + agentPort), 2, 1)) != NotifyDescriptor.OK_OPTION) {
            this.lastServerInstanceProperties = null;
            return null;
        }
        Project mainProject = ProjectUtilities.getMainProject();
        if (ProjectUtilities.isJavaProject((Project)mainProject)) {
            AttachSettings attachSettings = null;
            try {
                NetBeansProfiler.getDefaultNB();
                attachSettings = NetBeansProfiler.loadAttachSettings((Project)mainProject);
            }
            catch (IOException e) {
                Profiler.getDefault().displayWarning(MessageFormat.format(FAILED_LOAD_SETTINGS_MSG, e.getMessage()));
                ProfilerLogger.log((Exception)e);
            }
            if (attachSettings == null) {
                attachSettings = new AttachSettings();
                attachSettings.setRemote(false);
                attachSettings.setDirect(true);
                NetBeansProfiler.saveAttachSettings((Project)mainProject, (AttachSettings)attachSettings);
            }
        }
        ProfilerLogger.log((String)">>> Generated settings for server startup - direct attach (blocking):");
        ProfilerLogger.log((String)profilerServerSettings.toString());
        this.lastServerInstanceProperties = InstanceProperties.getInstanceProperties((String)serverInstanceID);
        return profilerServerSettings;
    }

    public synchronized int getState() {
        int agentState = this.checkState();
        ProfilerLogger.log((String)(">>> Profiler agent [port=" + this.profilerAgentPort + ", id=" + this.profilerAgentID + "]: " + this.getPublicAgentStateString(agentState)));
        return agentState;
    }

    public boolean isStopSupported() {
        return false;
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        boolean notify = false;
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
        if (this.stopAgentStatus != null && !this.stopAgentStatus.isRunning()) {
            notify = true;
        }
        if (notify) {
            IDEUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    J2EEProfilerSPI.this.fireHandleProgressEvent(J2EEProfilerSPI.this.stopAgentStatus);
                }
            });
        }
    }

    public boolean attachProfiler(Map antProjectProperties) {
        return this.performProfilerAttach(antProjectProperties);
    }

    public void cancel() {
    }

    public void fireShutdownCompletedEvent() {
        this.fireHandleProgressEvent(new StopAgentStatus(STOPPED_SERVER_MSG, StateType.COMPLETED));
    }

    public void fireShutdownFailedEvent() {
        this.fireHandleProgressEvent(new StopAgentStatus(STOPPING_SERVER_FAILED_MSG, StateType.FAILED));
    }

    public void fireShutdownStartedEvent() {
        this.fireHandleProgressEvent(new StopAgentStatus(STOPPING_SERVER_MSG, StateType.RUNNING));
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
    }

    public void notifyStarting() {
        this.profilerAgentID = J2EEProjectTypeProfiler.getLastAgentID();
        this.profilerAgentPort = J2EEProjectTypeProfiler.getLastAgentPort();
        NetBeansProfiler.getDefaultNB().cleanForProfilingOnPort(this.profilerAgentPort);
        this.profilerAgentStartingTime = System.currentTimeMillis();
        this.profilerAgentStarting = true;
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        if (e.getNewState() == 4 && this.getState() == 4) {
            if (this.refreshServerInstance && this.lastServerInstanceProperties != null && Profiler.getDefault().getProfilingMode() == 0) {
                this.lastServerInstanceProperties.refreshServerInstance();
            }
            this.serverStartedFromIDE = true;
        }
        if (e.getNewState() == 1) {
            if (this.refreshServerInstance && this.serverStartedFromIDE && this.lastServerInstanceProperties != null) {
                this.lastServerInstanceProperties.refreshServerInstance();
            }
            this.lastServerInstanceProperties = null;
            this.serverStartedFromIDE = false;
        }
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    public ProgressObject shutdown() {
        if (this.profilerAgentShutdownProgress) {
            return this;
        }
        this.profilerAgentShutdownProgress = true;
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    J2EEProfilerSPI.this.fireShutdownStartedEvent();
                    if (J2EEProfilerSPI.this.getState() == 1) {
                        while (J2EEProfilerSPI.this.getState() == 1) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception ex) {}
                        }
                    }
                    if (J2EEProfilerSPI.this.getState() == 2) {
                        Profiler.getDefault().shutdownBlockedAgent("localhost", J2EEProfilerSPI.this.profilerAgentPort, J2EEProfilerSPI.this.profilerAgentID);
                        for (int i = 0; i < 60; ++i) {
                            if (J2EEProfilerSPI.this.getState() == 0) {
                                J2EEProfilerSPI.this.fireShutdownCompletedEvent();
                                return;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        J2EEProfilerSPI.this.fireShutdownFailedEvent();
                    } else {
                        J2EEProfilerSPI.this.fireShutdownCompletedEvent();
                    }
                }
                finally {
                    J2EEProfilerSPI.this.profilerAgentShutdownProgress = false;
                }
            }
        };
        IDEUtils.runInProfilerRequestProcessor((Runnable)task);
        return this;
    }

    public void stop() {
    }

    public void threadsMonitoringChanged() {
    }

    private String getInternalAgentStateString(int agentState) {
        if (agentState == 0) {
            return "AGENT_STATE_NOT_RUNNING";
        }
        if (agentState == 1) {
            return "AGENT_STATE_READY_DYNAMIC";
        }
        if (agentState == 2) {
            return "AGENT_STATE_READY_DIRECT";
        }
        if (agentState == 3) {
            return "AGENT_STATE_CONNECTED";
        }
        if (agentState == 4) {
            return "AGENT_STATE_DIFFERENT_ID";
        }
        if (agentState == 5) {
            return "AGENT_STATE_OTHER_SESSION_IN_PROGRESS";
        }
        return "UNKNOWN AGENT STATE";
    }

    private String getProfilingStateString(int profilingState) {
        if (profilingState == 1) {
            return "PROFILING_INACTIVE";
        }
        if (profilingState == 2) {
            return "PROFILING_STARTED";
        }
        if (profilingState == 4) {
            return "PROFILING_RUNNING";
        }
        if (profilingState == 8) {
            return "PROFILING_PAUSED";
        }
        if (profilingState == 16) {
            return "PROFILING_STOPPED";
        }
        return "UNKNOWN PROFILER STATE";
    }

    private String getPublicAgentStateString(int agentState) {
        if (agentState == 0) {
            return "STATE_INACTIVE";
        }
        if (agentState == 1) {
            return "STATE_STARTING";
        }
        if (agentState == 2) {
            return "STATE_BLOCKING";
        }
        if (agentState == 3) {
            return "STATE_RUNNING";
        }
        if (agentState == 4) {
            return "STATE_PROFILING";
        }
        return "UNKNOWN AGENT STATE";
    }

    private int checkState() {
        int currentAgentState = NetBeansProfiler.getDefault().getAgentState("localhost", this.profilerAgentPort, this.profilerAgentID);
        if (currentAgentState == 5) {
            this.profilerAgentStarting = false;
            return 0;
        }
        if (currentAgentState == 4) {
            this.profilerAgentStarting = false;
            return 0;
        }
        if (currentAgentState == 0) {
            if (this.profilerAgentStarting) {
                if (System.currentTimeMillis() > this.profilerAgentStartingTime + (long)this.STARTING_STATE_TIMEOUT) {
                    this.profilerAgentStarting = false;
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        if (currentAgentState == 2) {
            this.profilerAgentStarting = false;
            return 2;
        }
        if (currentAgentState == 1) {
            this.profilerAgentStarting = false;
            return 3;
        }
        if (currentAgentState == 3) {
            this.profilerAgentStarting = false;
            return 4;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHandleProgressEvent(DeploymentStatus status) {
        ProgressEvent evt = new ProgressEvent((Object)this, null, status);
        this.stopAgentStatus = status;
        Vector targets = null;
        J2EEProfilerSPI j2EEProfilerSPI = this;
        synchronized (j2EEProfilerSPI) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                ProgressListener target = (ProgressListener)targets.elementAt(i);
                target.handleProgressEvent(evt);
            }
        }
    }

    private boolean performProfilerAttach(Map props) {
        FileObject projectFO;
        Project profiledProject = null;
        String projectDir = (String)props.get("profiler.info.project.dir");
        if (projectDir != null && (projectFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(projectDir)))) != null) {
            try {
                profiledProject = ProjectManager.getDefault().findProject(projectFO);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                this.lastServerInstanceProperties = null;
                return false;
            }
        }
        final Project projectToUse = profiledProject;
        final ProfilingSettings ps = new ProfilingSettings();
        final SessionSettings ss = new SessionSettings();
        ps.load(props);
        ss.load(props);
        ProjectTypeProfiler ptp = (ProjectTypeProfiler)projectToUse.getLookup().lookup(ProjectTypeProfiler.class);
        if (ptp == null || !ptp.isProfilingSupported(projectToUse)) {
            this.lastServerInstanceProperties = null;
            return false;
        }
        this.lastServerInstanceProperties = InstanceProperties.getInstanceProperties((String)J2EEProjectTypeProfiler.getServerInstanceID(projectToUse));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((NetBeansProfiler)Profiler.getDefault()).setProfiledProject(projectToUse, null);
                if (!Profiler.getDefault().connectToStartedApp(ps, ss)) {
                    ProfilerLogger.severe((String)"Error connecting to started app");
                }
            }
        });
        return true;
    }

    private class StopAgentStatus
    implements DeploymentStatus {
        private StateType state;
        private String message;

        public StopAgentStatus(String msg, StateType stype) {
            int lastEx = msg.lastIndexOf("Exception:");
            this.message = lastEx > 0 ? msg.substring(lastEx + "Exception:".length()) : msg;
            this.state = stype;
        }

        public ActionType getAction() {
            return ActionType.EXECUTE;
        }

        public CommandType getCommand() {
            return CommandType.STOP;
        }

        public boolean isCompleted() {
            return this.state == StateType.COMPLETED;
        }

        public boolean isFailed() {
            return this.state == StateType.FAILED;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isRunning() {
            return this.state == StateType.RUNNING;
        }

        public StateType getState() {
            return this.state;
        }
    }
}

