/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.nodes.DecoratorManager;
import org.netbeans.modules.glassfish.common.nodes.Hk2ApplicationNode;
import org.netbeans.modules.glassfish.common.nodes.Hk2ItemNode;
import org.netbeans.modules.glassfish.common.nodes.Refreshable;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class Hk2ApplicationsChildren
extends Children.Keys<Object>
implements Refreshable {
    private Lookup lookup;
    private static final Node WAIT_NODE = Hk2ItemNode.createWaitNode();

    Hk2ApplicationsChildren(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void updateKeys() {
        this.setKeys(new Object[]{WAIT_NODE});
        RequestProcessor t = new RequestProcessor("app-child-updater");
        t.post(new Runnable(){
            Vector<Object> keys = new Vector();

            @Override
            public void run() {
                GlassfishModule commonSupport = (GlassfishModule)Hk2ApplicationsChildren.this.lookup.lookup(GlassfishModule.class);
                if (commonSupport != null) {
                    try {
                        Map<String, String> ip = commonSupport.getInstanceProperties();
                        CommandRunner mgr = new CommandRunner(true, commonSupport.getCommandFactory(), ip, new OperationStateListener[0]);
                        Map<String, List<AppDesc>> appMap = mgr.getApplications(null);
                        for (Map.Entry<String, List<AppDesc>> entry : appMap.entrySet()) {
                            List<AppDesc> apps = entry.getValue();
                            for (AppDesc app : apps) {
                                this.keys.add((Object)new Hk2ApplicationNode(Hk2ApplicationsChildren.this.lookup, app, DecoratorManager.findDecorator(entry.getKey(), Hk2ItemNode.J2EE_APPLICATION, app.getEnabled())));
                            }
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    Hk2ApplicationsChildren.this.setKeys(this.keys);
                }
            }
        }, 0);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof Hk2ItemNode) {
            return new Node[]{(Hk2ItemNode)((Object)key)};
        }
        if (key instanceof String && key.equals(WAIT_NODE)) {
            return new Node[]{WAIT_NODE};
        }
        return null;
    }
}

