/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class SelectPlatformAppModulePanel
extends JPanel {
    private DialogDescriptor dd;
    private Project appModuleProject;
    private final ArrayList<Project> openProjects;
    private JButton btnBrowse;
    private JComboBox comboProjects;
    private JLabel lblHint;
    private JLabel lblOpenProjects;

    public SelectPlatformAppModulePanel() {
        this.initComponents();
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        this.openProjects = new ArrayList(opened.length);
        ArrayList<String> names = new ArrayList<String>(opened.length);
        for (Project p : opened) {
            if (!SelectPlatformAppModulePanel.isNbAppProject(p)) continue;
            this.openProjects.add(p);
            names.add(ProjectUtils.getInformation((Project)p).getDisplayName());
        }
        this.comboProjects.setModel(new DefaultComboBoxModel<Object>(names.toArray()));
        this.comboProjects.setSelectedIndex(-1);
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPlatformAppModulePanel.this.browseProject();
            }
        });
        this.comboProjects.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectPlatformAppModulePanel.this.dd.setValid(SelectPlatformAppModulePanel.this.comboProjects.getSelectedItem() != null);
            }
        });
    }

    private void initComponents() {
        this.lblHint = new JLabel();
        this.lblOpenProjects = new JLabel();
        this.comboProjects = new JComboBox();
        this.btnBrowse = new JButton();
        this.lblHint.setText(NbBundle.getMessage(SelectPlatformAppModulePanel.class, (String)"SelectPlatformAppModulePanel.lblHint.text"));
        this.lblOpenProjects.setText(NbBundle.getMessage(SelectPlatformAppModulePanel.class, (String)"SelectPlatformAppModulePanel.lblOpenProjects.text"));
        this.btnBrowse.setText(NbBundle.getMessage(SelectPlatformAppModulePanel.class, (String)"SelectPlatformAppModulePanel.btnBrowse.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHint).addGroup(layout.createSequentialGroup().addComponent(this.lblOpenProjects).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboProjects, 0, 222, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.btnBrowse))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblHint).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOpenProjects).addComponent(this.comboProjects, -2, -1, -2).addComponent(this.btnBrowse)).addContainerGap(27, Short.MAX_VALUE)));
    }

    private void browseProject() {
        JFileChooser chooser = ProjectChooser.projectChooser();
        while (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)projectDir));
            if (null == fo || !fo.isFolder()) {
                return;
            }
            try {
                Project p = ProjectManager.getDefault().findProject(fo);
                if (null == p || !SelectPlatformAppModulePanel.isNbAppProject(p)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.Err_NotMavenNBAppProject()));
                    continue;
                }
                this.appModuleProject = p;
                ArrayList<String> names = new ArrayList<String>(this.openProjects.size() + 1);
                for (Project prj : this.openProjects) {
                    names.add(ProjectUtils.getInformation((Project)prj).getDisplayName());
                }
                names.add(ProjectUtils.getInformation((Project)p).getDisplayName());
                this.comboProjects.setModel(new DefaultComboBoxModel<Object>(names.toArray()));
                this.comboProjects.setSelectedItem(ProjectUtils.getInformation((Project)p).getDisplayName());
                return;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            break;
        }
        return;
    }

    private Project getSelectedProject() {
        int selProject;
        Project res = this.appModuleProject;
        if (null == res && (selProject = this.comboProjects.getSelectedIndex()) >= 0) {
            res = this.openProjects.get(selProject);
        }
        return res;
    }

    static boolean findAppModule(Project project) {
        DialogDescriptor dd;
        SelectPlatformAppModulePanel panel = new SelectPlatformAppModulePanel();
        panel.dd = dd = new DialogDescriptor((Object)panel, Bundle.Title_SelectProject(), true, null);
        dd.setValid(false);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
        Project appModule = panel.getSelectedProject();
        if (null != appModule) {
            FileObject appDirFo = appModule.getProjectDirectory();
            File appDir = FileUtil.toFile((FileObject)appDirFo);
            File projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
            String relPath = FileUtilities.relativizeFile((File)projectDir, (File)appDir);
            AuxiliaryProperties props = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
            props.put("pathToNbApplicationModule", relPath, true);
            return true;
        }
        return false;
    }

    private static boolean isNbAppProject(Project p) {
        NbMavenProject watch = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
        return watch != null && "nbm-application".equals(watch.getPackagingType());
    }
}

