/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.MavenNbModuleImpl;
import org.netbeans.modules.maven.apisupport.SelectPlatformAppModulePanel;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class NbmActionGoalProvider
implements MavenActionsProvider {
    static final String NBMRELOAD = "nbmreload";
    private static final String RELOAD_TARGET = "reload-target";
    private AbstractMavenActionsProvider platformDelegate = new AbstractMavenActionsProvider(){

        protected InputStream getActionDefinitionStream() {
            String path = "platformActionMappings.xml";
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(path);
            assert (in != null) : "no instream for " + path;
            return in;
        }

        public boolean isActionEnable(String action, Project project, Lookup lookup) {
            return this.isActionEnable(action, project, lookup);
        }
    };
    private AbstractMavenActionsProvider ideDelegate = new AbstractMavenActionsProvider(){

        protected InputStream getActionDefinitionStream() {
            String path = "ideActionMappings.xml";
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(path);
            assert (in != null) : "no instream for " + path;
            return in;
        }

        public boolean isActionEnable(String action, Project project, Lookup lookup) {
            return this.isActionEnable(action, project, lookup);
        }
    };

    public Set<String> getSupportedDefaultActions() {
        return new HashSet<String>(Arrays.asList(NBMRELOAD, RELOAD_TARGET));
    }

    public static ContextAwareAction createReloadAction() {
        ContextAwareAction a = (ContextAwareAction)ProjectSensitiveActions.projectCommandAction((String)NBMRELOAD, (String)Bundle.ACT_NBM_Reload(), null);
        a.putValue("hideWhenDisabled", (Object)true);
        return a;
    }

    public static ContextAwareAction createReloadTargetAction() {
        ContextAwareAction a = (ContextAwareAction)ProjectSensitiveActions.projectCommandAction((String)RELOAD_TARGET, (String)Bundle.ACT_NBM_Reload_Target(), null);
        a.putValue("hideWhenDisabled", (Object)true);
        return a;
    }

    public synchronized boolean isActionEnable(String action, Project project, Lookup lookup) {
        if (RELOAD_TARGET.equals(action) || NBMRELOAD.equals(action)) {
            return this.hasNbm(project);
        }
        if ("run".equals(action) || "debug".equals(action)) {
            return this.hasNbm(project) || this.isPlatformApp(project);
        }
        return false;
    }

    public RunConfig createConfigForDefaultAction(String actionName, Project project, Lookup lookup) {
        if (RELOAD_TARGET.equals(actionName) && this.hasNbm(project)) {
            Project app = MavenNbModuleImpl.findAppProject(project);
            if (app == null && SelectPlatformAppModulePanel.findAppModule(project)) {
                app = MavenNbModuleImpl.findAppProject(project);
            }
            if (app != null) {
                if (!FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)app.getProjectDirectory()), (String)"target/userdir/lock").isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.NbmActionGoalProvider_target_platform_not_running(), 2));
                    return null;
                }
                RunConfig rc = this.createConfig(actionName, app, lookup, this.platformDelegate);
                assert (rc != null);
                rc.setPreExecution(RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (Project)project, (String)rc.getTaskDisplayName(), Collections.singletonList("package")));
                MavenProject prj = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
                String outputDir = PluginPropertyUtils.getPluginProperty((MavenProject)prj, (String)"org.apache.maven.plugins", (String)"maven-jar-plugin", (String)"directory", (String)"jar");
                if (outputDir == null) {
                    outputDir = "target";
                }
                rc.setProperty("module", FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)(outputDir + "/" + prj.getArtifactId() + "-" + prj.getVersion() + ".jar")).getAbsolutePath());
                return rc;
            }
        }
        if (!("run".equals(actionName) || "debug".equals(actionName) || NBMRELOAD.equals(actionName))) {
            return null;
        }
        if (this.isPlatformApp(project)) {
            return this.createConfig(actionName, project, lookup, this.platformDelegate);
        }
        if (this.hasNbm(project)) {
            return this.createConfig(actionName, project, lookup, this.ideDelegate);
        }
        return null;
    }

    public NetbeansActionMapping getMappingForAction(String actionName, Project project) {
        Project app;
        if (RELOAD_TARGET.equals(actionName) && this.hasNbm(project) && (app = MavenNbModuleImpl.findAppProject(project)) != null) {
            return this.createMapping(actionName, app, this.platformDelegate);
        }
        if (!("run".equals(actionName) || "debug".equals(actionName) || NBMRELOAD.equals(actionName))) {
            return null;
        }
        if (this.isPlatformApp(project)) {
            return this.createMapping(actionName, project, this.platformDelegate);
        }
        if (this.hasNbm(project)) {
            return this.createMapping(actionName, project, this.ideDelegate);
        }
        return null;
    }

    private RunConfig createConfig(String actionName, Project project, Lookup lookup, AbstractMavenActionsProvider delegate) {
        NbMavenProject mp;
        RunConfig conf = delegate.createConfigForDefaultAction(actionName, project, lookup);
        if (conf != null && this.hasNbm(project) && (mp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getProperties().getProperty("netbeans.installation") == null) {
            conf.getProperties().setProperty("netbeans.installation", this.guessNetbeansInstallation());
        }
        return conf;
    }

    private NetbeansActionMapping createMapping(String actionName, Project project, AbstractMavenActionsProvider delegate) {
        NbMavenProject mp;
        NetbeansActionMapping mapp = delegate.getMappingForAction(actionName, project);
        if (mapp != null && this.hasNbm(project) && (mp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getProperties().getProperty("netbeans.installation") == null) {
            mapp.getProperties().setProperty("netbeans.installation", this.guessNetbeansInstallation());
        }
        return mapp;
    }

    private boolean hasNbm(Project project) {
        NbMavenProject watch = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        String pack = watch.getPackagingType();
        boolean hasNbm = "nbm".equals(pack);
        return hasNbm;
    }

    private String guessNetbeansInstallation() {
        File fil = new File(System.getProperty("netbeans.home"));
        fil = FileUtil.normalizeFile((File)fil);
        return fil.getParentFile().getAbsolutePath();
    }

    private boolean isPlatformApp(Project p) {
        NbMavenProject watch = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
        String pack = watch.getPackagingType();
        return "nbm-application".equals(pack);
    }
}

