/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.swingapp.templates.ConfigureProjectVisualPanel;
import org.netbeans.modules.swingapp.templates.NewAppWizardIterator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ConfigureProjectPanel
implements WizardDescriptor.Panel,
WizardDescriptor.FinishablePanel {
    private WizardDescriptor wizard;
    private NewAppWizardIterator wizardIterator;
    private ConfigureProjectVisualPanel visualPanel;
    public static final String SHARED_LIBRARIES = "sharedLibraries";
    private EventListenerList listenerList;

    public ConfigureProjectPanel(NewAppWizardIterator iterator) {
        this.wizardIterator = iterator;
    }

    public Component getComponent() {
        if (this.visualPanel == null) {
            this.visualPanel = new ConfigureProjectVisualPanel(this);
        }
        return this.visualPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.swingapp.templates.ConfigureProjectPanel");
    }

    public void readSettings(Object settings) {
        WizardDescriptor wd;
        this.wizard = wd = (WizardDescriptor)settings;
        this.getComponent();
        wd.putProperty("NewProjectWizard_Title", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"TITLE_NewDesktopApp"));
        File projectLocation = (File)wd.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        String projectName = (String)wd.getProperty("projname");
        if (projectName == null) {
            String baseName = "DesktopApplication";
            int index = 0;
            while (new File(projectLocation, projectName = baseName + ++index).exists()) {
            }
        }
        String appClassName = (String)wd.getProperty("appname");
        this.visualPanel.setConfig(projectLocation, projectName, appClassName);
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor)settings;
        wd.putProperty("projdir", (Object)this.visualPanel.getProjectDirectory());
        wd.putProperty("projname", (Object)this.visualPanel.getProjectName());
        wd.putProperty("appname", (Object)this.visualPanel.getApplicationClassName());
        wd.putProperty("appshell", (Object)this.visualPanel.getSelectedTemplate());
        wd.putProperty("setAsMain", (Object)this.visualPanel.isSetMainProject());
        wd.putProperty(SHARED_LIBRARIES, this.visualPanel.isShareable() ? this.visualPanel.getLibFolderPath() : null);
    }

    public boolean isValid() {
        File nProjDir;
        File cProjDir;
        String projName;
        if (this.visualPanel.isShareable()) {
            String location = this.visualPanel.getLibFolderPath();
            if (this.visualPanel.getProjectDirectory() != null) {
                if (new File(location).isAbsolute()) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"WARN_PanelOptionsVisual.absolutePath"));
                } else {
                    File libLoc;
                    File projectLoc = FileUtil.normalizeFile((File)this.visualPanel.getProjectDirectory());
                    if (!CollocationQuery.areCollocated((File)projectLoc, (File)(libLoc = PropertyUtils.resolveFile((File)projectLoc, (String)location)))) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"WARN_PanelOptionsVisual.relativePath"));
                    }
                }
            }
        }
        if ((projName = this.visualPanel.getProjectName()) == null || projName.length() == 0 || projName.indexOf(47) > 0 || projName.indexOf(92) > 0 || projName.indexOf(58) > 0 || projName.indexOf(34) > 0) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File projDir = this.visualPanel.getProjectDirectory();
        try {
            cProjDir = projDir.getCanonicalFile();
        }
        catch (IOException e) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectLocation"));
            return false;
        }
        if (Utilities.isUnix() && cProjDir.getParentFile().getParent() == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectInRootNotSupported"));
            return false;
        }
        for (nProjDir = FileUtil.normalizeFile((File)projDir); nProjDir != null && !nProjDir.exists(); nProjDir = nProjDir.getParentFile()) {
        }
        if (nProjDir == null || !nProjDir.canWrite()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)nProjDir) == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectLocation"));
            return false;
        }
        File[] kids = projDir.listFiles();
        if (projDir.exists() && kids != null && kids.length > 0) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        String appClassName = this.visualPanel.getApplicationClassName();
        for (String s : appClassName.split("\\.", -1)) {
            if (Utilities.isJavaIdentifier((String)s)) continue;
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_InvalidAppClassName"));
            return false;
        }
        if (appClassName.indexOf(46) <= 0) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_InvalidDefaultPackage"));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        return this.visualPanel.getSelectedTemplate() != null;
    }

    public boolean isFinishPanel() {
        return this.wizardIterator.getAppShellIterator() == null;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, listener);
        }
    }

    private void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    void visualPanelChanged(boolean appShellChanged) {
        if (appShellChanged) {
            this.wizardIterator.setAppShellIterator(this.getAppShellWizardIterator(this.visualPanel.getSelectedTemplate()));
        }
        this.fireStateChanged();
    }

    private WizardDescriptor.InstantiatingIterator getAppShellWizardIterator(FileObject appShellTemplate) {
        Object iteratorObj;
        if (appShellTemplate != null && (iteratorObj = appShellTemplate.getAttribute("instantiatingIterator")) instanceof WizardDescriptor.InstantiatingIterator) {
            return (WizardDescriptor.InstantiatingIterator)iteratorObj;
        }
        return null;
    }
}

