/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.jdesktop.application.Application;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AppFrameworkSupport {
    private static final String APPLICATION_RESOURCE_NAME = "org/jdesktop/application/Application.class";
    private static final String SWINGAPP_ELEMENT = "swingapp";
    private static final String SWINGAPP_NS = "http://www.netbeans.org/ns/form-swingapp/1";
    private static final String APP_CLASS_ELEMENT = "application-class";
    private static final String APP_CLASS_NAME_ATTR = "name";
    private static Map<FileObject, String> appClassMap = new HashMap<FileObject, String>();

    AppFrameworkSupport() {
    }

    static boolean isFrameworkEnabledProject(FileObject fileInProject) {
        return AppFrameworkSupport.isFrameworkLibAvailable(fileInProject) && AppFrameworkSupport.getApplicationClassName(fileInProject) != null;
    }

    static boolean isFrameworkLibAvailable(FileObject fileInProject) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
        return cp != null && cp.findResource(APPLICATION_RESOURCE_NAME) != null && AppFrameworkSupport.projectCanUseFramework(fileInProject);
    }

    static boolean isApplicationProject(Project project) {
        AuxiliaryConfiguration ac = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        return ac.getConfigurationFragment(SWINGAPP_ELEMENT, SWINGAPP_NS, true) != null;
    }

    private static boolean isApplicationProject(FileObject fileInProject) {
        Project p = FileOwnerQuery.getOwner((FileObject)fileInProject);
        return p != null ? AppFrameworkSupport.isApplicationProject(p) : false;
    }

    static boolean projectCanUseFramework(FileObject fileInProject) {
        Project p = FileOwnerQuery.getOwner((FileObject)fileInProject);
        return p == null || !p.getClass().getName().startsWith("org.netbeans.modules.apisupport.") || !p.getClass().getName().endsWith("Project");
    }

    static String getApplicationCode(FileObject srcFile) {
        String appClsName = AppFrameworkSupport.getApplicationClassName(srcFile);
        return appClsName != null ? Application.class.getName() + ".getInstance(" + appClsName + ".class)" : Application.class.getName() + ".getInstance()";
    }

    static String getActionMapCode(FileObject srcFile) {
        return AppFrameworkSupport.getApplicationCode(srcFile) + ".getContext().getActionMap(" + srcFile.getName() + ".class, this)";
    }

    static String getApplicationClassName(FileObject fileInProject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileInProject);
        if (project != null) {
            return AppFrameworkSupport.getApplicationClassName(fileInProject, project, true);
        }
        return null;
    }

    static String getApplicationClassName(Project project) {
        FileObject fileRep = AppFrameworkSupport.getSourceRoot(project);
        if (fileRep != null) {
            return AppFrameworkSupport.getApplicationClassName(fileRep, project, false);
        }
        return null;
    }

    static String getAppClassNameFromProjectConfig(Project project) {
        AuxiliaryConfiguration ac = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element appEl = ac.getConfigurationFragment(SWINGAPP_ELEMENT, SWINGAPP_NS, true);
        if (appEl != null) {
            NodeList children = appEl.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (n.getNodeType() != 1 || !n.getNodeName().equals(APP_CLASS_ELEMENT)) continue;
                return ((Element)n).getAttribute(APP_CLASS_NAME_ATTR);
            }
            return "";
        }
        return null;
    }

    private static String getApplicationClassName(FileObject fileInProject, Project project, boolean depProjects) {
        ClassPath cp;
        boolean allowSearch = Boolean.getBoolean("netbeans.form.scan_for_app");
        boolean storedInProject = false;
        boolean searched = false;
        FileObject cpRep = fileInProject;
        String appClassName = AppFrameworkSupport.getAppClassNameFromProjectConfig(project);
        if (appClassName == null && depProjects) {
            cp = ClassPath.getClassPath((FileObject)cpRep, (String)"classpath/compile");
            if (cp == null) {
                return null;
            }
            for (ClassPath.Entry e : cp.entries()) {
                Project p;
                FileObject[] sourceRoots;
                SourceForBinaryQuery.Result2 sr = SourceForBinaryQuery.findSourceRoots2((URL)e.getURL());
                if (sr == null || !sr.preferSources() || (sourceRoots = sr.getRoots()) == null || sourceRoots.length <= 0 || (p = FileOwnerQuery.getOwner((FileObject)sourceRoots[0])) == null || p == project || (appClassName = AppFrameworkSupport.getAppClassNameFromProjectConfig(p)) == null) continue;
                project = p;
                cpRep = AppFrameworkSupport.getSourceRoot(p);
                break;
            }
        }
        if (appClassName != null) {
            if (appClassName.length() == 0) {
                appClassName = null;
            } else {
                storedInProject = true;
            }
        }
        if (appClassName == null) {
            if (appClassMap.containsKey(fileInProject)) {
                appClassName = appClassMap.get(fileInProject);
            } else if (allowSearch) {
                appClassName = AppFrameworkSupport.findApplicationClass(cpRep);
                searched = true;
            }
        }
        if (appClassName != null && !searched && (cp = ClassPath.getClassPath((FileObject)cpRep, (String)"classpath/source")).findResource(appClassName.replace('.', '/') + ".java") == null) {
            appClassName = AppFrameworkSupport.findApplicationClass(cpRep);
            searched = true;
        }
        if (searched) {
            AuxiliaryConfiguration ac;
            if (appClassName != null) {
                ac = ProjectUtils.getAuxiliaryConfiguration((Project)project);
                Document xml = XMLUtil.createDocument((String)SWINGAPP_ELEMENT, (String)SWINGAPP_NS, null, null);
                Element appEl = xml.createElementNS(SWINGAPP_NS, SWINGAPP_ELEMENT);
                Element clsEl = xml.createElement(APP_CLASS_ELEMENT);
                clsEl.setAttribute(APP_CLASS_NAME_ATTR, appClassName);
                appEl.appendChild(clsEl);
                ac.putConfigurationFragment(appEl, true);
                storedInProject = true;
                try {
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (storedInProject) {
                ac = ProjectUtils.getAuxiliaryConfiguration((Project)project);
                ac.removeConfigurationFragment(SWINGAPP_ELEMENT, SWINGAPP_NS, true);
                storedInProject = false;
                try {
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (!fileInProject.isFolder() && !storedInProject) {
                appClassMap.put(fileInProject, appClassName);
            }
        }
        return appClassName;
    }

    static boolean isViewClass(FileObject fo) {
        final String fileName = fo.getName();
        final boolean[] result = new boolean[1];
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
                        ClassTree classT;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !fileName.equals((classT = (ClassTree)tree).getSimpleName().toString())) continue;
                        if (!AppFrameworkSupport.isViewClass(classT, controller)) break;
                        result[0] = true;
                        return;
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result[0];
    }

    static boolean isViewClass(ClassTree classT, CompilationController controller) {
        Trees trees = controller.getTrees();
        TreePath classTPath = trees.getPath(controller.getCompilationUnit(), classT);
        TypeElement classEl = (TypeElement)trees.getElement(classTPath);
        TypeElement appEl = controller.getElements().getTypeElement("org.jdesktop.application.View");
        Types types = controller.getTypes();
        TypeMirror tm1 = types.erasure(classEl.asType());
        TypeMirror tm2 = types.erasure(appEl.asType());
        return types.isSubtype(tm1, tm2);
    }

    static String getClassNameForFile(FileObject fo) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        return cp != null ? cp.getResourceName(fo, '.', false) : null;
    }

    static FileObject getFileForClass(FileObject fileInProject, String className) {
        FileObject file;
        block1: {
            FileObject[] sourceRoots;
            ClassPath.Entry e;
            SourceForBinaryQuery.Result2 sr;
            ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source");
            file = cp.findResource(className.replace('.', '/') + ".java");
            if (file != null || AppFrameworkSupport.isApplicationProject(fileInProject)) break block1;
            Iterator i$ = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/compile").entries().iterator();
            while (i$.hasNext() && ((sr = SourceForBinaryQuery.findSourceRoots2((URL)(e = (ClassPath.Entry)i$.next()).getURL())) == null || !sr.preferSources() || (sourceRoots = sr.getRoots()) == null || sourceRoots.length <= 0 || (file = (cp = ClassPath.getClassPath((FileObject)sourceRoots[0], (String)"classpath/source")).findResource(className.replace('.', '/') + ".java")) == null)) {
            }
        }
        return file;
    }

    static ClassPath getSourcePath(Project project) {
        FileObject root = AppFrameworkSupport.getSourceRoot(project);
        return root != null ? ClassPath.getClassPath((FileObject)root, (String)"classpath/source") : null;
    }

    private static FileObject getSourceRoot(Project project) {
        int i$ = 0;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] arr$ = sources.getSourceGroups("java");
        int len$ = arr$.length;
        if (i$ < len$) {
            SourceGroup g = arr$[i$];
            return g.getRootFolder();
        }
        return null;
    }

    static void fileClosed(FileObject srcFile) {
        appClassMap.remove(srcFile);
    }

    private static String findApplicationClass(FileObject fileInProject) {
        if (AppFrameworkSupport.isFrameworkLibAvailable(fileInProject)) {
            ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source");
            return AppFrameworkSupport.scanFolderForApplication(cp.findOwnerRoot(fileInProject));
        }
        return null;
    }

    private static String scanFolderForApplication(FileObject folder) {
        LinkedList<FileObject> folders = null;
        for (FileObject fo : folder.getChildren()) {
            String appClassName;
            if (fo.isFolder()) {
                if (folders == null) {
                    folders = new LinkedList<FileObject>();
                }
                folders.add(fo);
                continue;
            }
            if (!fo.getExt().equalsIgnoreCase("java") || (appClassName = AppFrameworkSupport.getAppClassNameFromFile(fo)) == null) continue;
            return appClassName;
        }
        if (folders != null) {
            for (FileObject fo : folders) {
                String appClassName = AppFrameworkSupport.scanFolderForApplication(fo);
                if (appClassName == null) continue;
                return appClassName;
            }
        }
        return null;
    }

    private static String getAppClassNameFromFile(FileObject fo) {
        final String fileName = fo.getName();
        final String[] result = new String[1];
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
                        String clsName;
                        TypeMirror tm2;
                        TypeMirror tm1;
                        Tree superT;
                        ClassTree classT;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !fileName.equals((classT = (ClassTree)tree).getSimpleName().toString()) || (superT = classT.getExtendsClause()) == null) continue;
                        Trees trees = controller.getTrees();
                        TreePath classTPath = trees.getPath(controller.getCompilationUnit(), classT);
                        TypeElement classEl = (TypeElement)trees.getElement(classTPath);
                        TypeElement appEl = controller.getElements().getTypeElement("org.jdesktop.application.Application");
                        Types types = controller.getTypes();
                        if (!types.isSubtype(tm1 = types.erasure(classEl.asType()), tm2 = types.erasure(appEl.asType())) || (clsName = classEl.getQualifiedName().toString()).startsWith("org.jdesktop.application.")) break;
                        result[0] = clsName;
                        return;
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return result[0];
    }
}

