/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfoPostprocessor;
import org.apache.maven.index.MatchHighlightRequest;
import org.apache.maven.index.context.IndexingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractSearchRequest {
    public static final int UNDEFINED = -1;
    public static final int UNDEFINED_HIT_LIMIT = 1000;
    private Query query;
    private List<IndexingContext> contexts;
    private int start;
    private int count;
    private int resultHitLimit;
    private ArtifactInfoFilter artifactInfoFilter;
    private ArtifactInfoPostprocessor artifactInfoPostprocessor;
    private List<MatchHighlightRequest> matchHighlightRequests;
    private boolean luceneExplain = false;

    public AbstractSearchRequest(Query query) {
        this(query, null);
    }

    public AbstractSearchRequest(Query query, List<IndexingContext> contexts) {
        this.query = query;
        if (contexts != null) {
            this.getContexts().addAll(contexts);
        }
        this.start = -1;
        this.count = -1;
        this.resultHitLimit = 1000;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public List<IndexingContext> getContexts() {
        if (this.contexts == null) {
            this.contexts = new ArrayList<IndexingContext>();
        }
        return this.contexts;
    }

    public void setContexts(List<IndexingContext> contexts) {
        this.contexts = contexts;
    }

    public boolean isHitLimited() {
        return this.getResultHitLimit() != 1000;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getCount() {
        return this.count;
    }

    @Deprecated
    public int getAiCount() {
        return this.getCount();
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Deprecated
    public void setAiCount(int count) {
        this.setCount(count);
    }

    public int getResultHitLimit() {
        return this.resultHitLimit;
    }

    public void setResultHitLimit(int resultHitLimit) {
        this.resultHitLimit = resultHitLimit;
    }

    public ArtifactInfoFilter getArtifactInfoFilter() {
        return this.artifactInfoFilter;
    }

    public void setArtifactInfoFilter(ArtifactInfoFilter artifactInfoFilter) {
        this.artifactInfoFilter = artifactInfoFilter;
    }

    public ArtifactInfoPostprocessor getArtifactInfoPostprocessor() {
        return this.artifactInfoPostprocessor;
    }

    public void setArtifactInfoPostprocessor(ArtifactInfoPostprocessor artifactInfoPostprocessor) {
        this.artifactInfoPostprocessor = artifactInfoPostprocessor;
    }

    public List<MatchHighlightRequest> getMatchHighlightRequests() {
        if (this.matchHighlightRequests == null) {
            this.matchHighlightRequests = new ArrayList<MatchHighlightRequest>();
        }
        return this.matchHighlightRequests;
    }

    public void setMatchHighlightRequests(List<MatchHighlightRequest> matchHighlightRequests) {
        this.matchHighlightRequests = matchHighlightRequests;
    }

    public boolean isLuceneExplain() {
        return this.luceneExplain;
    }

    public void setLuceneExplain(boolean luceneExplain) {
        this.luceneExplain = luceneExplain;
    }
}

