/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext.preprocessor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPToken;

public final class PPLine {
    public static final int IF = 0;
    public static final int ENDIF = 1;
    public static final int IFDEF = 2;
    public static final int IFNDEF = 3;
    public static final int ELSE = 4;
    public static final int ELIF = 5;
    public static final int ELIFDEF = 6;
    public static final int ELIFNDEF = 7;
    public static final int DEBUG = 8;
    public static final int MDEBUG = 9;
    public static final int ENDDEBUG = 10;
    public static final int DEFINE = 11;
    public static final int UNDEFINE = 12;
    public static final int OLDIF = 13;
    public static final int OLDENDIF = 14;
    public static final int COMMENTED = 15;
    public static final int UNCOMMENTED = 16;
    public static final int CONDITION = 17;
    public static final int UNKNOWN = -1;
    protected final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.mobility.antext.preprocessor.Bundle");
    private final ArrayList<PPToken> tokens = new ArrayList();
    private int type = -1;
    private ArrayList<Error> errors = null;
    private boolean hasValue = false;
    private boolean hasErrors = false;
    private boolean value = false;
    private int lineNumber = -1;
    private PPBlockInfo block;

    PPLine() {
    }

    public List<PPToken> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public int getType() {
        return this.type;
    }

    public PPBlockInfo getBlock() {
        return this.block;
    }

    public List<Error> getErrors() {
        return this.errors == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.errors);
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public boolean getValue() {
        return this.value;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (PPToken t : this.tokens) {
            sb.append(t.getPadding());
            if (t.getType() == 258) continue;
            sb.append(t.getText());
        }
        return sb.toString();
    }

    void addToken(PPToken token) {
        if (this.lineNumber < 0) {
            this.lineNumber = token.getLine();
        }
        this.tokens.add(token);
    }

    void addError(String bundleKey) {
        this.addError(bundleKey, this.tokens.get(0));
    }

    void addError(String bundleKey, PPToken token) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        int i = 0;
        int c = token.getColumn();
        Iterator<Error> it = this.errors.iterator();
        while (it.hasNext() && it.next().token.getColumn() <= c) {
            ++i;
        }
        this.errors.add(i, new Error(this.bundle.getString(bundleKey), token, false));
        this.hasErrors = true;
    }

    void addWarning(String bundleKey, PPToken token) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        this.errors.add(new Error(this.bundle.getString(bundleKey), token, true));
    }

    void setType(int type) {
        this.type = type;
    }

    void setValue(boolean value) {
        this.value = value;
        this.hasValue = true;
    }

    void setBlock(PPBlockInfo block) {
        this.block = block;
    }

    public final class Error {
        public final String message;
        public final PPToken token;
        public final boolean warning;

        Error(String message, PPToken token, boolean warning) {
            this.warning = warning;
            this.message = message;
            this.token = token;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.token.getColumn(); ++i) {
                sb.append(' ');
            }
            sb.append('^');
            return MessageFormat.format(PPLine.this.bundle.getString(this.warning ? "FMT_WARNING_OUTPUT" : "FMT_ERROR_OUTPUT"), String.valueOf(PPLine.this.getLineNumber()), this.message, PPLine.this.toString(), sb.toString());
        }
    }
}

