/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.LogDate;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlLogMessage
implements ISVNLogMessage {
    private static final String EMPTY = "";
    private List children;
    private boolean hasChildren;
    private ISVNLogMessageChangePath[] changedPaths;
    private SVNRevision.Number revision;
    private Map revprops;
    private LogDate logDate;

    public JhlLogMessage(ChangePath[] changedPaths, long revision, Map revprops, boolean hasChildren) {
        this.changedPaths = JhlConverter.convert(changedPaths);
        this.revision = new SVNRevision.Number(revision);
        this.revprops = revprops;
        if (this.revprops == null) {
            this.revprops = new HashMap(2);
            this.revprops.put("svn:author", EMPTY);
            this.revprops.put("svn:log", EMPTY);
        }
        this.hasChildren = hasChildren;
        try {
            this.logDate = new LogDate((String)this.revprops.get("svn:date"));
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    public void addChild(ISVNLogMessage msg) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(msg);
    }

    public SVNRevision.Number getRevision() {
        return this.revision;
    }

    public String getAuthor() {
        return (String)this.revprops.get("svn:author");
    }

    public Date getDate() {
        if (this.logDate == null) {
            return new Date(0L);
        }
        return this.logDate.getDate();
    }

    public String getMessage() {
        return (String)this.revprops.get("svn:log");
    }

    public ISVNLogMessageChangePath[] getChangedPaths() {
        return this.changedPaths;
    }

    public String toString() {
        return this.getMessage();
    }

    public ISVNLogMessage[] getChildMessages() {
        if (this.hasChildren && this.children != null) {
            ISVNLogMessage[] childArray = new JhlLogMessage[this.children.size()];
            this.children.toArray(childArray);
            return childArray;
        }
        return null;
    }

    public long getNumberOfChildren() {
        if (this.hasChildren && this.children != null) {
            return this.children.size();
        }
        return 0L;
    }

    public long getTimeMillis() {
        if (this.logDate == null) {
            return 0L;
        }
        return this.logDate.getTimeMillis();
    }

    public long getTimeMicros() {
        if (this.logDate == null) {
            return 0L;
        }
        return this.logDate.getTimeMicros();
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }
}

