/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.WLModuleNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class WLModuleChildFactory
extends ChildFactory<WLModuleNode>
implements RefreshModulesCookie {
    private static final Logger LOGGER = Logger.getLogger(WLModuleChildFactory.class.getName());
    private final Lookup lookup;
    private final ModuleType moduleType;

    public WLModuleChildFactory(Lookup lookup, ModuleType moduleType) {
        this.lookup = lookup;
        this.moduleType = moduleType;
    }

    @Override
    public final void refresh() {
        this.refresh(false);
    }

    protected Node createNodeForKey(WLModuleNode key) {
        return key;
    }

    protected boolean createKeys(List<WLModuleNode> toPopulate) {
        WLDeploymentManager dm = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        try {
            TargetModuleID[] modules = dm.getAvailableModules(this.moduleType, dm.getTargets());
            TargetModuleID[] stopped = dm.getNonRunningModules(this.moduleType, dm.getTargets());
            HashSet<String> stoppedByName = new HashSet<String>();
            if (stopped != null) {
                for (TargetModuleID module : stopped) {
                    stoppedByName.add(module.getModuleID());
                }
            }
            if (modules != null) {
                for (TargetModuleID module : modules) {
                    toPopulate.add(new WLModuleNode(module, this.lookup, this.moduleType, stoppedByName.contains(module.getModuleID())));
                }
            }
        }
        catch (IllegalStateException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (TargetException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return true;
    }
}

