/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.ResourceNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.WLNodeChildren;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class TuxedoChildren
extends WLNodeChildren<ResourceNode> {
    private static final Logger LOGGER = Logger.getLogger(TuxedoChildren.class.getName());
    private Lookup lookup;

    TuxedoChildren(Lookup lookup) {
        this.lookup = lookup;
        ResourceNode wtcServers = new ResourceNode(new WTCServersChildrenFactory(), ResourceNode.ResourceNodeType.WTC_SERVER, NbBundle.getMessage(TuxedoChildren.class, (String)"LBL_WtcServers"));
        ResourceNode pools = new ResourceNode(new JoltPoolsChildrenFactory(), ResourceNode.ResourceNodeType.WTC_SERVER, NbBundle.getMessage(TuxedoChildren.class, (String)"LBL_JoltConnectionPools"));
        this.setKeys((Object[])new ResourceNode[]{wtcServers, pools});
    }

    protected Node[] createNodes(ResourceNode key) {
        return new Node[]{key};
    }

    private class JoltPoolsChildrenFactory
    extends TuxedoChildrenFactory {
        private JoltPoolsChildrenFactory() {
        }

        @Override
        protected ResourceNode createNode(MBeanServerConnection connection, ObjectName bean, String type) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            if ("JoltConnectionPool".equals(type)) {
                String name = (String)connection.getAttribute(bean, "Name");
                return new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.WTC_SERVER, name);
            }
            return null;
        }
    }

    private class WTCServersChildrenFactory
    extends TuxedoChildrenFactory {
        private WTCServersChildrenFactory() {
        }

        @Override
        protected ResourceNode createNode(MBeanServerConnection connection, ObjectName bean, String type) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            if ("WTCServer".equals(type)) {
                String name = (String)connection.getAttribute(bean, "Name");
                return new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.WTC_SERVER, name);
            }
            return null;
        }
    }

    private abstract class TuxedoChildrenFactory
    extends ChildFactory<ResourceNode>
    implements RefreshModulesCookie {
        private TuxedoChildrenFactory() {
        }

        @Override
        public void refresh() {
            this.refresh(false);
        }

        protected boolean createKeys(final List<ResourceNode> keys) {
            WLDeploymentManager manager = (WLDeploymentManager)TuxedoChildren.this.lookup.lookup(WLDeploymentManager.class);
            WLConnectionSupport support = new WLConnectionSupport(manager);
            try {
                support.executeAction(new WLConnectionSupport.JMXRuntimeAction<Void>(){

                    @Override
                    public Void call(MBeanServerConnection con, ObjectName service) throws Exception {
                        ObjectName[] deployments;
                        ObjectName domainConfig = (ObjectName)con.getAttribute(service, "DomainConfiguration");
                        for (ObjectName deployment : deployments = (ObjectName[])con.getAttribute(domainConfig, "Deployments")) {
                            String type = con.getAttribute(deployment, "Type").toString();
                            ResourceNode node = TuxedoChildrenFactory.this.createNode(con, deployment, type);
                            if (node == null) continue;
                            keys.add(node);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
            return true;
        }

        protected Node createNodeForKey(ResourceNode key) {
            return key;
        }

        protected abstract ResourceNode createNode(MBeanServerConnection var1, ObjectName var2, String var3) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException;
    }
}

