/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.ResourceNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.WLNodeChildren;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class ConnectorsChildren
extends WLNodeChildren<ResourceNode> {
    private static final Logger LOGGER = Logger.getLogger(ConnectorsChildren.class.getName());

    ConnectorsChildren(Lookup lookup) {
        ResourceNode resource = new ResourceNode(new ConnectorResourceChildFactory(lookup), ResourceNode.ResourceNodeType.CONNECTOR_RESOURCES, NbBundle.getMessage(ConnectorsChildren.class, (String)"LBL_ConnectorResource"));
        ResourceNode pool = new ResourceNode(new ConnectorPoolChildFactory(lookup), ResourceNode.ResourceNodeType.CONNECTOR_RESOURCES, NbBundle.getMessage(ConnectorsChildren.class, (String)"LBL_ConnectorConnectionPool"));
        ResourceNode adminObjects = new ResourceNode(new AdminObjectChildFactory(lookup), ResourceNode.ResourceNodeType.CONNECTOR_RESOURCES, NbBundle.getMessage(ConnectorsChildren.class, (String)"LBL_ConnectorAdminObject"));
        this.setKeys((Object[])new ResourceNode[]{resource, pool, adminObjects});
    }

    protected Node[] createNodes(ResourceNode key) {
        return new Node[]{key};
    }

    static class AdminObjectChildFactory
    extends ChildFactory<ResourceNode>
    implements RefreshModulesCookie {
        private Lookup lookup;

        AdminObjectChildFactory(Lookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public void refresh() {
            this.refresh(false);
        }

        protected boolean createKeys(List<ResourceNode> children) {
            WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
            WLConnectionSupport support = new WLConnectionSupport(manager);
            try {
                List<String> jndiNames = support.executeAction(new WLConnectionSupport.JMXRuntimeAction<List<String>>(){

                    @Override
                    public List<String> call(MBeanServerConnection con, ObjectName service) throws Exception {
                        ObjectName objectName = (ObjectName)con.getAttribute(service, "DomainConfiguration");
                        ObjectName[] objectNames = (ObjectName[])con.getAttribute(objectName, "SystemResources");
                        LinkedList<String> result = new LinkedList<String>();
                        for (ObjectName resource : objectNames) {
                            ObjectName[] topics;
                            ObjectName[] queues;
                            String type = con.getAttribute(resource, "Type").toString();
                            if (!"JMSSystemResource".equals(type)) continue;
                            ObjectName jmsResource = (ObjectName)con.getAttribute(resource, "JMSResource");
                            for (ObjectName queue : queues = (ObjectName[])con.getAttribute(jmsResource, "Queues")) {
                                String jndiName = con.getAttribute(queue, "JNDIName").toString();
                                result.add(jndiName);
                            }
                            for (ObjectName topic : topics = (ObjectName[])con.getAttribute(jmsResource, "Topics")) {
                                String jndiName = con.getAttribute(topic, "JNDIName").toString();
                                result.add(jndiName);
                            }
                        }
                        return result;
                    }
                });
                for (String jndiName : jndiNames) {
                    children.add(new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.CONNECTORS, jndiName));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
            return true;
        }

        protected Node createNodeForKey(ResourceNode key) {
            return key;
        }
    }

    static class ConnectorPoolChildFactory
    extends ChildFactory<ResourceNode>
    implements RefreshModulesCookie {
        private Lookup lookup;

        ConnectorPoolChildFactory(Lookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public void refresh() {
            this.refresh(false);
        }

        protected boolean createKeys(List<ResourceNode> children) {
            WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
            WLConnectionSupport support = new WLConnectionSupport(manager);
            try {
                List<String> jndiNames = support.executeAction(new WLConnectionSupport.JMXRuntimeAction<List<String>>(){

                    @Override
                    public List<String> call(MBeanServerConnection con, ObjectName service) throws Exception {
                        ObjectName[] adminServers = (ObjectName[])con.getAttribute(service, "ServerRuntimes");
                        LinkedList<String> result = new LinkedList<String>();
                        for (ObjectName adminServer : adminServers) {
                            ObjectName connectorRuntime = (ObjectName)con.getAttribute(adminServer, "ConnectorServiceRuntime");
                            ObjectName[] activeRas = (ObjectName[])con.getAttribute(connectorRuntime, "ActiveRAs");
                            this.addPool(activeRas, result, con);
                            ObjectName[] inactiveRas = (ObjectName[])con.getAttribute(connectorRuntime, "InactiveRAs");
                            this.addPool(inactiveRas, result, con);
                        }
                        return result;
                    }

                    private void addPool(ObjectName[] resourceAdapters, List<String> names, MBeanServerConnection connection) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
                        for (ObjectName resourceAdapter : resourceAdapters) {
                            ObjectName[] pools;
                            for (ObjectName pool : pools = (ObjectName[])connection.getAttribute(resourceAdapter, "ConnectionPools")) {
                                String name = connection.getAttribute(pool, "Name").toString();
                                names.add(name);
                            }
                        }
                    }
                });
                for (String jndiName : jndiNames) {
                    children.add(new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.CONNECTORS, jndiName));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
            return true;
        }

        protected Node createNodeForKey(ResourceNode key) {
            return key;
        }
    }

    static class ConnectorResourceChildFactory
    extends ChildFactory<ResourceNode>
    implements RefreshModulesCookie {
        private Lookup lookup;

        ConnectorResourceChildFactory(Lookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public void refresh() {
            this.refresh(false);
        }

        protected boolean createKeys(List<ResourceNode> children) {
            WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
            WLConnectionSupport support = new WLConnectionSupport(manager);
            try {
                List<String> jndiNames = support.executeAction(new WLConnectionSupport.JMXRuntimeAction<List<String>>(){

                    @Override
                    public List<String> call(MBeanServerConnection con, ObjectName service) throws Exception {
                        ObjectName objectName = (ObjectName)con.getAttribute(service, "DomainConfiguration");
                        ObjectName[] objectNames = (ObjectName[])con.getAttribute(objectName, "SystemResources");
                        LinkedList<String> result = new LinkedList<String>();
                        for (ObjectName resource : objectNames) {
                            ObjectName[] factories;
                            String type = con.getAttribute(resource, "Type").toString();
                            if (!"JMSSystemResource".equals(type)) continue;
                            ObjectName jmsResource = (ObjectName)con.getAttribute(resource, "JMSResource");
                            for (ObjectName factory : factories = (ObjectName[])con.getAttribute(jmsResource, "ConnectionFactories")) {
                                String jndiName = con.getAttribute(factory, "JNDIName").toString();
                                result.add(jndiName);
                            }
                        }
                        return result;
                    }
                });
                for (String jndiName : jndiNames) {
                    children.add(new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.CONNECTORS, jndiName));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
            return true;
        }

        protected Node createNodeForKey(ResourceNode key) {
            return key;
        }
    }
}

