/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.optional;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.ExternalProcessSupport;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.InputReader;
import org.netbeans.api.extexecution.input.InputReaderTask;
import org.netbeans.api.extexecution.input.InputReaders;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.optional.ErrorLineConvertor;
import org.netbeans.modules.j2ee.weblogic9.optional.WLServerProgress;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class WLStartServer
extends StartServer {
    private static final int SERVER_CHECK_TIMEOUT = 10000;
    private static final Logger LOGGER = Logger.getLogger(WLStartServer.class.getName());
    private static Set<String> SERVERS_IN_DEBUG;
    private final WLDeploymentManager dm;
    private final ExecutorService service = Executors.newCachedThreadPool();

    public WLStartServer(WLDeploymentManager dm) {
        this.dm = dm;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return new ServerDebugInfo(this.dm.getHost(), new Integer(this.dm.getInstanceProperties().getProperty("debuggerPort")).intValue());
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public boolean isDebuggable(Target target) {
        if (!WLStartServer.isServerInDebug(this.dm.getUri())) {
            return false;
        }
        return this.isRunning();
    }

    public boolean isRunning() {
        Process proc = this.dm.getServerProcess();
        if (!WLStartServer.isRunning(proc)) {
            return false;
        }
        String host = this.dm.getHost();
        int port = Integer.parseInt(this.dm.getPort().trim());
        return WLStartServer.ping(host, port, 10000);
    }

    public boolean needsStartForAdminConfig() {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForTargetList() {
        return true;
    }

    public ProgressObject startDebugging(Target target) {
        LOGGER.log(Level.FINER, "Starting server in debug mode");
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName));
        String uri = this.dm.getUri();
        this.service.submit(new WLDebugStartTask(uri, serverProgress, this.dm));
        WLStartServer.addServerInDebug(uri);
        return serverProgress;
    }

    public ProgressObject startDeploymentManager() {
        LOGGER.log(Level.FINER, "Starting server");
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName));
        String uri = this.dm.getUri();
        this.service.submit(new WLStartTask(uri, serverProgress, this.dm));
        WLStartServer.removeServerInDebug(uri);
        return serverProgress;
    }

    public ProgressObject startProfiling(Target target, ProfilerServerSettings settings) {
        LOGGER.log(Level.FINER, "Starting server in profiling mode");
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName));
        String uri = this.dm.getUri();
        this.service.submit(new WLProfilingStartTask(uri, serverProgress, this.dm, settings));
        WLStartServer.removeServerInDebug(uri);
        return serverProgress;
    }

    public ProgressObject stopDeploymentManager() {
        LOGGER.log(Level.FINER, "Stopping server");
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName));
        String uri = this.dm.getUri();
        this.service.submit(new WLStopTask(uri, serverProgress, this.dm));
        WLStartServer.removeServerInDebug(uri);
        return serverProgress;
    }

    public boolean supportsStartDeploymentManager() {
        return true;
    }

    public boolean supportsStartProfiling(Target target) {
        return true;
    }

    public boolean supportsStartDebugging(Target target) {
        return this.supportsStartDeploymentManager();
    }

    private static boolean ping(String host, int port, int timeout) {
        if (WLStartServer.pingPath(host, port, timeout, "/console/login/LoginForm.jsp")) {
            return true;
        }
        return WLStartServer.pingPath(host, port, timeout, "/consoledwp");
    }

    /*
     * Exception decompiling
     */
    private static boolean pingPath(String host, int port, int timeout, String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static synchronized void addServerInDebug(String uri) {
        if (SERVERS_IN_DEBUG == null) {
            SERVERS_IN_DEBUG = new HashSet<String>(1);
        }
        SERVERS_IN_DEBUG.add(uri);
    }

    private static synchronized void removeServerInDebug(String uri) {
        if (SERVERS_IN_DEBUG == null) {
            return;
        }
        SERVERS_IN_DEBUG.remove(uri);
    }

    private static synchronized boolean isServerInDebug(String uri) {
        return SERVERS_IN_DEBUG != null && SERVERS_IN_DEBUG.contains(uri);
    }

    private static void startService(String uri, Process process, ExecutorService service) {
        InputOutput io = UISupport.getServerIO((String)uri);
        if (io == null) {
            return;
        }
        try {
            io.getOut().reset();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        io.select();
        service.submit((Runnable)InputReaderTask.newTask((InputReader)InputReaders.forStream((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()), (InputProcessor)InputProcessors.printing((OutputWriter)io.getOut(), (LineConvertor)new ErrorLineConvertor(), (boolean)true)));
        service.submit((Runnable)InputReaderTask.newTask((InputReader)InputReaders.forStream((InputStream)process.getErrorStream(), (Charset)Charset.defaultCharset()), (InputProcessor)InputProcessors.printing((OutputWriter)io.getErr(), (LineConvertor)new ErrorLineConvertor(), (boolean)false)));
    }

    private static void stopService(final ExecutorService service) {
        if (service != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    service.shutdownNow();
                    return null;
                }
            });
        }
    }

    private static boolean isRunning(Process process) {
        if (process != null) {
            try {
                process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean needsRestart(Target target) {
        return this.dm.isRestartNeeded();
    }

    private class WLStopTask
    implements Runnable {
        private static final int TIMEOUT = 300000;
        private static final int DELAY = 1000;
        private static final String SHUTDOWN_SH = "stopWebLogic.sh";
        private static final String SHUTDOWN_BAT = "stopWebLogic.cmd";
        private static final String KEY_UUID = "NB_EXEC_WL_STOP_PROCESS_UUID";
        private final String uri;
        private final WLServerProgress serverProgress;
        private final WLDeploymentManager dm;

        public WLStopTask(String uri, WLServerProgress serverProgress, WLDeploymentManager dm) {
            this.uri = uri;
            this.serverProgress = serverProgress;
            this.dm = dm;
        }

        @Override
        public void run() {
            String username = this.dm.getInstanceProperties().getProperty("username");
            String password = this.dm.getInstanceProperties().getProperty("password");
            String[] parts = this.uri.substring("deployer:WebLogic:http://".length()).split(":");
            String host = parts[0];
            String port = parts.length > 1 ? parts[1] : "";
            String domainString = this.dm.getInstanceProperties().getProperty("domainRoot");
            File domainHome = new File(domainString);
            if (!domainHome.exists() || !domainHome.isDirectory()) {
                this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_NO_DOMAIN_HOME"));
                return;
            }
            File shutdown = null;
            shutdown = Utilities.isWindows() ? new File(new File(domainHome, "bin"), SHUTDOWN_BAT) : new File(new File(domainHome, "bin"), SHUTDOWN_SH);
            ExecutorService stopService = null;
            Process stopProcess = null;
            String serverName = this.dm.getInstanceProperties().getProperty("displayName");
            try {
                long start = System.currentTimeMillis();
                String uuid = UUID.randomUUID().toString();
                if (shutdown.exists()) {
                    ExternalProcessBuilder builder = new ExternalProcessBuilder(shutdown.getAbsolutePath());
                    builder = builder.workingDirectory(domainHome).addEnvironmentVariable(KEY_UUID, uuid).addArgument(username).addArgument(password).addArgument("t3://" + host + ":" + port);
                    String mwHome = this.dm.getProductProperties().getMiddlewareHome();
                    if (mwHome != null) {
                        builder = builder.addEnvironmentVariable("MW_HOME", mwHome);
                    }
                    stopProcess = builder.call();
                    stopService = Executors.newFixedThreadPool(2);
                    WLStartServer.startService(this.uri, stopProcess, stopService);
                } else {
                    Process process = this.dm.getServerProcess();
                    if (process == null) {
                        this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_FAILED", (Object)serverName));
                        return;
                    }
                    HashMap<String, String> mark = new HashMap<String, String>();
                    mark.put("NB_EXEC_WL_START_PROCESS_UUID", this.dm.getUri());
                    ExternalProcessSupport.destroy((Process)process, mark);
                }
                while (System.currentTimeMillis() - start < 300000L) {
                    if (WLStartServer.this.isRunning() && WLStartServer.isRunning(stopProcess)) {
                        this.serverProgress.notifyStop(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName));
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_INTERRUPTED"));
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    if (stopProcess != null) {
                        try {
                            stopProcess.waitFor();
                        }
                        catch (InterruptedException ex) {
                            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_INTERRUPTED"));
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    if (WLStartServer.this.isRunning()) {
                        this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_FAILED", (Object)serverName));
                    } else {
                        this.serverProgress.notifyStop(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STOPPED", (Object)serverName));
                    }
                    return;
                }
                this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_TIMEOUT"));
                if (stopProcess != null) {
                    HashMap<String, String> mark = new HashMap<String, String>();
                    mark.put(KEY_UUID, uuid);
                    ExternalProcessSupport.destroy((Process)stopProcess, mark);
                    WLStartServer.stopService(stopService);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
        }
    }

    private class WLStartTask
    implements Runnable {
        static final String JAVA_VENDOR_VARIABLE = "JAVA_VENDOR";
        static final String JAVA_OPTIONS_VARIABLE = "JAVA_OPTIONS";
        static final String MEMORY_OPTIONS_VARIABLE = "USER_MEM_ARGS";
        static final String MEMORY_OPTIONS_VARIABLE_11_WEB = "MEM_ARGS";
        private static final String KEY_UUID = "NB_EXEC_WL_START_PROCESS_UUID";
        private static final int TIMEOUT = 300000;
        private static final int DELAY = 1000;
        private static final String STARTUP_SH = "startWebLogic.sh";
        private static final String STARTUP_BAT = "startWebLogic.cmd";
        private static final String STARTUP_SH_DWP_ALTERNATIVE = "startServer.sh";
        private static final String STARTUP_BAT_DWP_ALTERNATIVE = "startServer.cmd";
        private final String uri;
        private final WLServerProgress serverProgress;
        private final WLDeploymentManager dm;

        public WLStartTask(String uri, WLServerProgress serverProgress, WLDeploymentManager dm) {
            this.uri = uri;
            this.serverProgress = serverProgress;
            this.dm = dm;
        }

        @Override
        public void run() {
            String domainString = this.dm.getInstanceProperties().getProperty("domainRoot");
            File domainHome = new File(domainString);
            if (!domainHome.exists() || !domainHome.isDirectory()) {
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_NO_DOMAIN_HOME"));
                return;
            }
            try {
                long start = System.currentTimeMillis();
                File startup = null;
                if (Utilities.isWindows()) {
                    startup = new File(domainHome, STARTUP_BAT);
                    if (!startup.exists()) {
                        startup = new File(new File(domainHome, "bin"), STARTUP_BAT);
                    }
                    if (!startup.exists()) {
                        startup = new File(new File(domainHome, "bin"), STARTUP_BAT_DWP_ALTERNATIVE);
                    }
                } else {
                    startup = new File(domainHome, STARTUP_SH);
                    if (!startup.exists()) {
                        startup = new File(new File(domainHome, "bin"), STARTUP_SH);
                    }
                    if (!startup.exists()) {
                        startup = new File(new File(domainHome, "bin"), STARTUP_SH_DWP_ALTERNATIVE);
                    }
                }
                boolean needsJavaHome = this.dm.isWebProfile();
                ExternalProcessBuilder builder = new ExternalProcessBuilder(startup.getAbsolutePath());
                builder = builder.workingDirectory(domainHome).addEnvironmentVariable(KEY_UUID, this.dm.getUri());
                String mwHome = this.dm.getProductProperties().getMiddlewareHome();
                if (mwHome != null) {
                    builder = builder.addEnvironmentVariable("MW_HOME", mwHome);
                }
                if (needsJavaHome) {
                    builder = builder.addEnvironmentVariable("JAVA_HOME", WLPluginProperties.getDefaultPlatformHome());
                }
                builder = this.initBuilder(builder);
                Process process = builder.call();
                this.dm.setServerProcess(process);
                ExecutorService service = Executors.newFixedThreadPool(2);
                WLStartServer.startService(this.uri, process, service);
                String serverName = this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - start < 300000L) {
                    if (this.isRunning()) {
                        this.dm.setRestartNeeded(false);
                        this.serverProgress.notifyStart(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STARTED", (Object)serverName));
                        boolean interrupted = false;
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        } else {
                            WLStartServer.stopService(service);
                        }
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_INTERRUPTED"));
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_TIMEOUT"));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
        }

        protected ExternalProcessBuilder initBuilder(ExternalProcessBuilder builder) {
            String memoryOptions;
            ExternalProcessBuilder result = builder;
            result = this.setJavaOptionsEnv(result);
            String vendor = this.dm.getInstanceProperties().getProperty("vendor");
            if (vendor != null && vendor.trim().length() > 0) {
                result = builder.addEnvironmentVariable(JAVA_VENDOR_VARIABLE, vendor.trim());
            }
            if ((memoryOptions = this.dm.getInstanceProperties().getProperty("mem_opts")) != null && memoryOptions.trim().length() > 0) {
                result = this.dm.isWebProfile() ? builder.addEnvironmentVariable(MEMORY_OPTIONS_VARIABLE_11_WEB, memoryOptions.trim()) : builder.addEnvironmentVariable(MEMORY_OPTIONS_VARIABLE, memoryOptions.trim());
            }
            return result;
        }

        protected ExternalProcessBuilder setJavaOptionsEnv(ExternalProcessBuilder builder) {
            ExternalProcessBuilder result = builder;
            String javaOpts = this.dm.getInstanceProperties().getProperty("java_opts");
            if (javaOpts != null && javaOpts.trim().length() > 0) {
                result = builder.addEnvironmentVariable(JAVA_OPTIONS_VARIABLE, javaOpts.trim());
            }
            return result;
        }

        protected boolean isRunning() {
            return WLStartServer.this.isRunning();
        }

        protected WLServerProgress getProgress() {
            return this.serverProgress;
        }
    }

    private class WLDebugStartTask
    extends WLStartTask {
        public WLDebugStartTask(String uri, WLServerProgress serverProgress, WLDeploymentManager dm) {
            super(uri, serverProgress, dm);
        }

        @Override
        protected ExternalProcessBuilder setJavaOptionsEnv(ExternalProcessBuilder builder) {
            int debugPort = 4000;
            debugPort = Integer.parseInt(WLStartServer.this.dm.getInstanceProperties().getProperty("debuggerPort"));
            StringBuilder javaOptsBuilder = new StringBuilder();
            String javaOpts = WLStartServer.this.dm.getInstanceProperties().getProperty("java_opts");
            if (javaOpts != null && javaOpts.trim().length() > 0) {
                javaOptsBuilder.append(javaOpts.trim());
            }
            if (javaOptsBuilder.length() > 0) {
                javaOptsBuilder.append(" ");
            }
            javaOptsBuilder.append("-Xdebug -Xnoagent -Djava.compiler=none ");
            javaOptsBuilder.append("-Xrunjdwp:server=y,suspend=n,transport=dt_socket,address=");
            javaOptsBuilder.append(debugPort);
            ExternalProcessBuilder result = builder.addEnvironmentVariable("JAVA_OPTIONS", javaOptsBuilder.toString());
            return result;
        }
    }

    private class WLProfilingStartTask
    extends WLStartTask {
        private final ProfilerServerSettings mySettings;

        public WLProfilingStartTask(String uri, WLServerProgress serverProgress, WLDeploymentManager dm, ProfilerServerSettings settings) {
            super(uri, serverProgress, dm);
            this.mySettings = settings;
        }

        @Override
        public void run() {
            super.run();
            int state = ProfilerSupport.getState();
            if (state == 0) {
                this.getProgress().notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_PROFILED_SERVER_FAILED", (Object)WLStartServer.this.dm.getInstanceProperties().getProperty("displayName")));
                Process process = WLStartServer.this.dm.getServerProcess();
                if (process != null) {
                    HashMap<String, String> mark = new HashMap<String, String>();
                    mark.put("NB_EXEC_WL_START_PROCESS_UUID", WLStartServer.this.dm.getUri());
                    ExternalProcessSupport.destroy((Process)process, mark);
                }
            }
        }

        @Override
        protected ExternalProcessBuilder setJavaOptionsEnv(ExternalProcessBuilder builder) {
            ExternalProcessBuilder result = builder;
            StringBuilder javaOptsBuilder = new StringBuilder();
            String[] profJvmArgs = this.getSettings().getJvmArgs();
            for (int i = 0; i < profJvmArgs.length; ++i) {
                javaOptsBuilder.append(" ").append(profJvmArgs[i]);
            }
            String javaOpts = WLStartServer.this.dm.getInstanceProperties().getProperty("java_opts");
            if (javaOpts != null && javaOpts.trim().length() > 0) {
                javaOptsBuilder.append(" ");
                javaOptsBuilder.append(javaOpts.trim());
            }
            if (profJvmArgs.length > 0) {
                result = result.addEnvironmentVariable("JAVA_OPTIONS", javaOptsBuilder.toString());
            }
            return result;
        }

        @Override
        protected boolean isRunning() {
            int state = ProfilerSupport.getState();
            if (state == 2 || state == 3 || state == 4) {
                return true;
            }
            return super.isRunning();
        }

        private String getJavaHome(JavaPlatform platform) {
            FileObject fo = (FileObject)platform.getInstallFolders().iterator().next();
            return FileUtil.toFile((FileObject)fo).getAbsolutePath();
        }

        private ProfilerServerSettings getSettings() {
            return this.mySettings;
        }
    }
}

