/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.WLProductProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class WLJpa2SwitchSupport {
    private static final String OEPE_CONTRIBUTIONS_JAR = "oepe-contributions.jar";
    private static final String JPA_JAR_1 = "javax.persistence_1.0.0.0_2-0-0.jar";
    private static final String JPA_JAR_2 = "com.oracle.jpa2support_1.0.0.0_2-0.jar";
    private static final Logger LOGGER = Logger.getLogger(WLJpa2SwitchSupport.class.getName());
    private final File serverRoot;
    private final WLDeploymentManager dm;
    private boolean proggessSuccess = true;

    public WLJpa2SwitchSupport(File serverRoot) {
        this.dm = null;
        this.serverRoot = serverRoot;
    }

    public WLJpa2SwitchSupport(WLDeploymentManager dm) {
        this.dm = dm;
        this.serverRoot = WLPluginProperties.getServerRoot(dm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        ArrayList<ProgressSupport.BackgroundAction> actions = new ArrayList<ProgressSupport.BackgroundAction>();
        this.proggessSuccess = true;
        try {
            String path;
            File libDir = WLPluginProperties.getServerLibDirectory(this.serverRoot);
            if (libDir != null) {
                libDir = FileUtil.normalizeFile((File)libDir);
            }
            if ((path = this.getPathToModules(libDir)).length() > 0) {
                path = path + "/";
            }
            final File oepeFile = new File(libDir, OEPE_CONTRIBUTIONS_JAR);
            final String relPath = path;
            final String contribPath = path + JPA_JAR_1 + " " + path + JPA_JAR_2;
            actions.add(new ProgressSupport.BackgroundAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void run(ProgressSupport.Context actionContext) {
                    block12: {
                        actionContext.progress("Processing oepe_contributions.jar ");
                        try {
                            if (!oepeFile.exists()) {
                                WLJpa2SwitchSupport.this.createContributionsJar(oepeFile, contribPath);
                                break block12;
                            }
                            JarFile oepeJarFile = new JarFile(oepeFile);
                            try {
                                Manifest mf = oepeJarFile.getManifest();
                                String cp = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                                if (cp == null) {
                                    cp = "";
                                }
                                if (!cp.contains(WLJpa2SwitchSupport.JPA_JAR_1) || !cp.contains(WLJpa2SwitchSupport.JPA_JAR_2)) {
                                    StringBuilder updated = new StringBuilder(cp);
                                    if (cp != null) {
                                        if (!cp.contains(WLJpa2SwitchSupport.JPA_JAR_2)) {
                                            updated.insert(0, " ").insert(0, WLJpa2SwitchSupport.JPA_JAR_2).insert(0, relPath);
                                        }
                                        if (!cp.contains(WLJpa2SwitchSupport.JPA_JAR_1)) {
                                            updated.insert(0, " ").insert(0, WLJpa2SwitchSupport.JPA_JAR_1).insert(0, relPath);
                                        }
                                    }
                                    if (cp.length() == 0) {
                                        updated.deleteCharAt(updated.length() - 1);
                                    }
                                    mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, updated.toString());
                                    WLJpa2SwitchSupport.this.replaceManifest(oepeFile, mf);
                                }
                            }
                            finally {
                                oepeJarFile.close();
                            }
                        }
                        catch (IOException ex) {
                            WLJpa2SwitchSupport.this.proggessSuccess = false;
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
            actions.add(new ProgressSupport.BackgroundAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void run(ProgressSupport.Context actionContext) {
                    if (!WLJpa2SwitchSupport.this.proggessSuccess) {
                        return;
                    }
                    actionContext.progress("Processing weblogic.jar ");
                    try {
                        File weblogicFile = WLPluginProperties.getWeblogicJar(WLJpa2SwitchSupport.this.serverRoot);
                        JarFile weblogicJarFile = new JarFile(weblogicFile);
                        try {
                            Manifest wlManifest = weblogicJarFile.getManifest();
                            String cp = wlManifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                            if (cp == null) {
                                cp = "";
                            }
                            if (!cp.contains(WLJpa2SwitchSupport.OEPE_CONTRIBUTIONS_JAR)) {
                                cp = cp.length() == 0 ? WLJpa2SwitchSupport.OEPE_CONTRIBUTIONS_JAR : "oepe-contributions.jar " + cp;
                                wlManifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, cp);
                                WLJpa2SwitchSupport.this.replaceManifest(weblogicFile, wlManifest);
                            }
                        }
                        finally {
                            weblogicJarFile.close();
                        }
                    }
                    catch (IOException ex) {
                        WLJpa2SwitchSupport.this.proggessSuccess = false;
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            ProgressSupport.invoke(actions);
        }
        finally {
            if (this.dm != null) {
                this.dm.getJ2eePlatformImpl().notifyLibrariesChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        try {
            File oepeJarFile;
            File libDir = WLPluginProperties.getServerLibDirectory(this.serverRoot);
            if (libDir != null) {
                libDir = FileUtil.normalizeFile((File)libDir);
            }
            if (!(oepeJarFile = new File(libDir, OEPE_CONTRIBUTIONS_JAR)).exists() || !oepeJarFile.isFile()) {
                return;
            }
            JarFile file = new JarFile(oepeJarFile);
            try {
                Manifest mf = file.getManifest();
                String cp = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                if (cp == null) {
                    return;
                }
                StringBuilder builder = new StringBuilder();
                for (String element : cp.split("\\s+")) {
                    if (element.contains(JPA_JAR_1) || element.contains(JPA_JAR_2)) continue;
                    builder.append(element).append(" ");
                }
                if (builder.length() > 0) {
                    mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, builder.substring(0, builder.length() - 1));
                } else {
                    mf.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
                }
                this.replaceManifest(oepeJarFile, mf);
            }
            finally {
                file.close();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (this.dm != null) {
                this.dm.getJ2eePlatformImpl().notifyLibrariesChange();
            }
        }
    }

    public boolean isEnabled() {
        if (this.dm != null) {
            return this.dm.getJ2eePlatformImpl().isJpa2Available();
        }
        return false;
    }

    public boolean isEnabledViaSmartUpdate() {
        if (this.dm != null) {
            for (LibraryImplementation lib : this.dm.getJ2eePlatformImpl().getLibraries()) {
                List urls = lib.getContent("classpath");
                if (urls == null) continue;
                for (URL url : urls) {
                    String file = url.getFile();
                    if (!file.endsWith("BUG9923849_WLS103MP4.jar!/")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceManifest(File jarFile, Manifest manifest) throws IOException {
        FileObject fo = FileUtil.toFileObject((File)jarFile);
        String tmpName = FileUtil.findFreeFileName((FileObject)fo.getParent(), (String)jarFile.getName(), (String)"tmp");
        File tmpJar = new File(jarFile.getParentFile(), tmpName + ".tmp");
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(jarFile));
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpJar));
                try {
                    this.replaceManifest(is, os, manifest);
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                ((InputStream)is).close();
            }
            if (tmpJar.renameTo(jarFile)) {
                LOGGER.log(Level.FINE, "Successfully moved {0}", tmpJar);
                return;
            }
            LOGGER.log(Level.FINE, "Byte to byte copy {0}", tmpJar);
            this.copy(tmpJar, jarFile);
        }
        finally {
            tmpJar.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceManifest(InputStream is, OutputStream os, Manifest manifest) throws IOException {
        JarInputStream in = new JarInputStream(is);
        try {
            JarOutputStream out = new JarOutputStream(os, manifest);
            try {
                JarEntry entry = null;
                byte[] temp = new byte[32768];
                while ((entry = in.getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (name.equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                    out.putNextEntry(entry);
                    while (in.available() != 0) {
                        int read = in.read(temp);
                        if (read == -1) continue;
                        out.write(temp, 0, read);
                    }
                    out.closeEntry();
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContributionsJar(File jarFile, String classpath) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(jarFile));
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classpath);
            JarOutputStream dest = new JarOutputStream((OutputStream)new BufferedOutputStream(os), manifest);
            try {
                dest.closeEntry();
                dest.finish();
            }
            finally {
                dest.close();
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File source, File dest) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));
            try {
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private String getPathToModules(File from) {
        String mwHome;
        File mwHomeFile = null;
        String string = mwHome = this.dm != null ? this.dm.getProductProperties().getMiddlewareHome() : WLProductProperties.getMiddlewareHome(this.serverRoot);
        if (mwHome == null) {
            if (this.serverRoot != null && this.serverRoot.getParentFile() != null) {
                mwHomeFile = this.serverRoot.getParentFile();
            }
        } else {
            mwHomeFile = new File(mwHome);
        }
        if (mwHomeFile != null) {
            File modules = FileUtil.normalizeFile((File)new File(mwHomeFile, "modules"));
            String relativePath = WLJpa2SwitchSupport.getRelativePath(from, modules);
            if (relativePath == null) {
                return modules.getAbsolutePath();
            }
            return relativePath;
        }
        return "../../../modules";
    }

    static String getRelativePath(File from, File to) {
        String fromPath;
        String toPath = to.getAbsolutePath();
        if (toPath.startsWith(fromPath = from.getAbsolutePath())) {
            if (toPath.length() == fromPath.length()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            File currentPath = to;
            while (!currentPath.equals(from)) {
                builder.insert(0, currentPath.getName());
                builder.insert(0, "/");
                currentPath = currentPath.getParentFile();
            }
            return builder.substring(1);
        }
        File parent = from.getParentFile();
        if (parent == null) {
            return null;
        }
        return "../" + WLJpa2SwitchSupport.getRelativePath(parent, to);
    }
}

