/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.containers;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.helper.swing.NbiButton;
import org.netbeans.installer.utils.helper.swing.NbiFrame;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiPanel;
import org.netbeans.installer.utils.helper.swing.NbiSeparator;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class SwingFrameContainer
extends NbiFrame
implements SwingContainer {
    private SwingUi currentUi;
    private WizardFrameContentPane contentPane;
    private String frameTitlePrefix;
    private String frameTitlePattern;
    public static final String WIZARD_FRAME_WIDTH_PROPERTY = "nbi.wizard.ui.swing.frame.width";
    public static final String WIZARD_FRAME_MINIMUM_WIDTH_PROPERTY = "nbi.wizard.ui.swing.frame.minimum.width";
    public static final String WIZARD_FRAME_MAXIMUM_WIDTH_PROPERTY = "nbi.wizard.ui.swing.frame.maximum.width";
    public static final String WIZARD_FRAME_HEIGHT_PROPERTY = "nbi.wizard.ui.swing.frame.height";
    public static final String WIZARD_FRAME_MINIMUM_HEIGHT_PROPERTY = "nbi.wizard.ui.swing.frame.minimum.height";
    public static final String WIZARD_FRAME_MAXIMUM_HEIGHT_PROPERTY = "nbi.wizard.ui.swing.frame.maximum.height";
    public static final String WIZARD_FRAME_ICON_URI_PROPERTY = "nbi.wizard.ui.swing.frame.icon";
    public static final String WIZARD_FRAME_TITLE_PREFIX_PROPERTY = "nbi.wizard.ui.swing.frame.title.prefix";
    public static final String WIZARD_FRAME_HEAD_RIGHT_IMAGE_URI_PROPERTY = "nbi.wizard.ui.swing.frame.head.right.image";
    public static final String WIZARD_FRAME_HEAD_LEFT_IMAGE_URI_PROPERTY = "nbi.wizard.ui.swing.frame.head.left.image";
    public static final String WIZARD_FRAME_HEAD_BACKGROUND_IMAGE_URI_PROPERTY = "nbi.wizard.ui.swing.frame.head.background.image";
    public static final String WIZARD_FRAME_TITLE_PATTERN_PROPERTY = "nbi.wizard.ui.swing.frame.title.pattern";
    public static final String WIZARD_FRAME_RESIZABLE_PROPERTY = "nbi.wizard.ui.swing.frame.resizable";
    public static final int DEFAULT_WIZARD_FRAME_WIDTH = 650;
    public static final int DEFAULT_WIZARD_FRAME_MINIMUM_WIDTH = 650;
    public static final int DEFAULT_WIZARD_FRAME_MAXIMUM_WIDTH = -1;
    public static final int DEFAULT_WIZARD_FRAME_HEIGHT = 600;
    public static final int DEFAULT_WIZARD_FRAME_MINIMUM_HEIGHT = 650;
    public static final int DEFAULT_WIZARD_FRAME_MAXIMUM_HEIGHT = -1;
    public static final String DEFAULT_WIZARD_FRAME_ICON_URI = "resource:org/netbeans/installer/utils/helper/swing/frame-icon.png";
    public static final String DEFAULT_WIZARD_FRAME_TITLE_PREFIX = ResourceUtils.getString(SwingFrameContainer.class, "SFC.frame.title.prefix");
    public static final String DEFAULT_WIZARD_FRAME_TITLE_PATTERN = ResourceUtils.getString(SwingFrameContainer.class, "SFC.frame.title.pattern");
    private static final String RESOURCE_FAILED_TO_DOWNLOAD_WIZARD_ICON = "SFC.error.failed.to.download.icon";
    private static final String RESOURCE_ERROR_SET_CLOSE_OPERATION = "SFC.error.close.operation";
    private static final String RESOURCE_FAILED_TO_SET_FRAME_CONTAINER_ICON = "SFC.error.failed.to.set.icon";
    private static final String RESOURCE_FAILED_TO_ATTACH_ERROR_HANDLER = "SFC.error.failed.to.attach.error.handler";
    private static final String CANCEL_ACTION_NAME = "evaluate.cancel";
    private static final int EXTRA_SIZE = 15;

    public SwingFrameContainer() {
        String frameIconUri;
        this.frameWidth = UiUtils.getDimension(System.getProperties(), WIZARD_FRAME_WIDTH_PROPERTY, 650);
        this.frameMinimumWidth = UiUtils.getDimension(System.getProperties(), WIZARD_FRAME_MINIMUM_WIDTH_PROPERTY, 650);
        this.frameMaximumWidth = UiUtils.getDimension(System.getProperties(), WIZARD_FRAME_MAXIMUM_WIDTH_PROPERTY, -1);
        this.frameHeight = UiUtils.getDimension(System.getProperties(), WIZARD_FRAME_HEIGHT_PROPERTY, 600);
        this.frameMinimumHeight = UiUtils.getDimension(System.getProperties(), WIZARD_FRAME_MINIMUM_HEIGHT_PROPERTY, 650);
        this.frameMaximumHeight = UiUtils.getDimension(System.getProperties(), WIZARD_FRAME_MAXIMUM_HEIGHT_PROPERTY, -1);
        boolean customIconLoaded = false;
        if (System.getProperty(WIZARD_FRAME_ICON_URI_PROPERTY) != null) {
            frameIconUri = System.getProperty(WIZARD_FRAME_ICON_URI_PROPERTY);
            try {
                this.frameIcon = FileProxy.getInstance().getFile(frameIconUri, true);
                customIconLoaded = true;
            }
            catch (DownloadException e) {
                ErrorManager.notifyWarning(ResourceUtils.getString(SwingFrameContainer.class, RESOURCE_FAILED_TO_DOWNLOAD_WIZARD_ICON, frameIconUri), e);
            }
        }
        if (!customIconLoaded) {
            frameIconUri = DEFAULT_WIZARD_FRAME_ICON_URI;
            try {
                this.frameIcon = FileProxy.getInstance().getFile(DEFAULT_WIZARD_FRAME_ICON_URI, true);
                customIconLoaded = true;
            }
            catch (DownloadException e) {
                ErrorManager.notifyWarning(ResourceUtils.getString(SwingFrameContainer.class, RESOURCE_FAILED_TO_DOWNLOAD_WIZARD_ICON, DEFAULT_WIZARD_FRAME_ICON_URI), e);
            }
        }
        this.frameTitlePrefix = DEFAULT_WIZARD_FRAME_TITLE_PREFIX;
        if (System.getProperty(WIZARD_FRAME_TITLE_PREFIX_PROPERTY) != null) {
            this.frameTitlePrefix = System.getProperty(WIZARD_FRAME_TITLE_PREFIX_PROPERTY);
        }
        this.frameTitlePattern = DEFAULT_WIZARD_FRAME_TITLE_PATTERN;
        if (System.getProperty(WIZARD_FRAME_TITLE_PATTERN_PROPERTY) != null) {
            this.frameTitlePattern = System.getProperty(WIZARD_FRAME_TITLE_PATTERN_PROPERTY);
        }
        this.initComponents();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.dispose();
        }
    }

    public void updateWizardUi(final WizardUi wizardUi) {
        if (wizardUi == null) {
            this.currentUi = null;
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingFrameContainer.this.updateWizardUi(wizardUi);
                    }
                });
            }
            catch (InterruptedException e) {
                LogManager.log("Error during updating wizard UI", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LogManager.log("Error during updating wizard UI", (Throwable)e);
            }
            return;
        }
        this.currentUi = wizardUi.getSwingUi(this);
        int currentHeight = this.getSize().height;
        if (this.currentUi.getTitle() != null) {
            this.setTitle(StringUtils.format(this.frameTitlePattern, this.frameTitlePrefix, this.currentUi.getTitle()));
        } else {
            this.setTitle(this.frameTitlePrefix);
        }
        this.contentPane.updatePanel(this.currentUi);
        int neededMinimumHeight = this.getLayout().minimumLayoutSize((Container)this).getSize().height;
        if (this.isResizable() && neededMinimumHeight > currentHeight) {
            this.setPreferredSize(new Dimension(this.getSize().width, neededMinimumHeight + 15));
            this.setMinimumSize(new Dimension(this.getSize().width, neededMinimumHeight + 15));
            this.pack();
        }
        this.contentPane.repaint();
        this.getRootPane().setDefaultButton(this.currentUi.getDefaultEnterButton());
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_ACTION_NAME);
        this.getRootPane().getActionMap().put(CANCEL_ACTION_NAME, new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                if (SwingFrameContainer.this.currentUi == null) {
                    return;
                }
                NbiButton button = SwingFrameContainer.this.currentUi.getDefaultEscapeButton();
                if (button != null && button.isEnabled()) {
                    if (button.equals(SwingFrameContainer.this.getHelpButton())) {
                        SwingFrameContainer.this.currentUi.evaluateHelpButtonClick();
                    }
                    if (button.equals(SwingFrameContainer.this.getBackButton())) {
                        SwingFrameContainer.this.currentUi.evaluateBackButtonClick();
                    }
                    if (button.equals(SwingFrameContainer.this.getNextButton())) {
                        SwingFrameContainer.this.currentUi.evaluateNextButtonClick();
                    }
                    if (button.equals(SwingFrameContainer.this.getCancelButton())) {
                        SwingFrameContainer.this.currentUi.evaluateCancelButtonClick();
                    }
                }
            }
        });
        if (this.currentUi.getDefaultFocusOwner() != null) {
            this.currentUi.getDefaultFocusOwner().requestFocusInWindow();
        }
        this.getAccessibleContext().setAccessibleName(this.currentUi.getTitle());
        this.getAccessibleContext().setAccessibleDescription(this.currentUi.getDescription());
    }

    public NbiButton getHelpButton() {
        return this.contentPane.getHelpButton();
    }

    public NbiButton getBackButton() {
        return this.contentPane.getBackButton();
    }

    public NbiButton getNextButton() {
        return this.contentPane.getNextButton();
    }

    public NbiButton getCancelButton() {
        return this.contentPane.getCancelButton();
    }

    public void open() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Thread.currentThread().setUncaughtExceptionHandler(ErrorManager.getExceptionHandler());
                }
            });
        }
        catch (InvocationTargetException e) {
            ErrorManager.notifyDebug(ResourceUtils.getString(SwingFrameContainer.class, RESOURCE_FAILED_TO_ATTACH_ERROR_HANDLER), e);
        }
        catch (InterruptedException e) {
            ErrorManager.notifyDebug(ResourceUtils.getString(SwingFrameContainer.class, RESOURCE_FAILED_TO_ATTACH_ERROR_HANDLER), e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingFrameContainer.this.setVisible(true);
            }
        });
    }

    public void close() {
        this.setVisible(false);
    }

    private void initComponents() {
        try {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    SwingFrameContainer.this.cancelContainer();
                }
            });
            this.initializeMacOS();
        }
        catch (SecurityException e) {
            ErrorManager.notifyDebug(ResourceUtils.getString(SwingFrameContainer.class, RESOURCE_ERROR_SET_CLOSE_OPERATION), e);
        }
        Dimension size = new Dimension(this.frameWidth, this.frameHeight);
        this.setSize(size);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        try {
            this.setIconImage(new ImageIcon(this.frameIcon.toURI().toURL()).getImage());
        }
        catch (MalformedURLException e) {
            ErrorManager.notifyWarning(ResourceUtils.getString(SwingFrameContainer.class, RESOURCE_FAILED_TO_SET_FRAME_CONTAINER_ICON), e);
        }
        String resizable = System.getProperty(WIZARD_FRAME_RESIZABLE_PROPERTY);
        if (resizable != null && (resizable.equals("false") || resizable.equals("FALSE"))) {
            this.setResizable(false);
        }
        this.contentPane = new WizardFrameContentPane();
        this.setContentPane(this.contentPane);
        this.contentPane.getHelpButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (SwingFrameContainer.this.currentUi != null) {
                    SwingFrameContainer.this.currentUi.evaluateHelpButtonClick();
                }
            }
        });
        this.contentPane.getBackButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (SwingFrameContainer.this.currentUi != null) {
                    SwingFrameContainer.this.currentUi.evaluateBackButtonClick();
                }
            }
        });
        this.contentPane.getNextButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (SwingFrameContainer.this.currentUi != null) {
                    SwingFrameContainer.this.currentUi.evaluateNextButtonClick();
                }
            }
        });
        this.contentPane.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (SwingFrameContainer.this.currentUi != null) {
                    SwingFrameContainer.this.currentUi.evaluateCancelButtonClick();
                }
            }
        });
    }

    private void initializeMacOS() {
        if (SystemUtils.isMacOS()) {
            Application application = Application.getApplication();
            if (application == null) {
                return;
            }
            application.removeAboutMenuItem();
            application.removePreferencesMenuItem();
            application.addApplicationListener(new ApplicationAdapter(){

                public void handleQuit(ApplicationEvent event) {
                    SwingFrameContainer.this.cancelContainer();
                }
            });
        }
    }

    private void cancelContainer() {
        if (this.currentUi != null && this.contentPane.getCancelButton().isEnabled()) {
            this.currentUi.evaluateCancelButtonClick();
        }
    }

    public static class WizardFrameContentPane
    extends NbiFrame.NbiFrameContentPane {
        private NbiLabel titleLabel;
        private NbiTextPane descriptionPane;
        private NbiPanel titlePanel;
        private NbiPanel titleDescriptionImageRightPanel;
        private NbiPanel titleDescriptionImageLeftPanel;
        private NbiSeparator topSeparator;
        private NbiSeparator bottomSeparator;
        private NbiButton helpButton;
        private NbiButton backButton;
        private NbiButton nextButton;
        private NbiButton cancelButton;
        private NbiPanel spacerPanel;
        private NbiPanel buttonsPanel;
        private NbiPanel currentPanel;

        public WizardFrameContentPane() {
            this.initComponents();
        }

        public void updatePanel(SwingUi panel) {
            if (this.currentPanel != null) {
                this.remove(this.currentPanel);
            }
            this.currentPanel = panel;
            if (panel.getTitle() != null) {
                this.titleLabel.setText(panel.getTitle());
                this.descriptionPane.setText(panel.getDescription());
                this.titlePanel.setVisible(true);
                this.topSeparator.setVisible(true);
                this.currentPanel.setOpaque(false);
            } else {
                this.titlePanel.setVisible(false);
                this.topSeparator.setVisible(false);
                this.currentPanel.setOpaque(true);
                this.currentPanel.setBackground(Color.WHITE);
            }
            this.add((Component)this.currentPanel, "Center");
            this.validate();
        }

        public NbiButton getHelpButton() {
            return this.helpButton;
        }

        public NbiButton getBackButton() {
            return this.backButton;
        }

        public NbiButton getNextButton() {
            return this.nextButton;
        }

        public NbiButton getCancelButton() {
            return this.cancelButton;
        }

        private void initComponents() {
            Dimension d;
            String rightImageUri;
            this.titleLabel = new NbiLabel();
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
            this.descriptionPane = new NbiTextPane();
            NbiPanel titleDescriptionPanel = new NbiPanel();
            titleDescriptionPanel.setLayout(new GridBagLayout());
            titleDescriptionPanel.setOpaque(true);
            this.titlePanel = new NbiPanel();
            this.titlePanel.setLayout(new GridBagLayout());
            this.titlePanel.setOpaque(true);
            this.titlePanel.setBackground(Color.WHITE);
            titleDescriptionPanel.setBackground(Color.WHITE);
            String backgroundImageUri = System.getProperty(SwingFrameContainer.WIZARD_FRAME_HEAD_BACKGROUND_IMAGE_URI_PROPERTY);
            if (backgroundImageUri != null) {
                titleDescriptionPanel.setBackgroundImage(backgroundImageUri, 9);
            } else {
                titleDescriptionPanel.setBackground(Color.WHITE);
            }
            String leftImageUri = System.getProperty(SwingFrameContainer.WIZARD_FRAME_HEAD_LEFT_IMAGE_URI_PROPERTY);
            int titlePanelDx = 0;
            if (leftImageUri != null) {
                this.titleDescriptionImageLeftPanel = new NbiPanel();
                this.titleDescriptionImageLeftPanel.setBackgroundImage(leftImageUri, 2);
                ImageIcon icon = this.titleDescriptionImageLeftPanel.getBackgroundImage(2);
                this.titleDescriptionImageLeftPanel.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                this.titleDescriptionImageLeftPanel.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                this.titleDescriptionImageLeftPanel.setMaximumSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                this.titleDescriptionImageLeftPanel.setMinimumSize(new Dimension(icon.getIconWidth(), 0));
                this.titleDescriptionImageLeftPanel.setSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                this.titleDescriptionImageLeftPanel.setOpaque(false);
                this.titlePanel.add((Component)this.titleDescriptionImageLeftPanel, new GridBagConstraints(titlePanelDx++, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            if ((rightImageUri = System.getProperty(SwingFrameContainer.WIZARD_FRAME_HEAD_RIGHT_IMAGE_URI_PROPERTY)) != null) {
                this.titleDescriptionImageRightPanel = new NbiPanel();
                this.titleDescriptionImageRightPanel.setBackgroundImage(rightImageUri, 2);
                ImageIcon icon = this.titleDescriptionImageRightPanel.getBackgroundImage(2);
                this.titleDescriptionImageRightPanel.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                this.titleDescriptionImageRightPanel.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                this.titleDescriptionImageRightPanel.setMaximumSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                this.titleDescriptionImageRightPanel.setMinimumSize(new Dimension(icon.getIconWidth(), 0));
                this.titleDescriptionImageRightPanel.setSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                this.titleDescriptionImageRightPanel.setOpaque(false);
                this.titlePanel.add((Component)this.titleDescriptionImageRightPanel, new GridBagConstraints(titlePanelDx + 1, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.topSeparator = new NbiSeparator();
            if (SystemUtils.isMacOS() && (d = this.topSeparator.getPreferredSize()) != null && d.getHeight() == 12.0) {
                d.setSize(d.getWidth(), 7.0);
                this.topSeparator.setPreferredSize(d);
            }
            titleDescriptionPanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(11, 11, 0, 11), 0, 0));
            titleDescriptionPanel.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 19, 1, new Insets(6, 22, 4, 11), 0, 0));
            this.titlePanel.add((Component)titleDescriptionPanel, new GridBagConstraints(titlePanelDx, 0, 1, 2, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.titlePanel.add((Component)this.topSeparator, new GridBagConstraints(0, 2, 2 + titlePanelDx, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.bottomSeparator = new NbiSeparator();
            if (SystemUtils.isMacOS() && (d = this.topSeparator.getPreferredSize()) != null && d.getHeight() == 12.0) {
                d.setSize(d.getWidth(), 7.0);
                this.topSeparator.setPreferredSize(d);
            }
            this.helpButton = new NbiButton();
            this.backButton = new NbiButton();
            this.nextButton = new NbiButton();
            this.cancelButton = new NbiButton();
            this.spacerPanel = new NbiPanel();
            this.buttonsPanel = new NbiPanel();
            this.buttonsPanel.add((Component)this.bottomSeparator, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.buttonsPanel.add((Component)this.helpButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(11, 11, 11, 11), 0, 0));
            this.buttonsPanel.add((Component)this.spacerPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.buttonsPanel.add((Component)this.backButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(11, 0, 11, 6), 0, 0));
            this.buttonsPanel.add((Component)this.nextButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(11, 0, 11, 11), 0, 0));
            this.buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(11, 0, 11, 11), 0, 0));
            this.currentPanel = new NbiPanel();
            this.setLayout(new BorderLayout());
            this.add((Component)this.titlePanel, "First");
            this.add((Component)this.currentPanel, "Center");
            this.add((Component)this.buttonsPanel, "Last");
        }
    }
}

