/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.layouts;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.swing.layouts.SharedLayoutData;
import org.openide.util.Utilities;

public final class LDPLayout
implements LayoutManager {
    private final int gap;
    private final boolean fillHorizontal;
    private final boolean fillVertical;
    private final boolean stretch;

    public LDPLayout(int gap, boolean fillHorizontal, boolean fillVertical, boolean stretch) {
        int n = this.gap = gap == 0 ? LDPLayout.defaultGap() : gap;
        if (gap < -1) {
            throw new IllegalArgumentException("Negative gap " + gap);
        }
        this.fillHorizontal = fillHorizontal;
        this.fillVertical = fillVertical;
        this.stretch = stretch;
    }

    public LDPLayout() {
        this(LDPLayout.defaultGap(), true, false, true);
    }

    private static int defaultGap() {
        return Utilities.getOperatingSystem() == 4096 ? 12 : 5;
    }

    public int getColumnPosition(Container parent, int index) {
        Insets ins = parent.getInsets();
        Component[] comps = parent.getComponents();
        int x = ins.left + ins.right;
        for (int i = 0; i < comps.length && i != index; ++i) {
            x += comps[i].getPreferredSize().width + this.gap;
        }
        return x;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension result = this.layoutSize(parent, false);
        if (this.stretch) {
            int width = parent.getWidth();
            Insets ins = parent.getInsets();
            if (result.width < (width -= ins.left + ins.right)) {
                result.width = width;
            }
        }
        return result;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, true);
    }

    private Dimension layoutSize(Container parent, boolean isMin) {
        Insets ins = parent.getInsets();
        Component[] comps = parent.getComponents();
        int x = ins.left + ins.right;
        int y = ins.top + ins.bottom;
        SharedLayoutData data = (SharedLayoutData)((Object)SwingUtilities.getAncestorOfClass(SharedLayoutData.class, parent));
        if (data == null) {
            for (Component c : comps) {
                Dimension d = isMin ? c.getMinimumSize() : c.getPreferredSize();
                x += d.width + this.gap;
                y = Math.max(y, d.height);
            }
        } else {
            for (int i = 0; i < comps.length; ++i) {
                int colpos = data.xPosForColumn(i);
                Dimension d = comps[i].getPreferredSize();
                x = colpos + d.width + this.gap;
            }
        }
        y = Math.max(30, y);
        return new Dimension(x, y);
    }

    private Rectangle[] getBoundingBoxes(Container parent, Component[] comps) {
        Insets ins = parent.getInsets();
        Rectangle[] result = new Rectangle[comps.length];
        int y = ins.top;
        SharedLayoutData data = (SharedLayoutData)((Object)SwingUtilities.getAncestorOfClass(SharedLayoutData.class, parent));
        int h = 0;
        for (Component c : comps) {
            Dimension d = c.getPreferredSize();
            h = Math.max(h, d.height);
        }
        h = Math.max(30, h);
        int nextLoc = ins.left;
        for (int i = 0; i < comps.length; ++i) {
            int nextPos;
            int yy;
            int colpos = data == null ? nextLoc : data.xPosForColumn(i);
            Dimension d = comps[i].getPreferredSize();
            Component c = comps[i];
            if (!this.fillHorizontal && !this.fillVertical) {
                yy = d.height == h ? 0 : h / 2 - d.height / 2;
                result[i] = new Rectangle(colpos, y + yy, d.width, d.height);
            } else if (this.fillHorizontal && !this.fillVertical) {
                yy = d.height == h ? 0 : h / 2 - d.height / 2;
                nextPos = data.xPosForColumn(i + 1);
                int ww = nextPos == colpos ? parent.getWidth() - ins.right - colpos : nextPos - this.gap - colpos;
                result[i] = new Rectangle(colpos, y + yy, ww, d.height);
            } else if (!this.fillHorizontal && this.fillVertical) {
                result[i] = new Rectangle(colpos, y, d.width, h);
            } else if (this.fillVertical) {
                nextPos = data.xPosForColumn(i + 1);
                int ww = nextPos == colpos ? parent.getWidth() - ins.right - colpos : nextPos - this.gap - colpos;
                result[i] = new Rectangle(colpos, y, ww, h);
            }
            nextLoc += result[i].width + this.gap;
        }
        return result;
    }

    @Override
    public void layoutContainer(Container parent) {
        Component[] c = parent.getComponents();
        Rectangle[] r = this.getBoundingBoxes(parent, c);
        if (this.stretch) {
            Insets ins = parent.getInsets();
            int usedWidth = r[r.length - 1].x + r[r.length - 1].width - ins.left;
            int stretchyCount = 0;
            int usableWidth = parent.getWidth() - (ins.left + ins.right);
            if (usableWidth > usedWidth) {
                for (Component aC : c) {
                    if (!this.isStretchy(aC)) continue;
                    ++stretchyCount;
                }
                if (stretchyCount > 0) {
                    int redistributableSpace = usableWidth - usedWidth;
                    int amtPerComponent = redistributableSpace / stretchyCount;
                    int amtAdded = 0;
                    for (int i = 0; i < r.length; ++i) {
                        r[i].x += amtAdded;
                        if (!this.isStretchy(c[i])) continue;
                        r[i].width += amtPerComponent;
                        amtAdded += amtPerComponent;
                    }
                }
            }
        }
        for (int i = 0; i < c.length; ++i) {
            c[i].setBounds(r[i]);
        }
    }

    private boolean isStretchy(Component c) {
        boolean notResult = c instanceof JLabel || c instanceof AbstractButton || c instanceof Label || c instanceof Button;
        return !notResult;
    }
}

