/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.List;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadGroupReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;
import org.openide.util.Exceptions;

public class JPDAThreadGroupImpl
implements JPDAThreadGroup {
    private ThreadGroupReference tgr;
    private JPDADebuggerImpl debugger;
    private String name;

    public JPDAThreadGroupImpl(ThreadGroupReference tgr, JPDADebuggerImpl debugger) {
        this.tgr = tgr;
        this.debugger = debugger;
        this.name = "";
        try {
            this.name = ThreadGroupReferenceWrapper.name(tgr);
        }
        catch (InternalExceptionWrapper de) {
        }
        catch (VMDisconnectedExceptionWrapper de) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            // empty catch block
        }
        debugger.interestedInThreadGroup(this);
    }

    public JPDAThreadGroup getParentThreadGroup() {
        ThreadGroupReference ptgr = null;
        try {
            ptgr = ThreadGroupReferenceWrapper.parent(this.tgr);
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        if (ptgr == null) {
            return null;
        }
        return this.debugger.getThreadGroup(ptgr);
    }

    public JPDAThread[] getThreads() {
        ThreadsCache tc = this.debugger.getThreadsCache();
        if (tc == null) {
            return new JPDAThread[0];
        }
        List<ThreadReference> l = tc.getThreads(this.tgr);
        int k = l.size();
        JPDAThread[] ts = new JPDAThread[k];
        for (int i = 0; i < k; ++i) {
            ts[i] = this.debugger.getThread(l.get(i));
        }
        return ts;
    }

    public JPDAThreadGroup[] getThreadGroups() {
        ThreadsCache tc = this.debugger.getThreadsCache();
        if (tc == null) {
            return new JPDAThreadGroup[0];
        }
        List<ThreadGroupReference> l = tc.getGroups(this.tgr);
        int k = l.size();
        JPDAThreadGroup[] ts = new JPDAThreadGroup[k];
        for (int i = 0; i < k; ++i) {
            ts[i] = this.debugger.getThreadGroup(l.get(i));
        }
        return ts;
    }

    public String getName() {
        return this.name;
    }

    public void resume() {
        ThreadsCache tc = this.debugger.getThreadsCache();
        if (tc == null) {
            return;
        }
        this.notifyToBeResumed(tc);
        try {
            ThreadGroupReferenceWrapper.resume(this.tgr);
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (VMDisconnectedExceptionWrapper ex) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void suspend() {
        ThreadsCache tc = this.debugger.getThreadsCache();
        if (tc == null) {
            return;
        }
        try {
            ThreadGroupReferenceWrapper.suspend(this.tgr);
        }
        catch (InternalExceptionWrapper ex) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        this.notifySuspended(tc);
    }

    void notifyToBeResumed(ThreadsCache tc) {
        List<ThreadReference> threads = tc.getThreads(this.tgr);
        for (ThreadReference threadRef : threads) {
            JPDAThreadImpl thread = this.debugger.getThread(threadRef);
            thread.notifyToBeResumed();
        }
        List<ThreadGroupReference> groups = tc.getGroups(this.tgr);
        for (ThreadGroupReference groupRef : groups) {
            JPDAThreadGroupImpl group = (JPDAThreadGroupImpl)this.debugger.getThreadGroup(groupRef);
            group.notifyToBeResumed(tc);
        }
    }

    void notifySuspended(ThreadsCache tc) {
        List<ThreadReference> threads = tc.getThreads(this.tgr);
        for (ThreadReference threadRef : threads) {
            JPDAThreadImpl thread = this.debugger.getThread(threadRef);
            thread.notifySuspended();
        }
        List<ThreadGroupReference> groups = tc.getGroups(this.tgr);
        for (ThreadGroupReference groupRef : groups) {
            JPDAThreadGroupImpl group = (JPDAThreadGroupImpl)this.debugger.getThreadGroup(groupRef);
            group.notifySuspended(tc);
        }
    }
}

