/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProjectTemplateZipHelper
extends BaseHelper {
    private static final String PROJECT_XML = "nbproject/project.xml";
    private static final String BUILD_IMPL_XML = "nbproject/build-impl.xml";
    private static final String BUILD_XML = "build.xml";
    private static final String PLATFORM_PROPERTIES = "nbproject/platform.properties";
    private static final String SUITE_PROPERTIES = "nbproject/suite.properties";
    private static final String SUITE_PRIVATE_PROPERTIES = "nbproject/private/suite-private.properties";
    private static final String CODE_NAME_BASE = "code-name-base";
    private static final String DATA = "data";
    private static final String CODE_NAME_PARAM = "_CODE_NAME_";
    private static final String BUNDLE_PATH_PARAM = "_BUNDLE_PATH_";
    private static final String PROJECT_NAME_PARAM = "_PROJECT_NAME_";
    private static final String PLATFORM_ID_PARAM = "_PLATFORM_ID_";
    private static final String SUITE_PATH_PARAM = "suite.dir";
    private static final String BUNDLE_NAME = "src/Bundle.properties";
    private static final String LAYER_NAME = "src/layer.xml";
    private static final String MANIFEST = "manifest.mf";
    private static final String LAYER = "OpenIDE-Module-Layer: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(InputStream source, FileObject projectRoot, WizardDescriptor wizard) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream zipIS = new ZipInputStream(source);
            while ((entry = zipIS.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)projectRoot, (String)entry.getName());
                    continue;
                }
                FileObject fo = null;
                if (PROJECT_XML.equals(entry.getName())) {
                    fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                    ProjectTemplateZipHelper.filterProjectXML(fo, zipIS, (String)wizard.getProperty("codeBaseName"));
                    continue;
                }
                if (MANIFEST.equals(entry.getName())) {
                    fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                    ProjectTemplateZipHelper.filterManifest(fo, zipIS, wizard);
                    continue;
                }
                if (PLATFORM_PROPERTIES.equals(entry.getName())) {
                    fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                    ProjectTemplateZipHelper.filterPlatformProperties(fo, zipIS, wizard);
                    continue;
                }
                if (LAYER_NAME.equals(entry.getName())) {
                    ProjectTemplateZipHelper.copyLayer(projectRoot, zipIS, wizard);
                    continue;
                }
                if (BUNDLE_NAME.equals(entry.getName())) {
                    ProjectTemplateZipHelper.filterBundle(projectRoot, zipIS, wizard);
                    continue;
                }
                if (BUILD_XML.equals(entry.getName()) || BUILD_IMPL_XML.equals(entry.getName())) {
                    fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                    ProjectTemplateZipHelper.filterBuild(fo, zipIS, (String)wizard.getProperty("codeBaseName"));
                    continue;
                }
                fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                ProjectTemplateZipHelper.copyByteAfterByte(zipIS, fo);
            }
        }
        finally {
            source.close();
        }
        ProjectTemplateZipHelper.createSuiteProperties(projectRoot, wizard);
    }

    private static void createSuiteProperties(FileObject projectDir, WizardDescriptor wizard) throws IOException {
        String suitePropertiesLocation;
        String suiteLocation;
        String suiteDirPath;
        File suiteDir;
        if (!ProjectTemplateZipHelper.isSuiteComponent(wizard)) {
            return;
        }
        File projectDirF = FileUtil.toFile((FileObject)projectDir);
        String rel = PropertyUtils.relativizeFile((File)projectDirF, (File)(suiteDir = FileUtil.normalizeFile((File)new File(suiteDirPath = ProjectTemplateZipHelper.getSuiteRoot(wizard)))));
        if (rel != null) {
            suiteLocation = "${basedir}/" + rel;
            suitePropertiesLocation = SUITE_PROPERTIES;
        } else {
            suiteLocation = suiteDir.getAbsolutePath();
            suitePropertiesLocation = SUITE_PRIVATE_PROPERTIES;
        }
        EditableProperties props = new EditableProperties(true);
        props.setProperty(SUITE_PATH_PARAM, suiteLocation);
        FileObject suiteProperties = FileUtil.createData((FileObject)projectDir, (String)suitePropertiesLocation);
        ProjectTemplateZipHelper.storeProperties(suiteProperties, props);
    }

    private static void filterBuild(FileObject fo, ZipInputStream zipIS, String codeBaseName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)zipIS, (OutputStream)baos);
        String content = baos.toString("UTF-8");
        content = content.replace(CODE_NAME_PARAM, codeBaseName);
        ProjectTemplateZipHelper.copyByteAfterByte(content, fo);
    }

    private static void filterBundle(FileObject projectRoot, ZipInputStream is, WizardDescriptor wizardDescriptor) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)is, (OutputStream)baos);
        String content = baos.toString("UTF-8");
        content = content.replace(PROJECT_NAME_PARAM, (String)wizardDescriptor.getProperty("displayName"));
        FileObject fileObject = FileUtil.createData((FileObject)projectRoot, (String)("src/" + (String)wizardDescriptor.getProperty("bundle")));
        ProjectTemplateZipHelper.copyByteAfterByte(content, fileObject);
    }

    private static void copyLayer(FileObject projectRoot, ZipInputStream is, WizardDescriptor wizard) throws IOException {
        String layer = (String)wizard.getProperty("layer");
        if (layer == null || layer.length() == 0) {
            return;
        }
        FileObject fileObject = FileUtil.createData((FileObject)projectRoot, (String)("src/" + layer));
        ProjectTemplateZipHelper.copyByteAfterByte(is, fileObject);
    }

    private static void filterManifest(FileObject fo, ZipInputStream is, WizardDescriptor wizard) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)is, (OutputStream)baos);
        String content = baos.toString("UTF-8");
        content = content.replace(CODE_NAME_PARAM, (String)wizard.getProperty("codeBaseName"));
        content = content.replace(BUNDLE_PATH_PARAM, (String)wizard.getProperty("bundle"));
        StringBuilder builder = new StringBuilder(content);
        String layer = (String)wizard.getProperty("layer");
        if (layer != null) {
            builder.append(LAYER);
            builder.append(layer);
            builder.append("\n");
        }
        ProjectTemplateZipHelper.copyByteAfterByte(builder.toString(), fo);
    }

    private static void filterPlatformProperties(FileObject fo, ZipInputStream is, WizardDescriptor wizard) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)is, (OutputStream)baos);
        String content = baos.toString("UTF-8");
        content = content.replace(PLATFORM_ID_PARAM, ProjectTemplateZipHelper.getActivePlatform(wizard));
        ProjectTemplateZipHelper.copyByteAfterByte(content, fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterProjectXML(FileObject fo, ZipInputStream str, String name) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)str, (OutputStream)baos);
            Document doc = XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(baos.toByteArray())), (boolean)false, (boolean)false, null, null);
            NodeList nl = doc.getDocumentElement().getElementsByTagName(CODE_NAME_BASE);
            if (nl != null) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    if (el.getParentNode() == null || !DATA.equals(el.getParentNode().getNodeName())) continue;
                    NodeList nl2 = el.getChildNodes();
                    if (nl2.getLength() <= 0) break;
                    nl2.item(0).setNodeValue(name);
                    break;
                }
            }
            OutputStream out = fo.getOutputStream();
            try {
                XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF-8");
            }
            finally {
                out.close();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            ProjectTemplateZipHelper.copyByteAfterByte(str, fo);
        }
    }
}

