/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.StackFrame;
import org.netbeans.lib.profiler.heap.TagBounds;

class StackFrameSegment
extends TagBounds {
    HprofHeap hprofHeap;
    final int methodIDOffset;
    final int stackFrameIDOffset;
    final int lengthOffset;
    final int sourceIDOffset;
    final int methodSignatureIDOffset;
    final int timeOffset;
    final int classSerialNumberOffset;
    final int lineNumberOffset;

    StackFrameSegment(HprofHeap heap, long start, long end) {
        super(5, start, end);
        int idSize = heap.dumpBuffer.getIDSize();
        this.hprofHeap = heap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stackFrameIDOffset = this.lengthOffset + 4;
        this.methodIDOffset = this.stackFrameIDOffset + idSize;
        this.methodSignatureIDOffset = this.methodIDOffset + idSize;
        this.sourceIDOffset = this.methodSignatureIDOffset + idSize;
        this.classSerialNumberOffset = this.sourceIDOffset + idSize;
        this.lineNumberOffset = this.classSerialNumberOffset + 4;
    }

    StackFrame getStackFrameByID(long stackFrameID) {
        long[] offset = new long[]{this.startOffset};
        while (offset[0] < this.endOffset) {
            long start = offset[0];
            long frameID = this.readStackFrameTag(offset);
            if (frameID != stackFrameID) continue;
            return new StackFrame(this, start);
        }
        return null;
    }

    private HprofByteBuffer getDumpBuffer() {
        return this.hprofHeap.dumpBuffer;
    }

    private long readStackFrameTag(long[] offset) {
        long start = offset[0];
        if (this.hprofHeap.readTag(offset) != 4) {
            return 0L;
        }
        return this.getDumpBuffer().getID(start + (long)this.stackFrameIDOffset);
    }
}

