/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.ErrorManager;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class DebuggerBreakpointAnnotation
extends BreakpointAnnotation {
    private final Line line;
    private final String type;
    private final Breakpoint breakpoint;

    DebuggerBreakpointAnnotation(String type, Line line, Breakpoint breakpoint) {
        this.type = type;
        this.line = line;
        this.breakpoint = breakpoint;
        this.attach((Annotatable)line);
    }

    public String getAnnotationType() {
        return this.type;
    }

    Line getLine() {
        return this.line;
    }

    public String getShortDescription() {
        if (this.type.endsWith("_broken")) {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_BREAKPOINT_BROKEN");
        }
        if (this.type == "Breakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_BREAKPOINT");
        }
        if (this.type == "DisabledBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_BREAKPOINT");
        }
        if (this.type == "CondBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == "DisabledCondBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == "FieldBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_FIELD_BREAKPOINT");
        }
        if (this.type == "DisabledFieldBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_FIELD_BREAKPOINT");
        }
        if (this.type == "MethodBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_METHOD_BREAKPOINT");
        }
        if (this.type == "DisabledMethodBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_METHOD_BREAKPOINT");
        }
        if (this.type == "ClassBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_CLASS_BREAKPOINT");
        }
        if (this.type == "DisabledClassBreakpoint") {
            return NbBundle.getBundle(DebuggerBreakpointAnnotation.class).getString("TOOLTIP_DISABLED_CLASS_BREAKPOINT");
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown breakpoint type '" + this.type + "'."));
        return null;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }
}

