/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.util.NbBundle;

public class ValidatorsPanel
extends JPanel {
    private WSDLComponent comp;
    private Project p;
    private boolean inSync = false;
    private String profile;
    private ConfigVersion cfgVersion = null;
    private JButton certificateValidatorButton;
    private JLabel certificateValidatorLabel;
    private JTextField certificateValidatorTextField;
    private JToggleButton jToggleButton1;
    private JButton samlValidatorButton;
    private JLabel samlValidatorLabel;
    private JTextField samlValidatorTextField;
    private JButton timestampValidatorButton;
    private JLabel timestampValidatorLabel;
    private JTextField timestampValidatorTextField;
    private JButton usernameValidatorButton;
    private JLabel usernameValidatorLabel;
    private JTextField usernameValidatorTextField;

    public ValidatorsPanel(WSDLComponent comp, Project p, String profile, ConfigVersion cfgVersion) {
        this.comp = comp;
        this.p = p;
        this.profile = profile;
        this.cfgVersion = cfgVersion;
        this.initComponents();
        this.usernameValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.usernameValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.timestampValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.timestampValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certificateValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certificateValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.samlValidatorTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.samlValidatorLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
    }

    private String getValidator(String type) {
        if ("usernameValidator".equals(type)) {
            return this.usernameValidatorTextField.getText();
        }
        if ("timestampValidator".equals(type)) {
            return this.timestampValidatorTextField.getText();
        }
        if ("certificateValidator".equals(type)) {
            return this.certificateValidatorTextField.getText();
        }
        if ("samlAssertionValidator".equals(type)) {
            return this.samlValidatorTextField.getText();
        }
        return null;
    }

    private void setValidator(String type, String validator) {
        if ("usernameValidator".equals(type)) {
            this.usernameValidatorTextField.setText(validator);
        }
        if ("timestampValidator".equals(type)) {
            this.timestampValidatorTextField.setText(validator);
        }
        if ("certificateValidator".equals(type)) {
            this.certificateValidatorTextField.setText(validator);
        }
        if ("samlAssertionValidator".equals(type)) {
            this.samlValidatorTextField.setText(validator);
        }
    }

    private void sync() {
        String samlValidator;
        String certificateValidator;
        String timestampValidator;
        this.inSync = true;
        String usernameValidator = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "usernameValidator");
        if (usernameValidator != null) {
            this.setValidator("usernameValidator", usernameValidator);
        }
        if ((timestampValidator = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "timestampValidator")) != null) {
            this.setValidator("timestampValidator", timestampValidator);
        }
        if ((certificateValidator = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "certificateValidator")) != null) {
            this.setValidator("certificateValidator", certificateValidator);
        }
        if ((samlValidator = ProprietarySecurityPolicyModelHelper.getValidator(this.comp, "samlAssertionValidator")) != null) {
            this.setValidator("samlAssertionValidator", samlValidator);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void enableDisable() {
        boolean samlRequired = true;
        boolean userRequired = true;
        boolean certRequired = true;
        boolean timeRequired = true;
        if (ComboConstants.PROF_USERNAME.equals(this.profile)) {
            samlRequired = false;
            certRequired = false;
            timeRequired = false;
        }
        if (ComboConstants.PROF_MUTUALCERT.equals(this.profile) || ComboConstants.PROF_ENDORSCERT.equals(this.profile)) {
            samlRequired = false;
            userRequired = false;
            timeRequired = false;
        }
        if (ComboConstants.PROF_MSGAUTHSSL.equals(this.profile)) {
            samlRequired = false;
            timeRequired = false;
        }
        if (ComboConstants.PROF_SAMLSSL.equals(this.profile) || ComboConstants.PROF_SAMLHOLDER.equals(this.profile) || ComboConstants.PROF_SAMLSENDER.equals(this.profile)) {
            certRequired = false;
            userRequired = false;
            timeRequired = false;
        }
        this.samlValidatorButton.setEnabled(samlRequired);
        this.samlValidatorLabel.setEnabled(samlRequired);
        this.samlValidatorTextField.setEnabled(samlRequired);
        this.usernameValidatorButton.setEnabled(userRequired);
        this.usernameValidatorLabel.setEnabled(userRequired);
        this.usernameValidatorTextField.setEnabled(userRequired);
        this.timestampValidatorButton.setEnabled(timeRequired);
        this.timestampValidatorLabel.setEnabled(timeRequired);
        this.timestampValidatorTextField.setEnabled(timeRequired);
        this.certificateValidatorButton.setEnabled(certRequired);
        this.certificateValidatorLabel.setEnabled(certRequired);
        this.certificateValidatorTextField.setEnabled(certRequired);
    }

    public void storeState() {
        String usernameV = this.getValidator("usernameValidator");
        if (usernameV == null || usernameV.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "usernameValidator", null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "usernameValidator", usernameV, false);
        }
        String certV = this.getValidator("certificateValidator");
        if (certV == null || certV.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "certificateValidator", null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "certificateValidator", certV, false);
        }
        String timeV = this.getValidator("timestampValidator");
        if (timeV == null || timeV.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "timestampValidator", null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "timestampValidator", timeV, false);
        }
        String samlV = this.getValidator("samlAssertionValidator");
        if (samlV == null || samlV.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "samlAssertionValidator", null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setValidator(this.comp, "samlAssertionValidator", samlV, false);
        }
    }

    private void initComponents() {
        this.jToggleButton1 = new JToggleButton();
        this.usernameValidatorLabel = new JLabel();
        this.timestampValidatorLabel = new JLabel();
        this.certificateValidatorLabel = new JLabel();
        this.samlValidatorLabel = new JLabel();
        this.usernameValidatorTextField = new JTextField();
        this.timestampValidatorTextField = new JTextField();
        this.certificateValidatorTextField = new JTextField();
        this.samlValidatorTextField = new JTextField();
        this.usernameValidatorButton = new JButton();
        this.timestampValidatorButton = new JButton();
        this.certificateValidatorButton = new JButton();
        this.samlValidatorButton = new JButton();
        this.jToggleButton1.setText("jToggleButton1");
        this.usernameValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_UsernameVLabel"));
        this.timestampValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_TimestampVLabel"));
        this.certificateValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_CertificateVLabel"));
        this.samlValidatorLabel.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_SAMLVLabel"));
        this.usernameValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.usernameValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidatorsPanel.this.usernameValidatorButtonActionPerformed(evt);
            }
        });
        this.timestampValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.timestampValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidatorsPanel.this.timestampValidatorButtonActionPerformed(evt);
            }
        });
        this.certificateValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.certificateValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidatorsPanel.this.certificateValidatorButtonActionPerformed(evt);
            }
        });
        this.samlValidatorButton.setText(NbBundle.getMessage(ValidatorsPanel.class, (String)"LBL_ValidatorPanel_Browse"));
        this.samlValidatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidatorsPanel.this.samlValidatorButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.timestampValidatorLabel).add((Component)this.certificateValidatorLabel).add((Component)this.samlValidatorLabel).add((Component)this.usernameValidatorLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.samlValidatorTextField, -2, 296, -2).addPreferredGap(0)).add((Component)this.certificateValidatorTextField, -2, 305, -2).add((Component)this.timestampValidatorTextField, -2, 308, -2)).add((Component)this.usernameValidatorTextField, -2, 308, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.samlValidatorButton).add((Component)this.certificateValidatorButton).add((Component)this.timestampValidatorButton).add((Component)this.usernameValidatorButton)).addPreferredGap(0).add((Component)this.jToggleButton1, -2, 0, -2)));
        layout.linkSize(new Component[]{this.certificateValidatorTextField, this.samlValidatorTextField, this.timestampValidatorTextField, this.usernameValidatorTextField}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(69, 69, 69).add((Component)this.jToggleButton1)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.usernameValidatorLabel).add((Component)this.usernameValidatorButton).add((Component)this.usernameValidatorTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timestampValidatorLabel).add((Component)this.timestampValidatorButton).add((Component)this.timestampValidatorTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.certificateValidatorLabel).add((Component)this.certificateValidatorButton).add((Component)this.certificateValidatorTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.samlValidatorLabel).add((Component)this.samlValidatorButton).add((Component)this.samlValidatorTextField, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void samlValidatorButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.SAMLAssertionValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setValidator("samlAssertionValidator", selectedClass);
            }
        }
    }

    private void certificateValidatorButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.CertificateValidationCallback.CertificateValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setValidator("certificateValidator", selectedClass);
            }
        }
    }

    private void timestampValidatorButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.TimestampValidationCallback.TimestampValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setValidator("timestampValidator", selectedClass);
            }
        }
    }

    private void usernameValidatorButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.p == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.p, "com.sun.xml.wss.impl.callback.PasswordValidationCallback.PasswordValidator");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setValidator("usernameValidator", selectedClass);
            }
        }
    }
}

