/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRefactoringPlugin;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class WSITRenameRefactoringPlugin
extends WSITRefactoringPlugin<RenameRefactoring> {
    public WSITRenameRefactoringPlugin(RenameRefactoring refactoring) {
        super(refactoring);
    }

    @Override
    protected RefactoringElementImplementation createClassRE(WSDLModel model) {
        return new ClassRE(((RenameRefactoring)this.refactoring).getNewName(), model);
    }

    @Override
    protected RefactoringElementImplementation createMethodRE(String methodName, WSDLModel model) {
        return new MethodRE(methodName, ((RenameRefactoring)this.refactoring).getNewName(), model);
    }

    private static class MethodRE
    extends WSITRefactoringPlugin.AbstractRefactoringElement {
        private final String oldName;
        private final String newName;

        public MethodRE(String oldName, String newName, WSDLModel model) {
            super(model);
            this.oldName = oldName;
            this.newName = newName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            Definitions d = this.model.getDefinitions();
            Binding b = (Binding)d.getBindings().toArray()[0];
            Collection bOperations = b.getBindingOperations();
            PortType portType = (PortType)d.getPortTypes().toArray()[0];
            Collection operations = portType.getOperations();
            this.model.startTransaction();
            try {
                for (BindingOperation bOperation : bOperations) {
                    if (!this.oldName.equals(bOperation.getName())) continue;
                    bOperation.setName(this.newName);
                }
                for (Operation o : operations) {
                    Output out;
                    if (!this.oldName.equals(o.getName())) continue;
                    o.setName(this.newName);
                    Input i = o.getInput();
                    if (i != null) {
                        QName qname = i.getMessage().getQName();
                        Message msg = (Message)this.model.findComponentByName(qname, Message.class);
                        String oMsgName = msg.getName();
                        if (oMsgName != null) {
                            String nMsgName = oMsgName.replaceAll(this.oldName, this.newName);
                            msg.setName(nMsgName);
                        }
                        i.setMessage(i.createReferenceTo((ReferenceableWSDLComponent)msg, Message.class));
                    }
                    if ((out = o.getOutput()) == null) continue;
                    QName qname = out.getMessage().getQName();
                    Message msg = (Message)this.model.findComponentByName(qname, Message.class);
                    String oMsgName = msg.getName();
                    if (oMsgName != null) {
                        String nMsgName = oMsgName.replaceAll(this.oldName, this.newName);
                        msg.setName(nMsgName);
                    }
                    out.setMessage(out.createReferenceTo((ReferenceableWSDLComponent)msg, Message.class));
                }
            }
            finally {
                this.model.endTransaction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undoChange() {
            Definitions d = this.model.getDefinitions();
            Binding b = (Binding)d.getBindings().toArray()[0];
            Collection bOperations = b.getBindingOperations();
            PortType portType = (PortType)d.getPortTypes().toArray()[0];
            Collection operations = portType.getOperations();
            this.model.startTransaction();
            try {
                for (BindingOperation bOperation : bOperations) {
                    if (!this.newName.equals(bOperation.getName())) continue;
                    bOperation.setName(this.oldName);
                }
                for (Operation o : operations) {
                    Output out;
                    if (!this.newName.equals(o.getName())) continue;
                    o.setName(this.oldName);
                    Input i = o.getInput();
                    if (i != null) {
                        QName qname = i.getMessage().getQName();
                        Message msg = (Message)this.model.findComponentByName(qname, Message.class);
                        String oMsgName = msg.getName();
                        if (oMsgName != null) {
                            String nMsgName = oMsgName.replaceAll(this.newName, this.oldName);
                            msg.setName(nMsgName);
                        }
                        i.setMessage(i.createReferenceTo((ReferenceableWSDLComponent)msg, Message.class));
                    }
                    if ((out = o.getOutput()) == null) continue;
                    QName qname = out.getMessage().getQName();
                    Message msg = (Message)this.model.findComponentByName(qname, Message.class);
                    String oMsgName = msg.getName();
                    if (oMsgName != null) {
                        String nMsgName = oMsgName.replaceAll(this.newName, this.oldName);
                        msg.setName(nMsgName);
                    }
                    out.setMessage(out.createReferenceTo((ReferenceableWSDLComponent)msg, Message.class));
                }
            }
            finally {
                this.model.endTransaction();
            }
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(MethodRE.class, (String)"TXT_WsitXmlMethodRename"), args);
        }
    }

    private static class ClassRE
    extends WSITRefactoringPlugin.AbstractRefactoringElement {
        private final String oldConfigName = this.getParentFile().getName();
        private final String newConfigName;
        private final String extension;

        public ClassRE(String newName, WSDLModel model) {
            super(model);
            this.newConfigName = this.oldConfigName.substring(0, this.oldConfigName.lastIndexOf(46) + 1) + newName;
            this.extension = this.getParentFile().getExt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            FileLock lock = null;
            FileObject parentFile = this.getParentFile();
            try {
                lock = parentFile.lock();
                parentFile.rename(lock, this.newConfigName, this.extension);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undoChange() {
            FileLock lock = null;
            FileObject parentFile = this.getParentFile();
            try {
                lock = parentFile.lock();
                parentFile.rename(lock, this.oldConfigName, this.extension);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.oldConfigName, this.newConfigName};
            return MessageFormat.format(NbBundle.getMessage(ClassRE.class, (String)"TXT_WsitXmlClassRename"), args);
        }
    }
}

