/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRefactoringPlugin;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class WSITMoveRefactoringPlugin
implements RefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(WSITMoveRefactoringPlugin.class.getName());
    private MoveRefactoring refactoring;

    WSITMoveRefactoringPlugin(MoveRefactoring moveRefactoring) {
        this.refactoring = moveRefactoring;
    }

    public void cancelRequest() {
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        FileObject fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
        if (fileObject == null || fileObject.isFolder()) {
            return null;
        }
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
        if (jAXWSSupport == null) {
            return null;
        }
        WSDLModel wSDLModel = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        try {
            wSDLModel = WSITModelSupport.getModelForServiceFromJava(fileObject, project, false, null);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, null, iOException);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, null, exception);
        }
        if (wSDLModel == null) {
            return null;
        }
        String string = WSITMoveRefactoringPlugin.getPackageName((URL)this.refactoring.getTarget().lookup(URL.class));
        refactoringElementsBag.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new MoveClassElement(wSDLModel, fileObject, string));
        return null;
    }

    public static String getPackageName(URL uRL) {
        File file = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + uRL);
        }
        String string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return WSITMoveRefactoringPlugin.getPackageName(fileObject);
                }
                String string2 = WSITMoveRefactoringPlugin.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1)) + string;
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + uRL);
    }

    private static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    private static class MoveClassElement
    extends WSITRefactoringPlugin.AbstractRenameConfigElement {
        MoveClassElement(WSDLModel wSDLModel, FileObject fileObject, String string) {
            super(wSDLModel);
            String string2 = JavaIdentifiers.getQualifiedName((FileObject)fileObject.getParent());
            String string3 = this.getParentFile().getName();
            this.setOldConfigName(string3);
            this.setNewConfigName(string3.replace(string2, string));
        }
    }
}

