/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.profiler;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class MavenProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    private ProfilingSettings lastProfilingSettings;
    private SessionSettings lastSessionSettings;
    private Properties lastSessionProperties;
    private final Set<String> supportedPTypes = new HashSet<String>(){
        {
            this.add("jar");
            this.add("war");
            this.add("ejb");
            this.add("nbm");
            this.add("nbm-application");
            this.add("bundle");
        }
    };

    ProfilingSettings getLastProfilingSettings() {
        return this.lastProfilingSettings;
    }

    SessionSettings getLastSessionSettings() {
        return this.lastSessionSettings;
    }

    Properties getLastSessionProperties() {
        return this.lastSessionProperties;
    }

    public String getProfilerTargetName(Project project, FileObject buildScript, int type, FileObject profiledClassFile) {
        throw new UnsupportedOperationException("Not supported");
    }

    public JavaPlatform getProjectJavaPlatform(Project project) {
        return JavaPlatform.getDefault();
    }

    public boolean isProfilingSupported(Project project) {
        NbMavenProject mproject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        return mproject == null ? false : this.supportedPTypes.contains(mproject.getPackagingType());
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject profiledClassFile) {
        return true;
    }

    public boolean checkProjectIsModifiedForProfiler(Project project) {
        return true;
    }

    public boolean startProfilingSession(final Project project, final FileObject profiledClassFile, final boolean isTest, final Properties properties) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MavenProjectTypeProfiler.this.startMaven(project, profiledClassFile, isTest, properties);
            }
        });
        return true;
    }

    private void startMaven(Project project, FileObject profiledClassFile, boolean isTest, Properties properties) {
        this.lastProfilingSettings = new ProfilingSettings();
        this.lastSessionSettings = new SessionSettings();
        this.lastSessionProperties = new Properties(properties);
        this.lastProfilingSettings.load((Map)properties);
        this.lastSessionSettings.load((Map)properties);
        NetBeansProfiler.getDefaultNB().setProfiledProject(project, profiledClassFile);
        String packaging = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getPackagingType();
        if (profiledClassFile != null) {
            ProjectUtilities.invokeAction((Project)project, (String)(isTest ? "profile-tests" : (packaging.equals("war") ? "profile-single.deploy" : "profile-single")));
        } else {
            ProjectUtilities.invokeAction((Project)project, (String)(isTest ? "profile-tests" : "profile"));
        }
    }
}

