/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorTree;
import org.openide.ErrorManager;

final class SVGNavigatorNode
implements TreeNode,
DocumentElementListener {
    private final SVGNavigatorTree m_nodeTree;
    private final DocumentElement m_de;
    private final TreeNode m_parent;
    private byte m_nodeVisibility;
    private List<SVGNavigatorNode> m_children = null;
    private boolean m_containsError = false;
    private int m_childrenErrorCount = 0;
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final int ATTRIBS_MAX_LEN = 100;

    public SVGNavigatorNode(DocumentElement de, SVGNavigatorTree nodeTree, TreeNode parent, byte nodeVisibility) {
        this.m_de = de;
        this.m_nodeTree = nodeTree;
        this.m_parent = parent;
        this.m_nodeVisibility = nodeVisibility;
    }

    public Enumeration<SVGNavigatorNode> children() {
        this.checkChildrenAdapters();
        return Collections.enumeration(this.m_children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int param) {
        this.checkChildrenAdapters();
        return this.m_children.get(param);
    }

    @Override
    public int getChildCount() {
        this.checkChildrenAdapters();
        return this.m_children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.checkChildrenAdapters();
        return this.m_children.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.m_parent;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DocumentElement getDocumentElement() {
        assert (this.m_de != null);
        return this.m_de;
    }

    public byte getNodeVisibility() {
        return this.m_nodeVisibility;
    }

    SVGNavigatorNode findNode(DocumentElement docElem) {
        SVGNavigatorNode node = null;
        if (this.m_de.equals((Object)docElem)) {
            node = this;
        } else if (this.m_children != null) {
            for (int i = this.m_children.size() - 1; i >= 0 && (node = this.m_children.get(i).findNode(docElem)) == null; --i) {
            }
        }
        return node;
    }

    SVGNavigatorNode getChildByElemenent(DocumentElement de) {
        this.checkChildrenAdapters();
        if (this.m_children != null) {
            for (SVGNavigatorNode child : this.m_children) {
                if (child.getDocumentElement() != de) continue;
                return child;
            }
        }
        return null;
    }

    TreePath getNodePath() {
        int depth = 0;
        TreeNode node = this;
        do {
            node = node.getParent();
            ++depth;
        } while (node != null);
        Object[] nodes = new TreeNode[depth];
        node = this;
        for (int i = nodes.length - 1; i >= 0; --i) {
            nodes[i] = node;
            node = node.getParent();
        }
        return new TreePath(nodes);
    }

    private SVGNavigatorNode getChildTreeNode(DocumentElement de) {
        int index = this.getChildTreeNodeIndex(de);
        if (index != -1) {
            return this.m_children.get(index);
        }
        return null;
    }

    private int getChildTreeNodeIndex(DocumentElement de) {
        this.checkChildrenAdapters();
        int childNum = this.m_children.size();
        for (int i = 0; i < childNum; ++i) {
            SVGNavigatorNode node = this.m_children.get(i);
            if (!node.getDocumentElement().equals((Object)de)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsError() {
        this.checkChildrenAdapters();
        return this.m_containsError;
    }

    public int getChildrenErrorCount() {
        this.checkChildrenAdapters();
        return this.m_childrenErrorCount;
    }

    public String toString() {
        return this.getText(false);
    }

    public String getText(boolean html) {
        if (SVGNavigatorTree.isTreeElement(this.m_de)) {
            String attribsVisibleText = "";
            AttributeSet attribs = this.getDocumentElement().getAttributes();
            if (attribs.getAttributeCount() > 0) {
                String attribsText = this.getAttribsText();
                if (SVGNavigatorTree.showAttributes) {
                    attribsVisibleText = attribsText.length() > 100 ? attribsText.substring(0, 100) + "..." : attribsText.toString();
                }
            }
            StringBuffer text = new StringBuffer();
            text.append(html ? "<html>" : "");
            if (html) {
                if (this.m_containsError) {
                    text.append("<font color=FF0000><b>");
                } else if (this.m_nodeVisibility == SVGNavigatorTree.VISIBILITY_UNDIRECT) {
                    text.append("<font color=888888>");
                }
            }
            text.append(this.getDocumentElement().getName());
            if (html) {
                if (this.m_containsError) {
                    text.append("</b></font>");
                } else if (this.m_nodeVisibility == SVGNavigatorTree.VISIBILITY_UNDIRECT) {
                    text.append("</font>");
                }
            }
            text.append(html ? "<font color=888888>" : "");
            if (attribsVisibleText.trim().length() > 0) {
                text.append(" ");
                text.append(attribsVisibleText);
            }
            text.append(html ? "</font>" : "");
            text.append(html ? "</html>" : "");
            return text.toString();
        }
        return this.m_de.getName() + " [unknown content]";
    }

    public String getToolTipText() {
        return this.getAttribsText();
    }

    public void childrenReordered(DocumentElementEvent ce) {
        this.m_nodeTree.getTreeModel().nodeStructureChanged(this);
    }

    public String getAttribsText() {
        StringBuffer attribsText = new StringBuffer();
        Enumeration<?> attrNames = this.getDocumentElement().getAttributes().getAttributeNames();
        if (attrNames.hasMoreElements()) {
            while (attrNames.hasMoreElements()) {
                String aname = (String)attrNames.nextElement();
                String value = (String)this.getDocumentElement().getAttributes().getAttribute(aname);
                attribsText.append(aname);
                attribsText.append("=\"");
                attribsText.append(value);
                attribsText.append("\"");
                if (!attrNames.hasMoreElements()) continue;
                attribsText.append(", ");
            }
        }
        return attribsText.toString();
    }

    public void elementAdded(DocumentElementEvent e) {
        final DocumentElement ade = e.getChangedChild();
        if (debug) {
            System.out.println(">>> +EVENT called on " + this.hashCode() + " - " + this.m_de + ": element " + ade + " is going to be added");
        }
        if (SVGNavigatorTree.isTreeElement(ade)) {
            byte visibility = this.m_nodeTree.checkVisibility(ade, true);
            int index = this.getChildTreeNodeIndex(ade);
            if (index == -1) {
                if (visibility != SVGNavigatorTree.VISIBILITY_NO) {
                    String id;
                    SVGNavigatorNode tn = new SVGNavigatorNode(ade, this.m_nodeTree, this, visibility);
                    int insertIndex = this.getVisibleChildIndex(ade);
                    if (this.m_children.size() < insertIndex) {
                        this.m_nodeTree.getTreeModel().nodeStructureChanged(this);
                    } else {
                        this.m_children.add(insertIndex, tn);
                        int tnIndex = this.getIndex(tn);
                        this.m_nodeTree.getTreeModel().nodesWereInserted(this, new int[]{tnIndex});
                    }
                    if (debug) {
                        System.out.println("<<<EVENT finished (node " + tn + " added)");
                    }
                    if ((id = this.m_nodeTree.getSelectedId()) != null && this.m_nodeTree.isSelectionEmpty() && id.equals(SVGFileModel.getIdAttribute(ade))) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SVGNavigatorNode.this.m_nodeTree.selectNode(id, ade);
                            }
                        });
                    }
                }
            } else if (visibility == SVGNavigatorTree.VISIBILITY_NO) {
                SVGNavigatorNode removedNode = this.m_children.remove(index);
                this.m_nodeTree.getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{removedNode});
            }
        } else if (SVGFileModel.isError(ade)) {
            this.markNodeAsError(this);
        }
        if (this.m_de.equals((Object)this.m_de.getDocumentModel().getRootElement())) {
            this.m_nodeTree.expandPath(new TreePath(this));
        }
    }

    private void debugError(DocumentElementEvent e) {
        StringBuffer sb = new StringBuffer();
        sb.append("An inconsistency between XML navigator and XML DocumentModel occured when adding a new element in the XML DocumentModel! Please report the problem and add following debug messages to the issue along with the XML document you are editing.");
        sb.append("Debug for Node " + this + ":\n");
        sb.append("Children of current node:\n");
        Iterator<SVGNavigatorNode> itr = this.m_children.iterator();
        while (itr.hasNext()) {
            SVGNavigatorNode tna = itr.next();
            sb.append(tna.toString());
            sb.append("\n");
        }
        sb.append("\nChildren of DocumentElement (" + this.getDocumentElement() + ") wrapped by the current node:\n");
        Iterator currChildrenItr = this.getDocumentElement().getChildren().iterator();
        while (itr.hasNext()) {
            DocumentElement de = (DocumentElement)itr.next();
            sb.append(de.toString());
            sb.append("\n");
        }
        sb.append("------------");
        ErrorManager.getDefault().log(1, sb.toString());
    }

    private void markNodeAsError(SVGNavigatorNode tna) {
        tna.m_containsError = true;
        SVGNavigatorNode parent = tna;
        this.m_nodeTree.getTreeModel().nodeChanged(tna);
        while ((parent = (SVGNavigatorNode)parent.getParent()) != null) {
            if (parent.getParent() != null) {
                ++parent.m_childrenErrorCount;
            }
            this.m_nodeTree.getTreeModel().nodeChanged(parent);
        }
    }

    private int getVisibleChildIndex(DocumentElement de) {
        int index = 0;
        for (DocumentElement child : this.getDocumentElement().getChildren()) {
            if (child.equals((Object)de)) {
                return index;
            }
            if (!SVGNavigatorTree.isTreeElement(child)) continue;
            ++index;
        }
        return -1;
    }

    public void elementRemoved(DocumentElementEvent e) {
        DocumentElement rde = e.getChangedChild();
        if (debug) {
            System.out.println(">>> -EVENT on " + this.hashCode() + " - " + this.m_de + ": element " + rde + " is going to be removed ");
        }
        if (SVGNavigatorTree.isTreeElement(rde)) {
            if (debug) {
                System.out.println(">>> removing tag element");
            }
            SVGNavigatorNode tn = this.getChildTreeNode(rde);
            int tnIndex = this.getIndex(tn);
            if (tn != null) {
                this.m_children.remove(tn);
                this.m_nodeTree.getTreeModel().nodesWereRemoved(this, new int[]{tnIndex}, new Object[]{tn});
            } else if (debug) {
                System.out.println("Warning: TreeNode for removed element doesn't exist!!!");
            }
        } else if (SVGFileModel.isError(rde)) {
            this.unmarkNodeAsError(this);
        }
        if (debug) {
            System.out.println("<<<EVENT finished (node removed)");
        }
    }

    private void unmarkNodeAsError(SVGNavigatorNode tna) {
        tna.m_containsError = false;
        SVGNavigatorNode parent = tna;
        this.m_nodeTree.getTreeModel().nodeChanged(tna);
        while ((parent = (SVGNavigatorNode)parent.getParent()) != null) {
            if (parent.getParent() != null) {
                --parent.m_childrenErrorCount;
            }
            this.m_nodeTree.getTreeModel().nodeChanged(parent);
        }
    }

    public void attributesChanged(DocumentElementEvent e) {
        if (debug) {
            System.out.println("Attributes of treenode " + this + " has changed.");
        }
        this.m_nodeTree.getTreeModel().nodeChanged(this);
    }

    public void contentChanged(DocumentElementEvent e) {
        if (debug) {
            System.out.println("treenode " + this + " changed.");
        }
        this.m_nodeTree.getTreeModel().nodeChanged(this);
    }

    public synchronized void refresh() {
        if (this.m_children != null) {
            int j;
            List childElems = this.m_de.getChildren();
            int elemNum = childElems.size();
            int childNum = this.m_children.size();
            boolean[] processed = new boolean[elemNum];
            SVGNavigatorNode[] removedChildren = new SVGNavigatorNode[childNum];
            int removedNum = 0;
            int processedElemNum = 0;
            for (int j2 = 0; j2 < elemNum; ++j2) {
                if (SVGNavigatorTree.isTreeElement((DocumentElement)childElems.get(j2))) continue;
                ++processedElemNum;
                processed[j2] = true;
            }
            block1: for (int i = childNum - 1; i >= 0; --i) {
                SVGNavigatorNode childNode = this.m_children.get(i);
                for (j = 0; j < elemNum; ++j) {
                    DocumentElement childElem;
                    if (processed[j] || !childNode.m_de.equals((Object)(childElem = (DocumentElement)childElems.get(j)))) continue;
                    byte visibility = this.m_nodeTree.checkVisibility(childElem, true);
                    if (visibility == SVGNavigatorTree.VISIBILITY_NO) {
                        this.m_children.remove(i);
                        removedChildren[i] = childNode;
                        ++removedNum;
                    } else {
                        if (childNode.m_nodeVisibility != visibility) {
                            childNode.m_nodeVisibility = visibility;
                        }
                        childNode.refresh();
                    }
                    ++processedElemNum;
                    processed[j] = true;
                    continue block1;
                }
            }
            if (removedNum > 0) {
                int[] childIndices = new int[removedNum];
                Object[] childrenArr = new Object[removedNum];
                int k = 0;
                for (j = 0; j < childNum; ++j) {
                    if (removedChildren[j] == null) continue;
                    childrenArr[k] = removedChildren[j];
                    childIndices[k++] = j;
                }
                this.m_nodeTree.getTreeModel().nodesWereRemoved(this, childIndices, childrenArr);
                childNum -= removedNum;
            }
            assert (childNum == this.m_children.size());
            if (processedElemNum < elemNum) {
                int childIndex = 0;
                int elemIndex = 0;
                int[] childIndices = new int[elemNum - processedElemNum];
                int addedNum = 0;
                block4: while (childIndex < childNum || elemIndex < elemNum) {
                    DocumentElement childNodeElem = childIndex < childNum ? this.m_children.get((int)childIndex).m_de : null;
                    while (elemIndex < elemNum) {
                        byte visibility;
                        DocumentElement childElem = this.m_de.getElement(elemIndex);
                        if (childElem.equals((Object)childNodeElem)) {
                            ++childIndex;
                            ++elemIndex;
                            continue block4;
                        }
                        if (!processed[elemIndex] && (visibility = this.m_nodeTree.checkVisibility(childElem, true)) != SVGNavigatorTree.VISIBILITY_NO) {
                            SVGNavigatorNode newChild = new SVGNavigatorNode(childElem, this.m_nodeTree, this, visibility);
                            this.m_children.add(childIndex, newChild);
                            childIndices[addedNum++] = childIndex++;
                            ++childNum;
                        }
                        ++elemIndex;
                    }
                }
                if (addedNum > 0) {
                    if (addedNum < childIndices.length) {
                        int[] t = childIndices;
                        childIndices = new int[addedNum];
                        System.arraycopy(t, 0, childIndices, 0, addedNum);
                    }
                    this.m_nodeTree.getTreeModel().nodesWereInserted(this, childIndices);
                }
            }
        }
    }

    private synchronized void checkChildrenAdapters() {
        if (this.m_children == null) {
            this.m_de.addDocumentElementListener((DocumentElementListener)this);
            this.m_children = new ArrayList<SVGNavigatorNode>();
            for (DocumentElement chde : this.m_de.getChildren()) {
                if (SVGNavigatorTree.isTreeElement(chde)) {
                    byte visibility = this.m_nodeTree.checkVisibility(chde, true);
                    int index = this.getChildTreeNodeIndex(chde);
                    if (index == -1) {
                        if (visibility == SVGNavigatorTree.VISIBILITY_NO) continue;
                        SVGNavigatorNode tna = new SVGNavigatorNode(chde, this.m_nodeTree, this, visibility);
                        this.m_children.add(tna);
                        continue;
                    }
                    if (visibility != SVGNavigatorTree.VISIBILITY_NO) continue;
                    this.m_children.remove(index);
                    continue;
                }
                if (!SVGFileModel.isError(chde)) continue;
                this.markNodeAsError(this);
            }
        }
    }
}

