/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.TimedGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TimedTakeSnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class TimedTakeSnapshotProfilingPoint
extends TimedGlobalProfilingPoint
implements PropertyChangeListener {
    private static final String NO_DATA_AVAILABLE_MSG = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_NoDataAvailableMsg");
    private static final String NO_DATA_REMOTE_MSG = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_NoDataRemoteMsg");
    private static final String NO_DATA_JDK_MSG = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_NoDataJdkMsg");
    private static final String ONE_HIT_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_NoResultsString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderProjectString");
    private static final String HEADER_MODE_DATA_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderModeDataString");
    private static final String HEADER_MODE_DUMP_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderModeDumpString");
    private static final String HEADER_TARGET_PROJECT_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderTargetProjectString");
    private static final String HEADER_TARGET_CUSTOM_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderTargetCustomString");
    private static final String HEADER_RESET_RESULTS_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderResetResultsString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HeaderHitsString");
    private static final String OPEN_SNAPSHOT_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_OpenSnapshotString");
    private static final String HIT_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_HitString");
    private static final String SNAPSHOT_NOT_AVAILABLE_MSG = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_SnapshotNotAvailableMsg");
    private static final String DATA_STRING = NbBundle.getMessage(TimedTakeSnapshotProfilingPoint.class, (String)"TimedTakeSnapshotProfilingPoint_DataString");
    public static final String TAKEN_HEAPDUMP_PREFIX = "heapdump-";
    static final String PROPERTY_TYPE = "p_snapshot";
    public static final String TYPE_PROFDATA_KEY = "profdata";
    public static final String TYPE_HEAPDUMP_KEY = "heapdump";
    static final String PROPERTY_TARGET = "p_target";
    public static final String TARGET_PROJECT_KEY = "project";
    public static final String TARGET_CUSTOM_KEY = "custom";
    static final String PROPERTY_CUSTOM_FILE = "p_file";
    static final String PROPERTY_RESET_RESULTS = "p_reset_results";
    private static final String SNAPSHOT_LOCATION_URLMASK = "file:";
    private static final String NO_DATA_AVAILABLE_MESSAGE = NO_DATA_AVAILABLE_MSG;
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String snapshotFile = System.getProperty("java.io.tmpdir");
    private String snapshotTarget = "project";
    private String snapshotType = "profdata";
    private WeakReference<Report> reportReference;
    private boolean resetResults = false;

    public TimedTakeSnapshotProfilingPoint(String name, Project project, ProfilingPointFactory factory) {
        this(name, project, factory, false);
    }

    public TimedTakeSnapshotProfilingPoint(String name, Project project, ProfilingPointFactory factory, boolean existing) {
        super(name, project, factory, existing);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public void setResetResults(boolean resetResults) {
        if (this.resetResults == resetResults) {
            return;
        }
        this.resetResults = resetResults;
        this.getChangeSupport().firePropertyChange(PROPERTY_RESET_RESULTS, !this.resetResults, this.resetResults);
    }

    public boolean getResetResults() {
        return this.resetResults;
    }

    public void setSnapshotFile(String snapshotFile) {
        if (snapshotFile == null || !new File(snapshotFile).exists()) {
            return;
        }
        if (this.snapshotFile != null && new File(this.snapshotFile).equals(new File(snapshotFile))) {
            return;
        }
        String oldSnapshotFile = this.snapshotFile;
        this.snapshotFile = snapshotFile;
        this.getChangeSupport().firePropertyChange(PROPERTY_CUSTOM_FILE, oldSnapshotFile, snapshotFile);
    }

    public String getSnapshotFile() {
        return this.snapshotFile;
    }

    public void setSnapshotTarget(String snapshotTarget) {
        if (!snapshotTarget.equals(TARGET_PROJECT_KEY) && !snapshotTarget.equals(TARGET_CUSTOM_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot target category: " + snapshotTarget);
        }
        if (this.snapshotTarget.equals(snapshotTarget)) {
            return;
        }
        String oldSnapshotTarget = this.snapshotTarget;
        this.snapshotTarget = snapshotTarget;
        this.getChangeSupport().firePropertyChange(PROPERTY_TARGET, oldSnapshotTarget, snapshotTarget);
    }

    public String getSnapshotTarget() {
        return this.snapshotTarget;
    }

    public void setSnapshotType(String snapshotType) {
        if (snapshotType == null || !snapshotType.equals(TYPE_PROFDATA_KEY) && !snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot type: " + snapshotType);
        }
        if (this.snapshotType.equals(snapshotType)) {
            return;
        }
        String oldSnapshotType = this.snapshotType;
        this.snapshotType = snapshotType;
        this.getChangeSupport().firePropertyChange(PROPERTY_TYPE, oldSnapshotType, snapshotType);
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TimedTakeSnapshotProfilingPoint.this.hasReport()) {
                    TimedTakeSnapshotProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.hasReport()) {
            if (evt.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport();
        topComponent.open();
        topComponent.requestActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                int size = this.results.size();
                String string = size == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatLocalProfilingPointTime(this.results.get(size - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, size, Utils.formatLocalProfilingPointTime(this.results.get(size - 1).getTimestamp()));
                return string;
            }
            return NO_RESULTS_STRING;
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        TimedTakeSnapshotCustomizer customizer = (TimedTakeSnapshotCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPType(TYPE_PROFDATA_KEY.equals(this.getSnapshotType()));
        customizer.setPPTarget(TARGET_PROJECT_KEY.equals(this.getSnapshotTarget()));
        customizer.setPPFile(this.getSnapshotFile());
        customizer.setPPResetResults(this.getResetResults());
        customizer.setTimeCondition(this.getCondition());
    }

    FileObject getSnapshotDirectory() throws IOException {
        if (this.snapshotTarget.equals(TARGET_PROJECT_KEY)) {
            return IDEUtils.getProjectSettingsFolder(this.getProject(), true);
        }
        File f = new File(this.snapshotFile);
        f.mkdirs();
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        TimedTakeSnapshotCustomizer customizer = (TimedTakeSnapshotCustomizer)c;
        this.setName(customizer.getPPName());
        this.setSnapshotType(customizer.getPPType() ? TYPE_PROFDATA_KEY : TYPE_HEAPDUMP_KEY);
        this.setSnapshotTarget(customizer.getPPTarget() ? TARGET_PROJECT_KEY : TARGET_CUSTOM_KEY);
        this.setSnapshotFile(customizer.getPPFile());
        this.setResetResults(customizer.getPPResetResults());
        this.setCondition(customizer.getTimeCondition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(long hitValue) {
        String snapshotFilename;
        long currentTime = System.currentTimeMillis();
        if (this.snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            snapshotFilename = this.takeHeapdumpHit();
        } else {
            snapshotFilename = this.takeSnapshotHit();
            if (this.getResetResults()) {
                try {
                    ResultsManager.getDefault().reset();
                    TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
                    if (runner.targetJVMIsAlive()) {
                        runner.resetTimers();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
            }
        }
        Object object = this.resultsSync;
        synchronized (object) {
            this.results.add(new Result(currentTime, snapshotFilename));
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.hasResults();
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private String getCurrentHeapDumpFilename() {
        try {
            String fileName = TAKEN_HEAPDUMP_PREFIX + System.currentTimeMillis();
            FileObject folder = this.getSnapshotDirectory();
            return FileUtil.toFile((FileObject)folder).getAbsolutePath() + File.separator + FileUtil.findFreeFileName((FileObject)folder, (String)fileName, (String)"hprof") + "." + "hprof";
        }
        catch (IOException e) {
            return null;
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private String takeHeapdumpHit() {
        TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
        if (runner.getProfilingSessionStatus().remoteProfiling) {
            return NO_DATA_REMOTE_MSG;
        }
        if (!runner.hasSupportedJDKForHeapDump()) {
            return NO_DATA_JDK_MSG;
        }
        String dumpFileName = this.getCurrentHeapDumpFilename();
        if (dumpFileName == null) {
            return NO_DATA_AVAILABLE_MESSAGE;
        }
        boolean heapdumpTaken = false;
        try {
            heapdumpTaken = runner.getProfilerClient().takeHeapDump(dumpFileName);
        }
        catch (Exception ex) {
            ProfilerLogger.log((Exception)ex);
        }
        if (heapdumpTaken) {
            ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            try {
                return new File(dumpFileName).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                ProfilerLogger.log((Exception)ex);
                return NO_DATA_AVAILABLE_MESSAGE;
            }
        }
        return NO_DATA_AVAILABLE_MESSAGE;
    }

    private static LoadedSnapshot takeSnapshot() {
        return ResultsManager.getDefault().prepareSnapshot();
    }

    private String takeSnapshotHit() {
        LoadedSnapshot loadedSnapshot = null;
        String snapshotFilename = null;
        loadedSnapshot = TimedTakeSnapshotProfilingPoint.takeSnapshot();
        if (loadedSnapshot != null) {
            try {
                FileObject snapshotDirectory = this.getSnapshotDirectory();
                FileObject profFile = snapshotDirectory.createData(ResultsManager.getDefault().getDefaultSnapshotFileName(loadedSnapshot), "nps");
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot, profFile);
                snapshotFilename = FileUtil.toFile((FileObject)profFile).toURI().toURL().toExternalForm();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(65536, (Throwable)e);
            }
        }
        return snapshotFilename == null ? NO_DATA_AVAILABLE_MESSAGE : snapshotFilename;
    }

    private static class Result {
        private final String resultString;
        private final long timestamp;

        public Result(long timestamp, String resultString) {
            this.timestamp = timestamp;
            this.resultString = resultString;
        }

        public String getResultString() {
            return this.resultString;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Report
    extends TopComponent {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshData() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderMode());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderTarget());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderResetResults());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = TimedTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (!TimedTakeSnapshotProfilingPoint.this.hasResults()) {
                    dataAreaTextBuilder.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
                } else {
                    for (int i = 0; i < TimedTakeSnapshotProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(TimedTakeSnapshotProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)TimedTakeSnapshotProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = TimedTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)TimedTakeSnapshotProfilingPoint.this.results.get(index);
                String resultString = result.getResultString();
                String snapshotInformation = resultString.startsWith(TimedTakeSnapshotProfilingPoint.SNAPSHOT_LOCATION_URLMASK) ? "<a href='" + resultString + "'>" + OPEN_SNAPSHOT_STRING + "</a>" : resultString;
                return MessageFormat.format(HIT_STRING, index + 1, Utils.formatLocalProfilingPointTime(result.getTimestamp()), snapshotInformation);
            }
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, TimedTakeSnapshotProfilingPoint.this.isEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = TimedTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                return MessageFormat.format(HEADER_HITS_STRING, TimedTakeSnapshotProfilingPoint.this.results.size());
            }
        }

        private String getHeaderMode() {
            return TimedTakeSnapshotProfilingPoint.this.getSnapshotType().equals(TimedTakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) ? HEADER_MODE_DATA_STRING : HEADER_MODE_DUMP_STRING;
        }

        private String getHeaderName() {
            return "<h2><b>" + TimedTakeSnapshotProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtils.getInformation((Project)TimedTakeSnapshotProfilingPoint.this.getProject()).getDisplayName());
        }

        private String getHeaderResetResults() {
            return MessageFormat.format(HEADER_RESET_RESULTS_STRING, TimedTakeSnapshotProfilingPoint.this.getResetResults());
        }

        private String getHeaderTarget() {
            return TimedTakeSnapshotProfilingPoint.this.getSnapshotTarget().equals(TimedTakeSnapshotProfilingPoint.TARGET_PROJECT_KEY) ? HEADER_TARGET_PROJECT_STRING : MessageFormat.format(HEADER_TARGET_PROJECT_STRING, TimedTakeSnapshotProfilingPoint.this.getSnapshotFile());
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, TimedTakeSnapshotProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea();
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    File resolvedFile = null;
                    try {
                        resolvedFile = new File(url.toURI());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    final File snapshotFile = resolvedFile;
                    if (snapshotFile != null && snapshotFile.exists()) {
                        if (TimedTakeSnapshotProfilingPoint.this.getSnapshotType().equals(TimedTakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY)) {
                            File sf = FileUtil.normalizeFile((File)snapshotFile);
                            LoadedSnapshot snapshot = ResultsManager.getDefault().loadSnapshot(FileUtil.toFileObject((File)sf));
                            ResultsManager.getDefault().openSnapshot(snapshot);
                        } else if (TimedTakeSnapshotProfilingPoint.this.getSnapshotType().equals(TimedTakeSnapshotProfilingPoint.TYPE_HEAPDUMP_KEY)) {
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    HeapWalkerManager.getDefault().openHeapWalker(snapshotFile);
                                }
                            });
                        }
                    } else {
                        NetBeansProfiler.getDefaultNB().displayWarning(SNAPSHOT_NOT_AVAILABLE_MSG);
                    }
                }
            };
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(DATA_STRING);
            tb.setTitleFont(tb.getTitleFont().deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }
}

