/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapFactory;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.heapwalk.ui.HeapWalkerUI;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class HeapWalker {
    private static final String HEAPWALKER_DEFAULT_NAME = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_HeapWalkerDefaultName");
    private static final String HEAPWALKER_CUSTOM_NAME = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_HeapWalkerCustomName");
    private static final String LOADING_DUMP_MSG = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_LoadingDumpMsg");
    private File heapDumpFile;
    private HeapFragmentWalker mainHeapWalker;
    private HeapWalkerUI heapWalkerUI;
    private Project heapDumpProject;
    private String heapWalkerName = HEAPWALKER_DEFAULT_NAME;

    public HeapWalker(Heap heap) {
        this.createMainFragment(heap);
    }

    public HeapWalker(File heapFile) throws FileNotFoundException, IOException {
        this(HeapWalker.createHeap(heapFile));
        String fileNamePart;
        this.heapDumpFile = heapFile;
        this.heapDumpProject = HeapWalker.computeHeapDumpProject(this.heapDumpFile);
        String fileName = this.heapDumpFile.getName();
        int extensionIndex = fileName.lastIndexOf(".");
        if (extensionIndex == -1) {
            fileNamePart = fileName;
        } else {
            fileNamePart = fileName.substring(0, extensionIndex);
            if (fileNamePart.startsWith("heapdump-")) {
                String time = fileNamePart.substring("heapdump-".length(), fileNamePart.length());
                try {
                    long timeStamp = Long.parseLong(time);
                    fileNamePart = StringUtils.formatUserDate((Date)new Date(timeStamp));
                }
                catch (NumberFormatException e) {
                    fileNamePart = fileName;
                }
            } else {
                fileNamePart = fileName;
            }
        }
        this.heapWalkerName = MessageFormat.format(HEAPWALKER_CUSTOM_NAME, fileNamePart);
    }

    public File getHeapDumpFile() {
        return this.heapDumpFile;
    }

    public Project getHeapDumpProject() {
        return this.heapDumpProject;
    }

    public HeapFragmentWalker getMainHeapWalker() {
        return this.mainHeapWalker;
    }

    public String getName() {
        return this.heapWalkerName;
    }

    public void open() {
        HeapWalkerManager.getDefault().openHeapWalker(this);
    }

    TopComponent getTopComponent() {
        if (this.heapWalkerUI == null) {
            this.heapWalkerUI = new HeapWalkerUI(this);
        }
        return this.heapWalkerUI;
    }

    void createMainFragment(Heap heap) {
        this.mainHeapWalker = new HeapFragmentWalker(heap, this, true);
    }

    void createReachableFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    void createRetainedFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private static Project computeHeapDumpProject(File heapDumpFile) {
        if (heapDumpFile == null) {
            return null;
        }
        File heapDumpDir = heapDumpFile.getParentFile();
        if (heapDumpDir == null) {
            return null;
        }
        FileObject heapDumpDirObj = FileUtil.toFileObject((File)heapDumpDir);
        if (heapDumpDirObj == null || !heapDumpDirObj.isValid()) {
            return null;
        }
        return IDEUtils.getProjectFromSettingsFolder(heapDumpDirObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Heap createHeap(File heapFile) throws FileNotFoundException, IOException {
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandleFactory.createHandle((String)LOADING_DUMP_MSG);
            pHandle.setInitialDelay(0);
            pHandle.start(2000);
            HeapWalker.setProgress(pHandle, 0);
            Heap heap = HeapFactory.createHeap((File)heapFile);
            HeapWalker.setProgress(pHandle, 1000);
            heap.getSummary();
            Heap heap2 = heap;
            return heap2;
        }
        finally {
            if (pHandle != null) {
                pHandle.finish();
            }
        }
    }

    private static void setProgress(final ProgressHandle pHandle, final int offset) {
        final BoundedRangeModel progress = HeapProgress.getProgress();
        progress.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pHandle.progress(progress.getValue() + offset);
            }
        });
    }
}

