/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.DrillDownWindow;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.TelemetryOverviewPanel;
import org.netbeans.modules.profiler.TelemetryWindow;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;

public final class ProfilerModule
extends ModuleInstall {
    private static final String QUESTION_DIALOG_CAPTION = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_QuestionDialogCaption");
    private static final String EXITING_FROM_PROFILE_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_ExitingFromProfileMessage");
    private static final String EXITING_FROM_ATTACH_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_ExitingFromAttachMessage");
    public static final String LIBS_DIR = "lib";

    public boolean closing() {
        if (!NetBeansProfiler.isInitialized()) {
            return true;
        }
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)EXITING_FROM_PROFILE_MESSAGE, QUESTION_DIALOG_CAPTION, 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                    return false;
                }
                Profiler.getDefault().stopApp();
            } else {
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)EXITING_FROM_ATTACH_MESSAGE, QUESTION_DIALOG_CAPTION, 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                    return false;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        if (!ResultsManager.getDefault().ideClosing()) {
            return false;
        }
        ProfilingPointsManager.getDefault().ideClosing();
        if (LiveResultsWindow.hasDefault()) {
            LiveResultsWindow.getDefault().ideClosing();
        }
        return true;
    }

    public void restored() {
        super.restored();
        MiscUtils.setVerbosePrint();
        MiscUtils.deleteHeapTempFiles();
    }

    public void uninstalled() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int state = Profiler.getDefault().getProfilingState();
                    int mode = Profiler.getDefault().getProfilingMode();
                    if (state == 8 || state == 4) {
                        if (mode == 1) {
                            Profiler.getDefault().stopApp();
                        } else {
                            Profiler.getDefault().detachFromApp();
                        }
                    }
                    ProfilerControlPanel2.closeIfOpened();
                    TelemetryOverviewPanel.closeIfOpened();
                    DrillDownWindow.closeIfOpened();
                    LiveResultsWindow.closeIfOpened();
                    TelemetryWindow.closeIfOpened();
                    ThreadsWindow.closeIfOpened();
                    SnapshotResultsWindow.closeAllWindows();
                    HeapWalkerManager.getDefault().closeAllHeapWalkers();
                    ProfilingPointsWindow.closeIfOpened();
                    ((NetBeansProfiler)Profiler.getDefault()).shutdown();
                    new ResetResultsAction().actionPerformed(null);
                }
            });
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
        }
        super.uninstalled();
    }
}

