/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.url;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.url.URLDataLoader;
import org.netbeans.modules.url.URLPresenter;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class URLDataObject
extends MultiDataObject
implements OpenCookie,
InstanceCookie {
    static final String PROP_URL = "url";
    static final long serialVersionUID = 6829522922370124627L;
    private Lookup lookup;

    public URLDataObject(FileObject file, MultiFileLoader loader) throws DataObjectExistsException {
        super(file, loader);
        this.getCookieSet().add((Node.Cookie)this);
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            FileEncodingQueryImplementation encodingImpl = ((URLDataLoader)this.getLoader()).getEncoding();
            this.lookup = encodingImpl != null ? Lookups.fixed((Object[])new Object[]{this, encodingImpl}) : Lookups.singleton((Object)((Object)this));
        }
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getURLString() {
        FileObject urlFile = this.getPrimaryFile();
        if (!urlFile.isValid()) {
            return null;
        }
        String urlString = null;
        InputStream is = null;
        try {
            is = urlFile.getInputStream();
            urlString = new BufferedReader(new InputStreamReader(is)).readLine();
        }
        catch (FileNotFoundException fne) {
            ErrorManager.getDefault().notify(16, (Throwable)fne);
            String string = null;
            return string;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
            String string = null;
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }
        if (urlString == null) {
            urlString = "";
        }
        return urlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setURLString(String newUrlString) {
        FileObject urlFile = this.getPrimaryFile();
        if (!urlFile.isValid()) {
            return;
        }
        FileLock lock = null;
        try {
            lock = urlFile.lock();
            OutputStream os = urlFile.getOutputStream(lock);
            os.write(newUrlString.getBytes());
            os.close();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(URLDataObject.class);
    }

    public void open() {
        String urlString = this.getURLString();
        if (urlString == null) {
            return;
        }
        URL url = URLDataObject.getURLFromString(urlString);
        if (url == null) {
            return;
        }
        HtmlBrowser.URLDisplayer.getDefault().showURL(url);
    }

    private static URL getURLFromString(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException mue1) {
            try {
                return new URL("http://" + urlString);
            }
            catch (MalformedURLException mue12) {
                String msg = urlString.length() > 50 ? NbBundle.getMessage(URLDataObject.class, (String)"MSG_MalformedURLError") : NbBundle.getMessage(URLDataObject.class, (String)"MSG_FMT_MalformedURLError", (Object)urlString);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                return null;
            }
        }
    }

    public String instanceName() {
        return this.getName();
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return URLPresenter.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        return new URLPresenter(this);
    }
}

