/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;

final class NodeSelector {
    private final TreePath[] nodes;
    private final Map<TreePathWrapper, Boolean> map;
    private boolean detailNodeAdded = false;
    private TreePath lsfn = null;
    private TreePath ldn = null;
    private TreePath ldfn = null;
    private final Logger log = Logger.getLogger(this.getClass().getName());

    static List<TreePath> selectMainNodes(TreePath[] selectedNodes, boolean canHaveDetails) {
        Logger log = Logger.getLogger(NodeSelector.class.getName());
        if (log.isLoggable(Level.FINER)) {
            log.finer("selectMainNodes(canHaveDetails = " + canHaveDetails + ')');
        }
        if (!canHaveDetails) {
            return NodeSelector.simpleSelect(selectedNodes);
        }
        return new NodeSelector(selectedNodes).selectMainNodes();
    }

    private static List<TreePath> simpleSelect(TreePath[] selectedNodes) {
        int i;
        TreePath rootNode = NodeSelector.findRootNode(selectedNodes[0]);
        int rootNodeIndex = -1;
        for (int i2 = 0; i2 < selectedNodes.length; ++i2) {
            if (selectedNodes[i2] != rootNode) continue;
            rootNodeIndex = i2;
            break;
        }
        if (rootNodeIndex == -1) {
            return Arrays.asList(selectedNodes);
        }
        if (rootNodeIndex == 0) {
            return Arrays.asList(selectedNodes).subList(1, selectedNodes.length);
        }
        if (rootNodeIndex == selectedNodes.length - 1) {
            return Arrays.asList(selectedNodes).subList(0, selectedNodes.length - 1);
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>(selectedNodes.length - 1);
        for (i = 0; i < rootNodeIndex; ++i) {
            result.add(selectedNodes[i]);
        }
        for (i = rootNodeIndex + 1; i < selectedNodes.length; ++i) {
            result.add(selectedNodes[i]);
        }
        assert (result.size() == selectedNodes.length - 1);
        return result;
    }

    private NodeSelector(TreePath[] nodes) {
        this.nodes = nodes;
        this.map = new LinkedHashMap<TreePathWrapper, Boolean>((int)((double)nodes.length * 1.35 + 0.5), 0.75f);
    }

    private List<TreePath> selectMainNodes() {
        TreePath parent;
        boolean finest = this.log.isLoggable(Level.FINEST);
        TreePath rootNode = NodeSelector.findRootNode(this.nodes[0]);
        if (finest) {
            this.log.finest("Selected nodes:");
            for (TreePath current : this.nodes) {
                if (current == rootNode) {
                    this.log.finest("* <root>");
                    continue;
                }
                parent = current.getParentPath();
                assert (parent != null);
                if (parent == rootNode) {
                    this.log.finest("* " + NodeSelector.getFileNodeName(current));
                    continue;
                }
                this.log.finest("* " + NodeSelector.getDetailNodeName(current, -1));
            }
            this.log.finest("");
        }
        for (TreePath current : this.nodes) {
            if (current == rootNode) {
                this.log.finest("*** <root> - filtered out");
                continue;
            }
            assert (this.ldfn == null == (this.ldn == null));
            assert (this.ldfn == null || this.ldfn == this.ldn.getParentPath());
            assert (current != this.ldfn || current != this.lsfn);
            parent = current.getParentPath();
            assert (parent != null);
            if (finest) {
                this.log.finest("*** " + (parent == rootNode ? NodeSelector.getFileNodeName(current) : NodeSelector.getDetailNodeName(current, -1)));
            }
            if (parent == rootNode) {
                if (current == this.lsfn) {
                    if (!finest) continue;
                    this.log.finest(NodeSelector.getFileNodeName(current) + " has been already selected");
                    continue;
                }
                if (this.ldfn != null && current != this.ldfn) {
                    if (finest) {
                        this.log.finest("handlePendingDetailNode(...)");
                    }
                    this.handlePendingDetailNode();
                }
                if (finest) {
                    this.log.finest("map.put(" + NodeSelector.getFileNodeName(current) + ", TRUE)");
                    this.log.finest("LSFN = " + NodeSelector.getFileNodeName(current));
                    this.log.finest("LDFN = null");
                    this.log.finest("LDN = null");
                }
                this.map.put(new TreePathWrapper(current), Boolean.TRUE);
                this.lsfn = current;
                this.ldfn = null;
                this.ldn = null;
                continue;
            }
            if (parent == this.lsfn) {
                if (!finest) continue;
                this.log.finest(NodeSelector.getDetailNodeName(current) + " - its parent is already selected");
                continue;
            }
            if (parent == this.ldfn) {
                this.map.put(new TreePathWrapper(this.ldfn), Boolean.TRUE);
                if (finest) {
                    this.log.finest(NodeSelector.getDetailNodeName(current) + " - at least second selected node" + " under the same parent (" + NodeSelector.getFileNodeName(parent) + ") - will be added permanently");
                    this.log.finest("map.put(" + NodeSelector.getFileNodeName(this.ldfn) + " /LDFN/, TRUE)");
                    this.log.finest("LSFN = " + NodeSelector.getFileNodeName(parent) + " /parent/");
                    this.log.finest("LDFN = null");
                    this.log.finest("LDN = null");
                }
                this.lsfn = parent;
                this.ldfn = null;
                this.ldn = null;
                continue;
            }
            if (finest && this.map.containsKey(new TreePathWrapper(parent))) {
                this.log.finest(NodeSelector.getDetailNodeName(current) + " - added under a file node (" + NodeSelector.getFileNodeName(parent) + ") that is selected but is not" + " the most recently selected" + " file node");
            }
            if (this.ldfn != null) {
                if (finest) {
                    this.log.finest("handlePendingDetailNode(...)");
                }
                this.handlePendingDetailNode();
            }
            if (parent == this.lsfn) {
                this.ldfn = null;
                this.ldn = null;
            } else {
                this.ldfn = parent;
                this.ldn = current;
            }
            if (!finest) continue;
            this.log.finest("LDFN = " + NodeSelector.getFileNodeName(parent) + " /parent/");
            this.log.finest("LDN = " + NodeSelector.getDetailNodeName(current) + " /current/");
        }
        if (this.ldfn != null) {
            if (finest) {
                this.log.finest("*** END");
                this.log.finest("handlePendingDetailNode(...)");
            }
            this.handlePendingDetailNode();
            this.ldfn = null;
            this.ldn = null;
        }
        this.log.finest("***");
        this.log.finest("*** BUILDING RESULT LIST");
        ArrayList<TreePath> result = new ArrayList<TreePath>(this.map.size());
        if (!this.detailNodeAdded) {
            this.log.finest("No detail nodes - simple case");
            for (Map.Entry<TreePathWrapper, Boolean> entry : this.map.entrySet()) {
                result.add(entry.getKey().treePath);
                if (!finest) continue;
                this.log.finest("+ " + NodeSelector.getFileNodeName(entry.getKey().treePath));
            }
        } else {
            for (Map.Entry<TreePathWrapper, Boolean> entry : this.map.entrySet()) {
                if (entry.getValue() == Boolean.FALSE) {
                    assert (!entry.getKey().isDetail);
                    if (!finest) continue;
                    this.log.finest("- " + NodeSelector.getFileNodeName(entry.getKey().treePath) + " (FALSE)");
                    continue;
                }
                TreePathWrapper wrapper = entry.getKey();
                if (!wrapper.isDetail) {
                    assert (entry.getValue() == Boolean.TRUE);
                    result.add(wrapper.treePath);
                    if (!finest) continue;
                    this.log.finest("+ " + NodeSelector.getFileNodeName(wrapper.treePath));
                    continue;
                }
                if (this.map.get(new TreePathWrapper(wrapper.treePath.getParentPath())) != Boolean.TRUE) {
                    result.add(wrapper.treePath);
                    if (!finest) continue;
                    this.log.finest("+ " + NodeSelector.getDetailNodeName(wrapper.treePath, -1));
                    continue;
                }
                if (!finest) continue;
                this.log.finest("- " + NodeSelector.getDetailNodeName(wrapper.treePath, -1) + " - parent (" + NodeSelector.getFileNodeName(wrapper.treePath.getParentPath()) + ") selected");
            }
        }
        this.map.clear();
        assert (!result.isEmpty());
        return result;
    }

    private void handlePendingDetailNode() {
        assert (this.ldfn != null);
        assert (this.ldn != null);
        Boolean oldValue = this.map.put(new TreePathWrapper(this.ldfn), Boolean.TRUE);
        if (oldValue == null) {
            this.map.put(new TreePathWrapper(this.ldfn), Boolean.FALSE);
            this.map.put(new TreePathWrapper(this.ldn), Boolean.TRUE);
            this.detailNodeAdded = true;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("map.put(" + NodeSelector.getFileNodeName(this.ldfn) + " /LDFN/, FALSE)");
                this.log.finest("map.put(" + NodeSelector.getDetailNodeName(this.ldn) + " /LDN/, TRUE)");
            }
        } else if (oldValue == Boolean.FALSE) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(NodeSelector.getFileNodeName(this.ldfn) + " - membership status changed" + " (conditional -> permanent)");
            }
            this.lsfn = this.ldfn;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("LSFN = " + NodeSelector.getFileNodeName(this.ldfn) + " /LDFN/");
            }
        } else assert (oldValue == Boolean.TRUE);
    }

    private static String getFileNodeName(TreePath fileNode) {
        return ((MatchingObject)fileNode.getLastPathComponent()).getName();
    }

    private static String getDetailNodeName(TreePath detailNode) {
        return NodeSelector.getDetailNodeName(detailNode, 15);
    }

    private static String getDetailNodeName(TreePath detailNode, int length) {
        String name = ((TextDetail.DetailNode)((Object)detailNode.getLastPathComponent())).getName().trim();
        if (length != -1) {
            return name.substring(0, length);
        }
        int bracketIndex = name.indexOf(91);
        if (bracketIndex != -1) {
            name = name.substring(0, bracketIndex);
        }
        return name.trim();
    }

    private static TreePath findRootNode(TreePath node) {
        TreePath parent;
        while ((parent = node.getParentPath()) != null) {
            node = parent;
        }
        return node;
    }

    private static final class TreePathWrapper {
        private final TreePath treePath;
        private final Object lastPathComp;
        private final boolean isDetail;

        TreePathWrapper(TreePath node) {
            this.treePath = node;
            this.lastPathComp = node.getLastPathComponent();
            this.isDetail = this.lastPathComp.getClass() != MatchingObject.class;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != TreePathWrapper.class) {
                return false;
            }
            TreePathWrapper other = (TreePathWrapper)o;
            return other.isDetail == this.isDetail && other.lastPathComp.equals(this.lastPathComp);
        }

        public int hashCode() {
            int hash = this.lastPathComp.hashCode();
            if (this.isDetail) {
                hash += 5;
            }
            return hash;
        }
    }
}

