/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring.rename;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.jpa.refactoring.PersistenceXmlRefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.jpa.refactoring.rename.PersistenceXmlRename;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PersistenceXmlPackageRename
extends PersistenceXmlRefactoring {
    private final RenameRefactoring renameRefactoring;

    public PersistenceXmlPackageRename(RenameRefactoring renameRefactoring) {
        this.renameRefactoring = renameRefactoring;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.renameRefactoring;
    }

    @Override
    protected boolean shouldHandle() {
        return true;
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.isPackage()) {
            FileObject pkg = ((NonRecursiveFolder)this.renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder();
            String oldPackageName = JavaIdentifiers.getQualifiedName((FileObject)pkg);
            return this.doPrepare(refactoringElementsBag, pkg, oldPackageName, this.renameRefactoring.getNewName());
        }
        if (this.isFolder()) {
            FileObject folder = (FileObject)this.renameRefactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath classPath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
            if (classPath == null) {
                return null;
            }
            FileObject root = classPath.findOwnerRoot(folder);
            if (root == null) {
                return null;
            }
            String prefix = FileUtil.getRelativePath((FileObject)root, (FileObject)folder.getParent()).replace('/', '.');
            String oldName = this.buildName(prefix, folder.getName());
            String newName = this.buildName(prefix, this.renameRefactoring.getNewName());
            return this.doPrepare(refactoringElementsBag, folder, oldName, newName);
        }
        return null;
    }

    private boolean isPackage() {
        return this.renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null;
    }

    private boolean isFolder() {
        FileObject folder = (FileObject)this.renameRefactoring.getRefactoringSource().lookup(FileObject.class);
        return folder != null && folder.isFolder();
    }

    private Problem doPrepare(RefactoringElementsBag refactoringElementsBag, FileObject folder, String oldName, String newName) {
        Problem result = null;
        for (FileObject each : this.getPersistenceXmls(folder)) {
            try {
                PUDataObject pUDataObject = ProviderUtil.getPUDataObject((FileObject)each);
                for (String clazz : this.getClasses(folder, new ArrayList<String>())) {
                    List<PersistenceUnit> punits = this.getAffectedPersistenceUnits(pUDataObject, clazz);
                    String newClassName = clazz.replace(oldName, newName);
                    for (PersistenceUnit persistenceUnit : punits) {
                        refactoringElementsBag.add(this.getRefactoring(), (RefactoringElementImplementation)new PersistenceXmlPackageRenameRefactoringElement(persistenceUnit, clazz, newClassName, pUDataObject, each));
                    }
                }
            }
            catch (InvalidPersistenceXmlException ex) {
                Problem newProblem = new Problem(false, NbBundle.getMessage(PersistenceXmlRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)ex.getPath()));
                result = RefactoringUtil.addToEnd(newProblem, result);
            }
        }
        return result;
    }

    private String buildName(String prefix, String name) {
        if (prefix.length() == 0) {
            return name;
        }
        return prefix + "." + name;
    }

    private List<String> getClasses(FileObject folder, List<String> result) {
        for (FileObject each : folder.getChildren()) {
            if (each.isFolder()) {
                this.getClasses(each, result);
                continue;
            }
            result.add(JavaIdentifiers.getQualifiedName((FileObject)each));
        }
        return result;
    }

    @Override
    protected RefactoringElementImplementation getRefactoringElement(PersistenceUnit persistenceUnit, FileObject clazz, PUDataObject pUDataObject, FileObject persistenceXml) {
        return null;
    }

    private static class PersistenceXmlPackageRenameRefactoringElement
    extends PersistenceXmlRefactoring.PersistenceXmlRefactoringElement {
        private final String newName;

        public PersistenceXmlPackageRenameRefactoringElement(PersistenceUnit persistenceUnit, String oldName, String newName, PUDataObject puDataObject, FileObject parentFile) {
            super(persistenceUnit, oldName, puDataObject, parentFile);
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.clazz, this.newName};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlRename.class, (String)"TXT_PersistenceXmlRename"), args);
        }

        public void undoChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.clazz, (String)this.newName, (PUDataObject)this.puDataObject);
        }

        public void performChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.newName, (String)this.clazz, (PUDataObject)this.puDataObject);
        }
    }
}

