/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.jsf.dialogs.BrowseFolders;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TemplateClientPanelVisual
extends JPanel
implements HelpCtx.Provider {
    private WizardDescriptor wizardDescriptor;
    private final Set listeners = new HashSet(1);
    private static final String NAME_SPACE = "http://java.sun.com/jsf/facelets";
    private static final String TAG_NAME = "ui:insert";
    private static final String VALUE_NAME = "name";
    Collection<String> templateData = Collections.EMPTY_SET;
    private ButtonGroup bgRootTag;
    private JButton jbBrowse;
    private JLabel jlRootTag;
    private JLabel jlTemplate;
    private JRadioButton jrbComposition;
    private JRadioButton jrbHtml;
    private JTextField jtfTemplate;

    public TemplateClientPanelVisual(WizardDescriptor wizardDescriptor) {
        this.initComponents();
        this.wizardDescriptor = wizardDescriptor;
    }

    private void initComponents() {
        this.bgRootTag = new ButtonGroup();
        this.jrbHtml = new JRadioButton();
        this.jrbComposition = new JRadioButton();
        this.jlRootTag = new JLabel();
        this.jlTemplate = new JLabel();
        this.jtfTemplate = new JTextField();
        this.jbBrowse = new JButton();
        this.bgRootTag.add(this.jrbHtml);
        this.jrbHtml.setSelected(true);
        this.jrbHtml.setText("<html>&lt;html&gt;</html>");
        this.jrbHtml.setActionCommand("html");
        this.jrbHtml.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jrbHtml.setMargin(new Insets(0, 0, 0, 0));
        this.bgRootTag.add(this.jrbComposition);
        this.jrbComposition.setText("<ui:composition>");
        this.jrbComposition.setActionCommand("composition");
        this.jrbComposition.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jrbComposition.setMargin(new Insets(0, 0, 0, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.jlRootTag.setText(bundle.getString("LBL_RootTag"));
        this.jlTemplate.setText(bundle.getString("LBL_SelectTemplate"));
        this.jtfTemplate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TemplateClientPanelVisual.this.jtfTemplateKeyReleased(evt);
            }
        });
        this.jbBrowse.setText(bundle.getString("LBL_Browse"));
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateClientPanelVisual.this.jbBrowseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jlTemplate).add((GroupLayout.Group)layout.createSequentialGroup().add(138, 138, 138).add((Component)this.jtfTemplate, -1, 280, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.jbBrowse)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jlRootTag).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jrbComposition).add((Component)this.jrbHtml)).add(250, 250, 250)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jlTemplate).add((Component)this.jbBrowse).add((Component)this.jtfTemplate, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jlRootTag).add((Component)this.jrbHtml)).addPreferredGap(0).add((Component)this.jrbComposition).addContainerGap(33, Short.MAX_VALUE)));
    }

    private void jtfTemplateKeyReleased(KeyEvent evt) {
        this.templateData = Collections.EMPTY_SET;
        this.fireChangeEvent();
    }

    private void jbBrowseActionPerformed(ActionEvent evt) {
        Sources sources = (Sources)Templates.getProject((WizardDescriptor)this.wizardDescriptor).getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroups = sources.getSourceGroups("doc_root");
        FileObject fo = BrowseFolders.showDialog(sourceGroups);
        if (fo != null) {
            File file = FileUtil.toFile((FileObject)fo);
            this.jtfTemplate.setText(file.getAbsolutePath());
            this.templateData = Collections.EMPTY_SET;
        }
        this.fireChangeEvent();
    }

    protected boolean validateTemplate() {
        if (this.templateData != null && this.templateData.size() != 0) {
            return true;
        }
        String message = null;
        String name = this.jtfTemplate.getText();
        if (name == null || "".equals(name)) {
            message = "MSG_NoTemplateSelected";
        } else {
            File file = new File(name);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    FileObject fo = FileUtil.toFileObject((File)file);
                    Source source = Source.create((FileObject)fo);
                    boolean startOffset = false;
                    this.templateData = new ArrayList<String>();
                    try {
                        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                HtmlParserResult htmlResult;
                                Parser.Result result = resultIterator.getParserResult(0);
                                if (result.getSnapshot().getMimeType().equals("text/html") && (htmlResult = (HtmlParserResult)result).getNamespaces().containsKey(TemplateClientPanelVisual.NAME_SPACE)) {
                                    List foundNodes = TemplateClientPanelVisual.this.findValue(htmlResult.root(TemplateClientPanelVisual.NAME_SPACE).children(), TemplateClientPanelVisual.TAG_NAME, new ArrayList());
                                    for (AstNode node : foundNodes) {
                                        String value;
                                        AstNode.Attribute attr = node.getAttribute(TemplateClientPanelVisual.VALUE_NAME);
                                        if (attr == null || (value = attr.unquotedValue()) == null || "".equals(value)) continue;
                                        TemplateClientPanelVisual.this.templateData.add(value);
                                    }
                                }
                            }
                        });
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    if (this.templateData == null || this.templateData.size() == 0) {
                        message = "MSG_NoFaceletsTemplate";
                    }
                } else {
                    message = "MSG_TemplateHasToBeFile";
                }
            } else {
                message = "MSG_EneterExistingTemplate";
            }
        }
        if (message != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TemplateClientPanelVisual.class, (String)message));
        }
        return message == null;
    }

    private List<AstNode> findValue(List<AstNode> nodes, String tagName, List<AstNode> foundNodes) {
        if (nodes == null) {
            return foundNodes;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            AstNode node = nodes.get(i);
            if (tagName.equals(node.name())) {
                foundNodes.add(node);
                continue;
            }
            foundNodes = this.findValue(node.children(), tagName, foundNodes);
        }
        return foundNodes;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TemplateClientPanelVisual.class);
    }

    public InputStream getTemplateClient() {
        String path = "org/netbeans/modules/web/jsf/facelets/resources/templates/";
        path = path + this.bgRootTag.getSelection().getActionCommand() + "TemplateClient.template";
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        return is;
    }

    public Collection<String> getTemplateData() {
        return this.templateData;
    }

    public FileObject getTemplate() {
        FileObject template = null;
        String name = this.jtfTemplate.getText();
        if (name != null && !"".equals(name)) {
            File file = new File(name);
            template = FileUtil.toFileObject((File)file);
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }
}

