/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.api.components.JsfComponentDescriptor;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanelVisual;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;

public class JSFConfigurationPanel
extends WebModuleExtender {
    private final JSFFrameworkProvider framework;
    private final ExtenderController controller;
    private JSFConfigurationPanelVisual component;
    private static final String PREFERRED_LANGUAGE = "jsf.language";
    private Preferences preferences;
    private JsfComponentDescriptor jsfComponentDescriptor;
    private LibraryType libraryType;
    private Library jsfCoreLibrary;
    private ServerLibrary serverLibrary;
    private String newLibraryName;
    private File installedFolder;
    private boolean enableFacelets;
    private boolean debugFacelets;
    private boolean skipComments;
    private boolean createExamples;
    private String facesSuffix;
    private String facesMapping;
    private boolean validateXml;
    private boolean verifyObjects;
    private boolean customizer;
    private final Set listeners = new HashSet(1);

    public JSFConfigurationPanel(JSFFrameworkProvider framework, ExtenderController controller, boolean customizer) {
        this.framework = framework;
        this.controller = controller;
        this.customizer = customizer;
        this.enableFacelets = false;
        this.debugFacelets = true;
        this.skipComments = true;
        this.createExamples = true;
        this.facesSuffix = ".xhtml";
        this.validateXml = true;
        this.verifyObjects = false;
        this.facesMapping = "/faces/*";
        this.getComponent();
    }

    public JSFConfigurationPanel(JSFFrameworkProvider framework, ExtenderController controller, boolean customizer, Preferences preferences) {
        this.framework = framework;
        this.controller = controller;
        this.customizer = customizer;
        this.preferences = preferences;
        this.enableFacelets = preferences.get(PREFERRED_LANGUAGE, "JSP").equals(PreferredLanguage.Facelets.getName());
        this.debugFacelets = true;
        this.skipComments = true;
        this.createExamples = true;
        this.facesSuffix = ".xhtml";
        this.validateXml = true;
        this.verifyObjects = false;
        this.facesMapping = "/faces/*";
        this.getComponent();
    }

    public JSFConfigurationPanelVisual getComponent() {
        if (this.component == null) {
            this.component = new JSFConfigurationPanelVisual(this, this.customizer);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(JSFConfigurationPanel.class);
    }

    public String getFacesSuffix() {
        return this.facesSuffix;
    }

    public String getFacesMapping() {
        return this.facesMapping;
    }

    private void setFacesMapping(String facesMapping) {
        this.facesMapping = facesMapping;
    }

    public void update() {
        this.component.update();
    }

    public boolean isValid() {
        this.getComponent();
        if (this.component.valid()) {
            this.setFacesMapping(this.component.getURLPattern());
            return true;
        }
        return false;
    }

    public Set extend(WebModule webModule) {
        Project project = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase());
        this.preferences = ProjectUtils.getPreferences((Project)project, ProjectUtils.class, (boolean)true);
        String preferredLang = this.component.getPreferredLanguage();
        if (preferredLang.equals(PreferredLanguage.JSP.getName()) || preferredLang.equals(PreferredLanguage.Facelets.getName())) {
            this.preferences.put(PREFERRED_LANGUAGE, this.component.getPreferredLanguage());
        }
        return this.framework.extendImpl(webModule);
    }

    public ExtenderController getController() {
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent((Object)this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public String getServletName() {
        return this.component.getServletName();
    }

    public void setServletName(String name) {
        this.component.setServletName(name);
    }

    @Deprecated
    public String getURLPattern() {
        return this.component.getURLPattern();
    }

    public void setURLPattern(String pattern) {
        if (this.component != null) {
            this.component.setURLPattern(pattern);
        }
    }

    public boolean validateXML() {
        return this.validateXml;
    }

    public void setValidateXML(boolean ver) {
        this.validateXml = ver;
    }

    public boolean verifyObjects() {
        return this.verifyObjects;
    }

    public void setVerifyObjects(boolean val) {
        this.verifyObjects = val;
    }

    public boolean packageJars() {
        return this.component.packageJars();
    }

    public String getNewLibraryName() {
        return this.newLibraryName;
    }

    public void setNewLibraryName(String version) {
        this.newLibraryName = version;
        this.fireChangeEvent();
    }

    public File getInstallFolder() {
        return this.installedFolder;
    }

    public void setInstallFolder(File folder) {
        this.installedFolder = folder;
        this.fireChangeEvent();
    }

    public boolean isDebugFacelets() {
        return this.debugFacelets;
    }

    public void setDebugFacelets(boolean value) {
        this.debugFacelets = value;
    }

    public boolean isSkipComments() {
        return this.skipComments;
    }

    public void setSkipComments(boolean value) {
        this.skipComments = value;
    }

    public boolean isCreateExamples() {
        return this.createExamples;
    }

    public void setCreateExamples(boolean value) {
        this.createExamples = value;
    }

    public boolean isEnableFacelets() {
        return this.enableFacelets;
    }

    protected void setEnableFacelets(boolean enableFacelets) {
        if (this.enableFacelets != enableFacelets) {
            this.enableFacelets = enableFacelets;
            String oldValue = enableFacelets ? PreferredLanguage.JSP.getName() : PreferredLanguage.Facelets.getName();
            String newValue = enableFacelets ? PreferredLanguage.Facelets.getName() : PreferredLanguage.JSP.getName();
            this.updatePreferredLanguage(oldValue, newValue);
        }
    }

    private void updatePreferredLanguage(String oldLanguage, String newLanguage) {
        if (this.preferences != null && !oldLanguage.equals(newLanguage)) {
            this.preferences.put(PREFERRED_LANGUAGE, this.component.getPreferredLanguage());
        }
    }

    public LibraryType getLibraryType() {
        return this.libraryType;
    }

    public void setLibraryType(LibraryType value) {
        this.libraryType = value;
    }

    public Library getLibrary() {
        return this.jsfCoreLibrary;
    }

    protected void setLibrary(Library library) {
        this.jsfCoreLibrary = library;
        this.fireChangeEvent();
    }

    public ServerLibrary getServerLibrary() {
        return this.serverLibrary;
    }

    protected void setServerLibrary(ServerLibrary library) {
        this.serverLibrary = library;
        this.fireChangeEvent();
    }

    void setJsfComponentDescriptor(JsfComponentDescriptor jsfComponentDescriptor) {
        this.jsfComponentDescriptor = jsfComponentDescriptor;
    }

    public JsfComponentDescriptor getJsfComponentDescriptor() {
        return this.jsfComponentDescriptor;
    }

    protected static class PreferredLanguage {
        private String name;
        static final PreferredLanguage JSP = new PreferredLanguage("JSP");
        static final PreferredLanguage Facelets = new PreferredLanguage("Facelets");

        private PreferredLanguage(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum LibraryType {
        USED,
        NEW,
        SERVER;

    }
}

