/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.metamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class ModelUnit {
    private final ClassPath bootPath;
    private final ClassPath compilePath;
    private final ClassPath sourcePath;
    private final WebModule module;
    private final PropertyChangeSupport changeSupport;
    private List<FileObject> configFiles;
    private List<FileObject> configRoots = Collections.synchronizedList(new LinkedList());
    private static final String META_INF = "META-INF";
    private static final String FACES_CONFIG = "faces-config.xml";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String DEFAULT_FACES_CONFIG_PATH = "WEB-INF/faces-config.xml";
    public final String PROP_CONFIG_FILES = "configFiles";

    public static ModelUnit create(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath, WebModule webModule) {
        return new ModelUnit(bootPath, compilePath, sourcePath, webModule);
    }

    private ModelUnit(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath, WebModule webModule) {
        Parameters.notNull((CharSequence)"sourcePath", (Object)sourcePath);
        this.bootPath = bootPath;
        this.compilePath = compilePath;
        this.sourcePath = sourcePath;
        this.module = webModule;
        this.changeSupport = new PropertyChangeSupport(this);
        this.initListeners();
    }

    public ClassPath getBootPath() {
        return this.bootPath;
    }

    public ClassPath getCompilePath() {
        return this.compilePath;
    }

    public ClassPath getSourcePath() {
        return this.sourcePath;
    }

    public FileObject getApplicationFacesConfig() {
        List<FileObject> l = this.getConfigFilesImpl();
        if (l.size() == 0) {
            return null;
        }
        FileObject first = l.iterator().next();
        FileObject documentBase = this.module.getDocumentBase();
        if (documentBase == null) {
            return null;
        }
        FileObject mainConfigFile = documentBase.getFileObject(DEFAULT_FACES_CONFIG_PATH);
        if (mainConfigFile != null && mainConfigFile.equals(first)) {
            return first;
        }
        return null;
    }

    public List<FileObject> getApplicationConfigurationResources() {
        List<FileObject> l = this.getConfigFilesImpl();
        FileObject applicationFacesConfig = this.getApplicationFacesConfig();
        if (applicationFacesConfig != null) {
            return l.subList(1, l.size());
        }
        return l;
    }

    private void collectConfigurationFilesFromClassPath(ClassPath cp, List<FileObject> configs, List<FileObject> configRoots) {
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] roots;
            if (entry.isValid()) {
                roots = new FileObject[]{entry.getRoot()};
            } else {
                SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
                roots = res.getRoots();
            }
            for (FileObject root : roots) {
                FileObject[] children;
                configRoots.add(root);
                FileObject metaInf = root.getFileObject(META_INF);
                if (metaInf == null) continue;
                for (FileObject fileObject : children = metaInf.getChildren()) {
                    String name = fileObject.getNameExt();
                    if (!name.equals(FACES_CONFIG) && !name.endsWith(FACES_CONFIG_SUFFIX) || configs.contains(fileObject)) continue;
                    configs.add(fileObject);
                }
            }
        }
    }

    private synchronized List<FileObject> getConfigFiles() {
        return this.configFiles;
    }

    private synchronized void setConfigFiles(List<FileObject> configFiles, List<FileObject> configRoots) {
        this.configFiles = configFiles;
        this.configRoots = configRoots;
    }

    private synchronized List<FileObject> getConfigRoots() {
        return this.configRoots;
    }

    private List<FileObject> getConfigFilesImpl() {
        List<FileObject> configs = this.getConfigFiles();
        if (configs != null) {
            return configs;
        }
        FileObject[] objects = ConfigurationUtils.getFacesConfigFiles(this.module);
        configs = Collections.synchronizedList(new LinkedList<FileObject>(Arrays.asList(objects)));
        this.configRoots = Collections.synchronizedList(new LinkedList());
        if (this.module.getDocumentBase() != null) {
            this.configRoots.add(this.module.getDocumentBase());
        }
        this.collectConfigurationFilesFromClassPath(this.sourcePath, configs, this.configRoots);
        this.collectConfigurationFilesFromClassPath(this.compilePath, configs, this.configRoots);
        this.setConfigFiles(configs, this.configRoots);
        return configs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    private void fireChange() {
        this.setConfigFiles(null, new LinkedList<FileObject>());
        this.changeSupport.firePropertyChange("configFiles", null, null);
    }

    private void initListeners() {
        Listener l = new Listener();
        this.sourcePath.addPropertyChangeListener((PropertyChangeListener)l);
        this.compilePath.addPropertyChangeListener((PropertyChangeListener)l);
        FileUtil.addFileChangeListener((FileChangeListener)l);
    }

    private class Listener
    implements FileChangeListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("entries")) {
                ModelUnit.this.fireChange();
            }
        }

        private boolean isRelevantFileEvent(FileEvent fe) {
            boolean res;
            String path = fe.getFile().getPath();
            boolean bl = res = path.endsWith("/web.xml") || path.endsWith("/WEB-INF/faces-config.xml") || path.endsWith("/META-INF/faces-config.xml") || path.endsWith(ModelUnit.FACES_CONFIG_SUFFIX) && fe.getFile().getParent() != null && fe.getFile().getParent().getNameExt().equals(ModelUnit.META_INF);
            if (!res && fe instanceof FileRenameEvent) {
                FileRenameEvent fre = (FileRenameEvent)fe;
                boolean bl2 = res = (fre.getName().equals("faces-config") || fre.getName().endsWith(".faces-config") || fre.getName().endsWith("web.xml")) && fre.getExt().equals("xml");
            }
            if (res) {
                res = false;
                for (FileObject fo : ModelUnit.this.getConfigRoots()) {
                    if (!FileUtil.isParentOf((FileObject)fo, (FileObject)fe.getFile())) continue;
                    res = true;
                    break;
                }
            }
            return res;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            if (this.isRelevantFileEvent(fe)) {
                ModelUnit.this.fireChange();
            }
        }

        public void fileChanged(FileEvent fe) {
            if (this.isRelevantFileEvent(fe)) {
                ModelUnit.this.fireChange();
            }
        }

        public void fileDeleted(FileEvent fe) {
            if (this.isRelevantFileEvent(fe)) {
                ModelUnit.this.fireChange();
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (this.isRelevantFileEvent((FileEvent)fe)) {
                ModelUnit.this.fireChange();
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

