/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.FacadeGeneratorProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBean;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.RuntimeJpaEntity;
import org.netbeans.modules.websvc.rest.codegen.model.TypeUtil;
import org.netbeans.modules.websvc.rest.support.Inflector;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class Util {
    public static final String TYPE_DOC_ROOT = "doc_root";
    static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static Map<String, Class> primitiveTypes;
    private static final FacadeGeneratorProvider FACADE_GENERATOR;

    public static void changeLabelInComponent(JComponent jComponent, String string, String string2) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setText(string2);
        }
    }

    public static void hideLabelAndLabelFor(JComponent jComponent, String string) {
        JLabel jLabel = Util.findLabel(jComponent, string);
        if (jLabel != null) {
            jLabel.setVisible(false);
            Component component = jLabel.getLabelFor();
            if (component != null) {
                component.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] componentArray, Collection collection) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            collection.add(componentArray[i]);
            if (((Container)componentArray[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)componentArray[i]).getComponents(), collection);
        }
    }

    public static JLabel findLabel(JComponent jComponent, String string) {
        Vector vector = new Vector();
        Util.getAllComponents(jComponent.getComponents(), vector);
        for (Component component : vector) {
            JLabel jLabel;
            if (!(component instanceof JLabel) || !(jLabel = (JLabel)component).getText().equals(string)) continue;
            return jLabel;
        }
        return null;
    }

    public static String getClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(0, n);
        }
        return "";
    }

    public static SourceGroup getClassSourceGroup(Project project, String string) {
        SourceGroup[] sourceGroupArray;
        String string2 = string.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(project)) {
            FileObject fileObject = sourceGroup.getRootFolder().getFileObject(string2);
            if (fileObject == null) continue;
            return sourceGroup;
        }
        return null;
    }

    public static void mergeSteps(WizardDescriptor wizardDescriptor, WizardDescriptor.Panel[] panelArray, String[] stringArray) {
        int n;
        String[] stringArray2;
        Object object = wizardDescriptor.getProperty(WIZARD_PANEL_CONTENT_DATA);
        if (object instanceof String[]) {
            stringArray2 = (String[])object;
            n = stringArray2.length;
            if (n > 0 && "...".equals(stringArray2[n - 1])) {
                --n;
            }
        } else {
            stringArray2 = null;
            n = 0;
        }
        String[] stringArray3 = new String[n + panelArray.length];
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        Util.setSteps(panelArray, stringArray, stringArray3, n);
    }

    private static void setSteps(WizardDescriptor.Panel[] panelArray, String[] stringArray, String[] stringArray2, int n) {
        int n2 = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < panelArray.length; ++i) {
            String string;
            JComponent jComponent = (JComponent)panelArray[i].getComponent();
            String string2 = string = i < n2 ? stringArray[i] : null;
            if (string == null) {
                string = jComponent.getName();
            }
            jComponent.putClientProperty(WIZARD_PANEL_CONTENT_DATA, stringArray2);
            jComponent.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, new Integer(i));
            jComponent.getAccessibleContext().setAccessibleDescription(string);
            stringArray2[i + n] = string;
        }
    }

    public static void setSteps(WizardDescriptor.Panel[] panelArray, String[] stringArray) {
        Util.setSteps(panelArray, stringArray, stringArray, 0);
    }

    public static String lowerFirstChar(String string) {
        if (string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.setCharAt(0, Character.toLowerCase(string.charAt(0)));
        return stringBuilder.toString();
    }

    public static String upperFirstChar(String string) {
        if (string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.setCharAt(0, Character.toUpperCase(string.charAt(0)));
        return stringBuilder.toString();
    }

    public static String deriveResourceClassName(String string) {
        return Util.upperFirstChar(string) + "Resource";
    }

    public static String deriveUri(String string, String string2) {
        if (string.length() == 0 || string2 == null || string2.length() == 0 || string2.charAt(0) != '/') {
            return string2;
        }
        string = Util.lowerFirstChar(string);
        string = Util.pluralize(string);
        String string3 = string2;
        String string4 = null;
        int n = string2.indexOf(123);
        if (n > -1) {
            string4 = string3.substring(n - 1);
            if ((string3 = string3.substring(0, n - 1)).length() == 0) {
                return string2;
            }
        }
        if ((n = string3.lastIndexOf(47)) == -1) {
            return string2;
        }
        string3 = string3.substring(0, n);
        String string5 = string3 + "/" + string;
        if (string4 != null) {
            string5 = string5 + string4;
        }
        return string5;
    }

    public static String deriveContainerClassName(String string) {
        return Util.deriveResourceClassName(Inflector.getInstance().pluralize(string));
    }

    public static String pluralize(String string) {
        String string2 = Inflector.getInstance().pluralize(string);
        if (string.equals(string2)) {
            return string + "Collection";
        }
        return string2;
    }

    public static String[] ensureTypes(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0].length() == 0) {
            stringArray = new String[]{String.class.getName()};
        }
        return stringArray;
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        SourceGroup[] sourceGroupArray = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray2 = sources.getSourceGroups(TYPE_DOC_ROOT);
        SourceGroup[] sourceGroupArray3 = SourceGroupSupport.getJavaSourceGroups(project);
        if (sourceGroupArray2 != null && sourceGroupArray3 != null) {
            sourceGroupArray = new SourceGroup[sourceGroupArray2.length + sourceGroupArray3.length];
            System.arraycopy(sourceGroupArray2, 0, sourceGroupArray, 0, sourceGroupArray2.length);
            System.arraycopy(sourceGroupArray3, 0, sourceGroupArray, sourceGroupArray2.length, sourceGroupArray3.length);
        }
        if (sourceGroupArray == null || sourceGroupArray.length == 0) {
            sourceGroupArray = sources.getSourceGroups("generic");
        }
        return sourceGroupArray;
    }

    public static Class getType(Project project, String string) {
        List<ClassPath> list = SourceGroupSupport.gerClassPath(project);
        for (ClassPath classPath : list) {
            try {
                Class clazz = Util.getPrimitiveType(string);
                if (clazz != null) {
                    return clazz;
                }
                ClassLoader classLoader = classPath.getClassLoader(true);
                clazz = Util.getGenericRawType(string, classLoader);
                if (clazz != null) {
                    return clazz;
                }
                if (classLoader == null) continue;
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static Class getPrimitiveType(String string) {
        if (primitiveTypes == null) {
            primitiveTypes = new HashMap<String, Class>();
            primitiveTypes.put("int", Integer.class);
            primitiveTypes.put("int[]", int[].class);
            primitiveTypes.put("java.lang.Integer[]", Integer[].class);
            primitiveTypes.put("boolean", Boolean.class);
            primitiveTypes.put("boolean[]", boolean[].class);
            primitiveTypes.put("java.lang.Boolean[]", Boolean[].class);
            primitiveTypes.put("byte", Byte.class);
            primitiveTypes.put("byte[]", byte[].class);
            primitiveTypes.put("java.lang.Byte[]", Byte[].class);
            primitiveTypes.put("char", Character.class);
            primitiveTypes.put("char[]", char[].class);
            primitiveTypes.put("java.lang.Character[]", Character[].class);
            primitiveTypes.put("double", Double.class);
            primitiveTypes.put("double[]", double[].class);
            primitiveTypes.put("java.lang.Double[]", Double[].class);
            primitiveTypes.put("float", Float.class);
            primitiveTypes.put("float[]", float[].class);
            primitiveTypes.put("java.lang.Float[]", Float[].class);
            primitiveTypes.put("long", Long.class);
            primitiveTypes.put("long[]", long[].class);
            primitiveTypes.put("java.lang.Long[]", Long[].class);
            primitiveTypes.put("short", Short.class);
            primitiveTypes.put("short[]", short[].class);
            primitiveTypes.put("java.lang.Short[]", Short[].class);
        }
        return primitiveTypes.get(string);
    }

    public static Class getGenericRawType(String string, ClassLoader classLoader) {
        int n = string.indexOf(60);
        if (n < 1) {
            return null;
        }
        String string2 = string.substring(0, n);
        try {
            return classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.global.log(Level.INFO, "", classNotFoundException);
            return null;
        }
    }

    public static boolean isValidPackageName(String string) {
        String[] stringArray;
        if (string == null || string.endsWith(".")) {
            return false;
        }
        for (String string2 : stringArray = string.split("\\.")) {
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public static ClasspathInfo getClasspathInfo(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        return ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot"), (ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile"), (ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source"));
    }

    public static PersistenceHelper.PersistenceUnit getPersistenceUnit(WizardDescriptor wizardDescriptor, Project project) {
        PersistenceHelper.PersistenceUnit persistenceUnit = (PersistenceHelper.PersistenceUnit)wizardDescriptor.getProperty("PersistenceUnit");
        if (persistenceUnit == null) {
            persistenceUnit = new PersistenceHelper(project).getPersistenceUnit();
            wizardDescriptor.putProperty("PersistenceUnit", (Object)persistenceUnit);
        }
        return persistenceUnit;
    }

    public static boolean isValidUri(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/ ");
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("{")) {
                if (string2.length() > 2 && string2.endsWith("}")) {
                    String string3 = string2.substring(1, string2.length() - 1);
                    if (!Utilities.isJavaIdentifier((String)string3)) {
                        return false;
                    }
                    if (hashSet.contains(string3)) {
                        return false;
                    }
                    hashSet.add(string3);
                    continue;
                }
                return false;
            }
            if (!string2.contains("{") && !string2.contains("}")) continue;
            return false;
        }
        return true;
    }

    public static boolean isCDIEnabled(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            return Util.isCDIEnabled(project);
        }
        return false;
    }

    public static boolean isCDIEnabled(Project project) {
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            Profile profile = webModule.getJ2eeProfile();
            if (!profile.equals(Profile.JAVA_EE_6_FULL) && !profile.equals(Profile.JAVA_EE_6_WEB)) {
                return false;
            }
            FileObject fileObject = webModule.getWebInf();
            if (fileObject != null && fileObject.getFileObject("beans.xml") != null) {
                return true;
            }
        }
        return false;
    }

    public static void generateRESTFacades(Project project, Set<Entity> set, EntityResourceBeanModel entityResourceBeanModel, FileObject fileObject, String string) throws IOException {
        Object object;
        Collection<EntityResourceBean> collection = entityResourceBeanModel.getResourceBeans();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (EntityResourceBean object3 : collection) {
            EntityClassInfo entityClassInfo;
            if (!object3.isItem() || (object = (entityClassInfo = object3.getEntityClassInfo()).getIdFieldInfo()) == null) continue;
            hashMap.put(entityClassInfo.getType(), ((EntityClassInfo.FieldInfo)object).getType());
        }
        HashMap hashMap2 = new HashMap();
        for (Entity entity : set) {
            object = (String)hashMap.get(entity.getClass2());
            hashMap2.put(entity.getClass2(), object == null ? String.class.getName() : object);
        }
        Map<String, String> map = Util.initEntityNames(project);
        object = FACADE_GENERATOR.createGenerator();
        for (Map.Entry entry : hashMap2.entrySet()) {
            object.generate(project, map, fileObject, (String)entry.getKey(), (String)entry.getValue(), string, false, false, true);
        }
    }

    public static Set<Entity> getEntities(Project project, Set<FileObject> set) throws IOException {
        final HashSet<Entity> hashSet = new HashSet<Entity>();
        for (FileObject fileObject : set) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    if (typeElement != null) {
                        String string = null;
                        TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.persistence.Table");
                        if (typeElement2 != null && (string = TypeUtil.getAnnotationValueName(compilationController, typeElement, typeElement2)) == null && (typeElement2 = compilationController.getElements().getTypeElement("javax.persistence.Entity")) != null) {
                            string = TypeUtil.getAnnotationValueName(compilationController, typeElement, typeElement2);
                        }
                        if (string != null) {
                            hashSet.add(new RuntimeJpaEntity(typeElement, string));
                        }
                    }
                }
            }, true);
        }
        return hashSet;
    }

    private static Map<String, String> initEntityNames(Project project) throws IOException {
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)project.getProjectDirectory());
            MetadataModel metadataModel = entityClassScope.getEntityMappingsModel(true);
            Future future = metadataModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                public Void run(EntityMappingsMetadata entityMappingsMetadata) throws Exception {
                    for (Entity entity : entityMappingsMetadata.getRoot().getEntity()) {
                        hashMap.put(entity.getClass2(), entity.getName());
                    }
                    return null;
                }
            });
            future.get();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return hashMap;
    }

    static {
        FACADE_GENERATOR = (FacadeGeneratorProvider)Lookup.getDefault().lookup(FacadeGeneratorProvider.class);
    }
}

