/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class Utils {
    public static String stripPackageName(String name) {
        int genericIndex = name.indexOf("<");
        int index = 0;
        if (genericIndex > 0) {
            String className = name.substring(0, genericIndex);
            index = className.lastIndexOf(".");
        } else {
            index = name.lastIndexOf(".");
        }
        if (index > 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static Collection<String> sortKeys(Collection<String> keys) {
        TreeSet<String> sortedKeys = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.compareTo(str2);
            }
        });
        sortedKeys.addAll(keys);
        return sortedKeys;
    }

    public static void showMethod(FileObject source, String methodName) {
        try {
            LineCookie lc;
            DataObject dataObj = DataObject.find((FileObject)source);
            JavaSource javaSource = JavaSource.forFileObject((FileObject)source);
            SaveCookie sc = (SaveCookie)dataObj.getCookie(SaveCookie.class);
            if (sc != null) {
                sc.save();
            }
            if ((lc = (LineCookie)dataObj.getCookie(LineCookie.class)) != null) {
                final long[] position = JavaSourceHelper.getPosition(javaSource, methodName);
                final Line line = lc.getLineSet().getOriginal((int)position[0]);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.NONE, (int)position[1]);
                    }
                });
            }
        }
        catch (Exception de) {
            Exceptions.printStackTrace((Throwable)de);
        }
    }

    public static Method getValueOfMethod(Class type) {
        try {
            Method method = type.getDeclaredMethod("valueOf", String.class);
            if (method == null || !Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getConstructorWithStringParam(Class type) {
        try {
            return type.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Project[] getProjectsFromLookup(Lookup lookup) {
        HashSet<Project> result = new HashSet<Project>();
        for (Project p : lookup.lookupAll(Project.class)) {
            result.add(p);
        }
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            result.add(p);
        }
        Project[] projectsArray = result.toArray(new Project[result.size()]);
        return projectsArray;
    }

    public static FileObject findBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }
}

