/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.model.api.SubResourceLocator;
import org.netbeans.modules.websvc.rest.nodes.SubResourceLocatorNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

class SubResourceLocatorsChildrenFactory
extends ChildFactory<SubResourceLocatorNode> {
    private static final Comparator<SubResourceLocator> COMPARATOR = new SubResourceLocatorComparator();
    private Project project;
    private RestServicesModel model;
    private String serviceName;

    SubResourceLocatorsChildrenFactory(Project project, RestServicesModel restServicesModel, String string) {
        this.project = project;
        this.model = restServicesModel;
        this.serviceName = string;
    }

    protected boolean createKeys(final List<SubResourceLocatorNode> list) {
        try {
            this.model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                    RestServices restServices = restServicesMetadata.getRoot();
                    RestServiceDescription restServiceDescription = restServices.getRestServiceDescription(SubResourceLocatorsChildrenFactory.this.serviceName);
                    if (restServiceDescription != null) {
                        String string = restServiceDescription.getClassName();
                        List list2 = restServiceDescription.getMethods();
                        ArrayList<SubResourceLocator> arrayList = new ArrayList<SubResourceLocator>(list2.size());
                        for (RestMethodDescription restMethodDescription : list2) {
                            if (!(restMethodDescription instanceof SubResourceLocator)) continue;
                            arrayList.add((SubResourceLocator)restMethodDescription);
                        }
                        Collections.sort(arrayList, COMPARATOR);
                        for (SubResourceLocator subResourceLocator : arrayList) {
                            list.add(new SubResourceLocatorNode(SubResourceLocatorsChildrenFactory.this.project, string, subResourceLocator));
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return true;
    }

    protected Node createNodeForKey(SubResourceLocatorNode subResourceLocatorNode) {
        return subResourceLocatorNode;
    }

    private static class SubResourceLocatorComparator
    implements Comparator<SubResourceLocator> {
        private SubResourceLocatorComparator() {
        }

        @Override
        public int compare(SubResourceLocator subResourceLocator, SubResourceLocator subResourceLocator2) {
            String string = SubResourceLocatorNode.getKey(subResourceLocator);
            String string2 = SubResourceLocatorNode.getKey(subResourceLocator2);
            return string.compareTo(string2);
        }
    }
}

