/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.apt.impl.support.APTDriverImpl;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.openide.filesystems.FileSystem;

public final class APTDriver {
    private static final Map<FileSystem, APTDriverImpl> drivers = new WeakHashMap<FileSystem, APTDriverImpl>();

    private APTDriver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static APTDriverImpl getInstance(APTFileBuffer buffer) {
        FileSystem fs = buffer.getFileSystem();
        Class<APTDriver> clazz = APTDriver.class;
        synchronized (APTDriver.class) {
            APTDriverImpl impl = drivers.get(fs);
            if (impl == null) {
                impl = new APTDriverImpl();
                drivers.put(fs, impl);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return impl;
        }
    }

    public static APTFile findAPTLight(APTFileBuffer buffer) throws IOException {
        return APTDriver.getInstance(buffer).findAPT(buffer, false, "Unknown Language");
    }

    public static APTFile findAPT(APTFileBuffer buffer, String lang) throws IOException {
        return APTDriver.getInstance(buffer).findAPT(buffer, true, lang);
    }

    public static void invalidateAPT(APTFileBuffer buffer) {
        APTDriver.getInstance(buffer).invalidateAPT(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateAll() {
        Class<APTDriver> clazz = APTDriver.class;
        synchronized (APTDriver.class) {
            for (APTDriverImpl driver : drivers.values()) {
                driver.invalidateAll();
            }
            drivers.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Class<APTDriver> clazz = APTDriver.class;
        synchronized (APTDriver.class) {
            for (APTDriverImpl driver : drivers.values()) {
                driver.close();
            }
            drivers.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

